/**
 * Copyright butchi ( http://wonderfl.net/user/butchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wo6F
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(backgroundColor ="#000000", width = "465", height = "465", frameRate = "30")]
    public class Main extends Sprite
    {
        public static var stageWidth:Number = 465;
        public static var stageHeight:Number = 465;
        private var rot:Number = 0; // 回転の角度(rad)
        public var star:Vector.<Star>; // 星のSprite
        private var starNum:int = 1000; // 星の個数
        public function Main()
        {
            var bg:Sprite = new Sprite(); // キャプチャで背景色が反映されてなかったので黒の矩形を描画
            bg.graphics.beginFill(0x000000);
            bg.graphics.drawRect(0,0,stageWidth,stageHeight);
            addChild(bg);
            
            star = new Vector.<Star>(starNum);
            for (var i_counter:uint=0; i_counter<starNum; i_counter++) {
                star[i_counter] = new Star();
                addChild(star[i_counter]);
            }
            addEventListener(Event.ENTER_FRAME, draw);
        }
        public function draw(evt:Event):void {
            for (var i_counter:uint=0; i_counter<starNum; i_counter++) {
                star[i_counter].graphics.lineTo(star[i_counter].rad*Math.cos(rot-star[i_counter].theta),star[i_counter].rad*Math.sin(rot-star[i_counter].theta));
            }
            rot += 0.0001;
            return;
        }
    }
}
import flash.display.Sprite;

class Star extends Sprite {
    public var size:Number;
    public var rad:Number;
    public var color:uint;
    public var theta:Number;
    public function Star() {
        x = Main.stageWidth / 2;
        y = Main.stageHeight / 2;
        size = 2*Math.random(); // 星の大きさ
        // posX, posYは分布を均等にしてradを求める用で位相はthetaで改めて設定する
        var posX:Number = Main.stageWidth*(Math.random()-0.5)*2;
        var posY:Number = Main.stageWidth*(Math.random()-0.5)*2;
        rad = Math.sqrt(posX*posX+posY*posY); // 星の中心からの距離
        color = 0xFFFFFF - ((96 * Math.random())<<16) - ((96 * Math.random())<<8) - (96 * Math.random()); // 星の色: 少し明るめのランダム色
        theta = 2*Math.PI*Math.random(); //星の初期角度（ラジアン）
        /* 小さい星を最初から表示させようとしたが断念
        graphics.lineStyle(0,0x000000,0);
        graphics.beginFill(color);
        graphics.drawCircle(rad*Math.cos(-theta),rad*Math.sin(-theta),size/2);
        */
        graphics.lineStyle(size, color);
        graphics.moveTo(rad*Math.cos(-theta),rad*Math.sin(-theta));
    }
}
