/**
 * Copyright poepoemix ( http://wonderfl.net/user/poepoemix )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wo2X
 */

package
{
    import com.bit101.components.*;
    import flash.display.Sprite;
    import flash.events.Event;

    [SWF(backgroundColor=0xeeeeee)]
    public class MyClass extends Sprite
    {
        private var myPanel:Panel;
        public function MyClass()
        {
            ColorSetup.blue();
            Logger.setup(stage, Logger.INFO);
            myPanel = new Panel(this, 10, 10);
            myPanel.setSize(stage.stageWidth - 20, stage.stageHeight - 20);
            ColorSetup.wText();
            var log:PushButton = new PushButton(myPanel, myPanel.width - 40, myPanel.height - 20, "log", function():void{Logger.toggle()});
            log.setSize(40, 20);
            ColorSetup.bText();
        }
    }
}
import flash.events.Event;
import com.bit101.components.*;
class ColorSetup {
    private static function basic():void {
        Style.PANEL      = 0xF0F0F0; // panel only
        Style.BACKGROUND = 0xFFFFFF; // 全コンポーネントの背景色
        Style.DROPSHADOW = 0xC0C0C0; // 全コンポーネントの影(背景色と同じにすることでのっぺりにできる。)
        Style.INPUT_TEXT = 0x303030; // text on input field
        Style.LABEL_TEXT = 0x303030; // label data
        Style.embedFonts = false; // オリジナルフォントを使わないことで日本語がうてるようになる。
        Style.fontName   = "Arial";
        Style.fontSize   = 12;
    }
    public static function wText():void {Style.INPUT_TEXT = Style.LABEL_TEXT = 0xFFFFFF;}
    public static function bText():void {Style.INPUT_TEXT = Style.LABEL_TEXT = 0x303030;}
    public static function red():void    {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0xDA4F49;}
    public static function blue():void   {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x0074CC;}
    public static function orange():void {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0xFB9406;}
    public static function green():void  {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x5BB75B;}
    public static function aqua():void   {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x49AFCD;}
    public static function gray():void   {basic();Style.BUTTON_FACE = Style.PROGRESS_BAR = 0x414141;}
}
class Logger {
    public static const FATAL:int = 0, WARN:int = 1, INFO:int = 2, DEBUG:int = 3;
    private static var window:Window, field:TextArea;
    private static var logStack:Array = [];
    private static var level:int, max:int;
    public static function setup(base:*, level:int=INFO, max:int=2000):void {
        Logger.max = max;Logger.level = level;
        window = new Window(base, 20, 20, "log2");
        window.shadow = true;window.hasCloseButton = true;
        window.setSize(base.stageWidth - 40, base.stageHeight - 40);
        window.addEventListener(Event.CLOSE, function(e:Event):void {Logger.hide();});
        field = new TextArea(window, 0, 20);
        field.setSize(window.width, window.height - 20);
        hide();
    }
    private static function add(obj:*, level:String):void {
        logStack.push((new Date().toLocaleTimeString()) + "[" + level + "]" + obj.toString());
        logStack = logStack.slice(logStack.length - max, logStack.length);
        field.text = logStack.join("\n");
    }
    public static function error(obj:*):void {add(obj, "ERROR");}
    public static function warn(obj:*):void  {if(level < WARN)  {return;}add(obj, "WARN");}
    public static function info(obj:*):void  {if(level < INFO)  {return;}add(obj, "INFO");}
    public static function debug(obj:*):void {if(level < DEBUG) {return;}add(obj, "DEBUG");}
    public static function toggle():void {window.visible = !window.visible;}
    public static function hide():void {window.visible = false;}
}
