/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wnyn
 */

package 
{
    import caurina.transitions.properties.ColorShortcuts;
    import caurina.transitions.Tweener;
    import com.bit101.components.Label;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.SoundMixer;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author gaina
     * Music by AlainMikuni
     */
    
    public class Main extends Sprite 
    {
        private var array:Array = [];
        private var thirty:Array = [];
        private var _over:Sprite;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            ColorShortcuts.init();
            
            thirty = ThirtyArray();
            array = ThirtDots();
            
            _over = new Sprite();
            _over.graphics.beginFill(0);
            _over.graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            _over.graphics.endFill();
            _over.blendMode = "add";
            addChild(_over);
            
            var _label:Label = new Label(stage, 0, 0, "HAPPY BIRTHDAY ORE(30)");
            _label.x = stage.stageWidth / 2 - _label.width / 2;
            _label.y = stage.stageHeight / 2 - _label.height / 2;
            
            addEventListener(Event.ENTER_FRAME, loop);
            
            var _sound:PlaySound = new PlaySound("http://www.takasumi-nagai.com/soundfiles/sound007.mp3");
        }
        
        private function loop(e:Event):void 
        {
            var _bytes01:ByteArray = new ByteArray();
            var _bytes02:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytes01, false, 0);
            SoundMixer.computeSpectrum(_bytes02, false, 0);
            var p:Number = 0;
            for (var i:int = 0; i < 256; i++)
            {
                var _sp:Sprite = array[i] as Sprite;
                var t:int = thirty[i] as int;
                var data:Number = _bytes01.readFloat();
                if (t == 0) {
                    Tweener.addTween(_sp, { scaleX:data * 4, scaleY:data * 4, time:0.5 } );
                }
                p += _bytes02.readFloat();
            }
            if (p > 9)
            {
                Tweener.addTween(_over, {_color:Math.random()*0xFFFFFF } );
            }
        }
        
        private function ThirtyArray():Array
        {
            var _thirty:Array =
            [
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,1,1,1,1,1,0,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,
            0,1,1,1,1,1,0,0,0,1,1,1,1,1,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
            0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
            ];
            
            return _thirty
        }
        
        private function ThirtDots():Array
        {
            var _array:Array = [];
            var _w:Number = stage.stageWidth / 16;
            var _h:Number = stage.stageHeight / 16;
            for (var i:int = 0; i < 256; i++)
            {
                var t:int = thirty[i] as int;
                var _sp:Sprite = new Sprite();
                if (t == 0) {
                    _sp.graphics.beginFill(0);
                    _sp.graphics.drawCircle(0, 0, _w / 2);
                }else {
                    _sp.graphics.beginFill(0xFFFF00);
                    _sp.graphics.drawRect(-_w/2, -_h/2, _w, _h);
                }
                _sp.graphics.endFill()
                _sp.x = _w /2 + (i % 16) * _w;
                _sp.y = _h / 2 + _h * Math.floor(i / 16);
                //_rect.blendMode = "invert";
                addChild(_sp);
                _array.push(_sp);
            }
            return _array;
        }
        
    }
    
}

import flash.events.Event;
import flash.media.Sound;
import flash.media.SoundLoaderContext;
import flash.media.SoundTransform;
import flash.net.URLRequest;

class PlaySound
{
    private var sound:Sound;

        public function PlaySound(url:String)
        {
            sound = new Sound();
            var _context:SoundLoaderContext = new SoundLoaderContext(1000, true);
            sound.addEventListener(Event.COMPLETE, SoundLoadeComplete);
            sound.load(new URLRequest(url), _context);
        }
        
        private function SoundLoadeComplete(e:Event):void 
        {
            sound.play(0, 10, new SoundTransform(0.3, 0));
        }
}