/**
 * Copyright hourglasseye ( http://wonderfl.net/user/hourglasseye )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wne2
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * Inspired by this 9gag post http://9gag.com/gag/475066
     * @author Justin Richard S. Mata
     */
    public class Main extends Sprite 
    {
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            var heart:Heart = new Heart();
            heart.x = stage.stageWidth * 0.5;
            heart.y = stage.stageHeight * 0.5;
            addChild(heart);
        }
        
    }
    
}

import flash.display.Sprite;
import flash.events.Event;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.utils.Timer;

class Heart extends Sprite
{
    private static const START_SCALE:Number = 2;
    private static const SCALE_SPEED:Number = 0.00625;
    private static const MOVE_SPEED:Number = 3;
    
    private var lastTime:Number;
    private var elapsedTime:Number;
    private var scale:Number;
    private var hasInitialized:Boolean;
    private var color:uint;
    
    public function Heart()
    {
        elapsedTime = 0;
        scale = START_SCALE;
        lastTime = new Date().getTime();
        hasInitialized = false;
        color = 0xFF0000;
        
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }
    
    private function getPoint(time:Number) : Point
    {
        var t:Number = time;
        return new Point(
            16 * Math.pow(Math.sin(t), 3),
            13 * Math.cos(t) - 5 * Math.cos(2 * t) - 2 * Math.cos(3 * t) - Math.cos(4 * t)
        );
    }
    
    private function onEnterFrame(e:Event):void 
    {
        var thisTime:Number = new Date().getTime();
        var deltaTime:Number = (thisTime - lastTime) * 0.001 * MOVE_SPEED;
        if(deltaTime > 0.33) deltaTime = 0;
        lastTime = thisTime;
        
        scale += SCALE_SPEED * deltaTime;
        elapsedTime += deltaTime;
        
        var point:Point = getPoint(elapsedTime);
        graphics.lineStyle(2, color);
        if (!hasInitialized)
        {
            hasInitialized = true;
            graphics.moveTo(point.x * scale, -point.y * scale);
        }
        else
        {
            graphics.lineTo(point.x * scale, -point.y * scale);
        }
    }
}