/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wnHk
 */

/*
とりあえず引力の実装を始めました。
まずは惑星一個からテストです。
なんだかとりあえず的な激しく汚いコードですが…
*/
package  {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point
    
    [SWF(width=465, height=465, backgroundColor=0,frameRate=30)]
    
    public class Main extends Sprite{
        
        private var _satList:Vector.<Sat> = new Vector.<Sat> 
        private var _satNum:int = 500

        public function Main() {
            var base:Base = new Base(0,stage.stageWidth,stage.stageHeight)
            addChild(base)            
           for(var i:int=0; i<_satNum; i++){
               var sat:Sat = new Sat()
               sat.x = Math.floor(Math.random()*stage.stageWidth)
               sat.y = Math.floor(Math.random()*stage.stageHeight)
               addChild(sat)
               _satList.push(sat)
           }
           //
            createPlanet(0xFFFFFF, 15, 0.1, 150)            
        }
        
        private function createPlanet(color:int, size:int, speed:Number, rad:Number):void{
            var circle:Circle = new Circle(color, size, speed, rad)
            circle.x = stage.stageWidth/2
            circle.y = stage.stageHeight/2
            circle.pos = new Point(circle.x, circle.y)
            addChild(circle)
            circle.addEventListener(Event.ENTER_FRAME, update)
        }
        
        private function update(e:Event):void{
            e.target.x = e.target.motion.setPos(e.target.pos).x
            e.target.y = e.target.motion.setPos(e.target.pos).y
            //
            for(var i:int=0; i<_satNum; i++){
               var p:Point = new Point()
               p=satMove(_satList[i], Math.random()*0.5+0.1)
                _satList[i].x += e.target.gravity(_satList[i]).x + p.x
                _satList[i].y+= e.target.gravity(_satList[i]).y + p.y
            }
        }
        
        private function satMove(target:Sprite ,speed:Number):Point{
            var p:Point = new Point()
            var rad:Number = Math.atan2(stage.stageHeight/2-target.y, target.stage.stageWidth/2-target.x);
            var rot:Number = rad*180/Math.PI;
            p.x = Math.cos(rot*Math.PI/180)*speed
            p.y = Math.sin(rot*Math.PI/180)*speed
            target.rotation = rot
            return p
        }

    }
    
}

//
import flash.display.Sprite;

class Sat extends Sprite{
    public function Sat(){
        var maxColor:int = 0xFFFFFF
        graphics.beginFill(Math.floor(Math.random()*(maxColor/2)+(maxColor/2)))
        graphics.drawRect(-5, -5, 10, 10)
        graphics.endFill()
    }   
}

//class Circle
import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Point;

class Circle extends Sprite{
    private var _pos:Point = new Point()
    private var _speed:Number
    private var _radius:Number
    private var _motion:CircleMotion;
    private var _gravity:Number = 10
    private var _targetRot:Number
    
    public function Circle(color:int,r:int, speed:Number, rad:Number):void{
        _speed = speed
        _radius = rad
        //
        var colors:Array = [color, 0]
        var alphas:Array = [1, 1]
        var ratios:Array = [0, 50]
        graphics.beginGradientFill("radial", colors, alphas, ratios)
        graphics.drawCircle(0,0,r)
        graphics.endFill()
        //
        _motion = new CircleMotion(_speed, _radius)
    }
    
    public function gravity(target:Sprite):Point{
        var p:Point = new Point()
        var dist:Number = Math.sqrt((this.x-target.x)*(this.x-target.x)+(this.y-target.y)*(this.y-target.y));
        var rad:Number = Math.atan2(this.y-target.y, this.x-target.x);
        var rot:Number = rad*180/Math.PI;
        p.x = Math.cos(rot*Math.PI/180)*_gravity/(dist/10)
        p.y = Math.sin(rot*Math.PI/180)*_gravity/(dist/10)
        _targetRot = rot
        return p
    }
    
    public function get motion():CircleMotion{
        return _motion
    }
    public function set pos(p:Point):void{
        _pos = p
    }
    public function get pos():Point{
        return _pos
    }
    public function set speed(s:Number):void{
        _speed = s
    }
    public function get speed():Number{
        return _speed
    }
    public function set radius(r:Number):void{
        _radius = r
    }
    public function get radius():Number{
        return _radius
    }
    public function get targetRot():Number{
        return _targetRot
    }
}

//class CircreMotion
import flash.geom.Point;

class CircleMotion{
   private var _angle:Number;
   private var _speed:Number;
   private var _radius:Number;
   private var _point:Point = new Point()
   
   public function CircleMotion(speed:Number, rad:Number){
       _speed = speed
       _radius = rad
       _angle = (Math.floor(Math.random()*18))*10
   }
    
    public function setPos(pos:Point):Point{
        var radian:Number = _angle * Math.PI / 90;
        _point.x = pos.x + _radius * Math.cos(radian);
        _point.y = pos.y + _radius * Math.sin(radian);
        _angle += _speed;
        return _point
    }
    
    public function set speed(speed:Number):void{
        _speed = speed;
    }
    public function get speed():Number{
        return _speed;
    }
    public function set radius(rad:Number):void{
        _radius = rad;
    }
    public function get radius():Number{
        return _radius;
    }
}


//class Base
import flash.display.Sprite
class Base extends Sprite{
    public function Base(color:int,w:int,h:int):void{
        graphics.beginFill(color, 1)
        graphics.drawRect(0,0,w,h)
        graphics.endFill()
    }
}