/**
 * Copyright fukt ( http://wonderfl.net/user/fukt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wnDp
 */

// forked from Aquioux's forked from: fladdict challenge for professionals (data.tron.clock)
// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    
    public class Professional extends Sprite {
        private var color1:uint;
        private var color2:uint;

        private var bitmapDataVector:Vector.<BitmapData>;
	
        private const LETTER_WIDTH:uint  = 4;
        private const LETTER_HEIGHT:uint = 6;

        private const FIELD_WIDTH:uint  = LETTER_WIDTH * 25;
        private const FIELD_HEIGHT:uint = LETTER_HEIGHT;
        private var fieldBitmapData:BitmapData = new BitmapData(FIELD_WIDTH, FIELD_HEIGHT, false, 0x0);

        private const CNT_WIDTH:uint  = FIELD_WIDTH  / LETTER_WIDTH;
        private const CNT_HEIGHT:uint = FIELD_HEIGHT / LETTER_HEIGHT;

        private var model:Model;

        private var scale:uint = Math.random() * 3 + 1;;
        
        
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;

            color1 = (Math.random() < 0.5) ? 0xFFFFFF : 0x000000;
            color2 = (color1 - 0xFFFFFF) * -1;

            init();

            model = new Model();
            model.addEventListener(Model.MILLISECONDS_CHANGED, millisecondsChangeHandler);
            stage.addEventListener(MouseEvent.CLICK, clickHandler);
        }
        
        private function clickHandler(e:MouseEvent):void {
            init();
        }

        private function millisecondsChangeHandler(e:Event):void {
            var time:TimeDate = model.time
	
            var dateVector:Vector.<uint> = new Vector.<uint>();
            var cnt:uint;
            var denominator:uint

            var year:uint = time.year;
            cnt = 4;
            while (cnt--) {
                denominator = Math.pow(10, cnt);
                dateVector.push(year / denominator);
                year %= denominator;
            }
            dateVector.push(10);
	
            var month:uint = time.month;
            cnt = 2;
            while (cnt--) {
                denominator = Math.pow(10, cnt);
                dateVector.push(month / denominator);
                month %= denominator;
            }
            dateVector.push(10);

            var date:uint = time.date;
            cnt = 2;
            while (cnt--) {
                denominator = Math.pow(10, cnt);
                dateVector.push(date / denominator);
                date %= denominator;
            }
            dateVector.push(11);

            var hours:uint = time.hours;
            cnt = 2;
            while (cnt--) {
                denominator = Math.pow(10, cnt);
                dateVector.push(hours / denominator);
                hours %= denominator;
            }
            dateVector.push(12);

            var minutes:uint = time.minutes;
            cnt = 2;
            while (cnt--) {
                denominator = Math.pow(10, cnt);
                dateVector.push(minutes / denominator);
                minutes %= denominator;
            }
            dateVector.push(12);

            var seconds:uint = time.seconds;
            cnt = 2;
            while (cnt--) {
                denominator = Math.pow(10, cnt);
                dateVector.push(seconds / denominator);
                seconds %= denominator;
            }
            dateVector.push(12);

            var milliseconds:uint = time.milliseconds;
            cnt = 4;
            while (cnt--) {
                denominator = Math.pow(10, cnt);
                dateVector.push(milliseconds / denominator);
                milliseconds %= denominator;
            }
            dateVector.push(13);
	
            var len:uint = dateVector.length;
            for (var i:uint = 0; i < len; i++) {
                fieldBitmapData.copyPixels(
                    bitmapDataVector[dateVector[i]],
                    bitmapDataVector[0].rect,
                    new Point(i * LETTER_WIDTH, 0)
                );
            }
	
            graphics.clear();
            graphics.beginBitmapFill(fieldBitmapData, new Matrix(scale, 0, 0, scale, 0, 0), true, true);
            graphics.drawRect(0, 0, 1920, 1200);
            graphics.endFill();
        }

        private function init():void {
            decideColor();
            createPattern();
            scale = Math.random() * 3 + 1;
        }

        private function decideColor():void {
            color1 -= 0xFFFFFF
            color1 *= -1;
            color2 = (color1 - 0xFFFFFF) * -1;

            color1 |= 0xFF << 24;
            color2 |= 0xFF << 24;
        }

        private function createPattern():void {
            bitmapDataVector = Vector.<BitmapData>([
                createPatternBitmapData("EAAAE0"),	// 0
                createPatternBitmapData("444440"),	// 1
                createPatternBitmapData("E2E8E0"),	// 2
                createPatternBitmapData("E2E2E0"),	// 3
                createPatternBitmapData("AAE220"),	// 4
                createPatternBitmapData("E8E2E0"),	// 5
                createPatternBitmapData("E8EAE0"),	// 6
                createPatternBitmapData("E22220"),	// 7
                createPatternBitmapData("EAEAE0"),	// 8
                createPatternBitmapData("EAE220"),	// 9
                createPatternBitmapData("244480"),	// /
                createPatternBitmapData("00E000"),	// -
                createPatternBitmapData("040400"),	// :
                createPatternBitmapData("000000")	// SPACE
        ]);
    }


private function createPatternBitmapData(hexStr:String):BitmapData {
	var pattern:Array = [[0, 0, 0, 0],
						 [0, 0, 0, 0],
						 [0, 0, 0, 0],
						 [0, 0, 0, 0],
						 [0, 0, 0, 0],
						 [0, 0, 0, 0]];
	var h:uint = LETTER_HEIGHT;
	for (var i:uint = 0; i < h; i++) {
		var bit:int = parseInt(hexStr.substr(i, 1), 16);
		var w:int = LETTER_WIDTH;
		while (bit >>= 1) {
			pattern[i][--w] = bit & 1;
		}
	}
	
	return BitmapPatternBuilder.build(pattern, [color1, color2]);
}




        
    }
}

	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.events.TimerEvent;
	import flash.utils.Timer;

	/**
	 * 時計 Model（MVC アーキテクチャー）
	 * @author YOSHIDA, Akio
	 */
	class Model extends EventDispatcher {
		public static const YEAR_CHANGED:String    = "yearChanged";		// 年
		public static const MONTH_CHANGED:String   = "monthChanged";	// 月
		public static const DATE_CHANGED:String    = "dateChanged";		// 日
		public static const HOURS_CHANGED:String   = "hoursChanged";	// 時
		public static const MINUTES_CHANGED:String = "minutesChanged";	// 分
		public static const SECONDS_CHANGED:String = "secondsChanged";	// 秒
		public static const MILLISECONDS_CHANGED:String = "millisecondsChanged";	// ミリ秒

		private var _time:TimeDate;
		public function get time():TimeDate { return _time; }

		public function Model() {
			// _time の初期化
			_time = new TimeDate(new Date());
			
			// タイマー開始
			var timer:Timer = new Timer(1, 0);
			timer.addEventListener(TimerEvent.TIMER, timerHandler);
			timer.start();
		}
		private function timerHandler(event:TimerEvent):void {
			var prev:TimeDate = _time.clone();				// 前回取得時間を待避
			var now:TimeDate  = new TimeDate(new Date());	// 現在時間を取得
			_time = now;
			
			// 前回の年月日時分秒と現在の年月日時分秒を比較評価
			if (prev.milliseconds != now.milliseconds) {
				dispatchEvent(new Event(MILLISECONDS_CHANGED));
			}
			if (prev.seconds != now.seconds) {
				dispatchEvent(new Event(SECONDS_CHANGED));
			}
			if (prev.minutes != now.minutes) {
				dispatchEvent(new Event(MINUTES_CHANGED));
			}
			if (prev.hours != now.hours) {
				dispatchEvent(new Event(HOURS_CHANGED));
			}
			if (prev.date != now.date) {
				dispatchEvent(new Event(DATE_CHANGED));
			}
			if (prev.month != now.month) {
				dispatchEvent(new Event(MONTH_CHANGED));
			}
			if(prev.year != now.year){
				dispatchEvent(new Event(YEAR_CHANGED));
			}
		}
	}

	/**
	 * 時計 Model（MVC アーキテクチャー）用データクラス
	 * Date オブジェクトから、年・月・日・時・分・秒を抽出し、保持する
	 * @author YOSHIDA, Akio
	 */
	class TimeDate {
		private var _year:uint;
		private var _month:uint;
		private var _date:uint;
		private var _hours:uint;
		private var _minutes:uint;
		private var _seconds:uint;
		private var _milliseconds:uint;
		
		public function TimeDate(date:Date) {
			if (date) {	// clone() では 引数に null を許す
				_year    = date.fullYear;
				_month   = date.month + 1;
				_date    = date.date;
				_hours   = date.hours;
				_minutes = date.minutes;
				_seconds = date.seconds;
				_milliseconds = date.milliseconds
			}
		}
		
		public function clone():TimeDate {
			var time:TimeDate = new TimeDate(null);
			time._year    = _year;
			time._month   = _month;
			time._date    = _date;
			time._hours   = _hours;
			time._minutes = _minutes;
			time._seconds = _seconds;
			time._milliseconds = _milliseconds;
			return time;
		}
		
		public function get year():uint { return _year; }
		public function get month():uint { return _month; }
		public function get date():uint { return _date; }
		public function get hours():uint { return _hours; }
		public function get minutes():uint { return _minutes; }
		public function get seconds():uint { return _seconds; }
		public function get milliseconds():uint { return _milliseconds; }
	}



/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}