/**
 * Copyright paulstamp1 ( http://wonderfl.net/user/paulstamp1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wnDe
 */

package {
    
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite 
    {
        public function FlashTest() {
            // write as3 code here..
            
            var grid:IntelliGrid = new IntelliGrid(20,20);
            addChild( new GridRenderer( grid,10 ) );
        }
    }
}

import flash.display.Sprite;
import flash.display.DisplayObject;
import flash.events.Event;

class GridRenderer extends Sprite
{
    private var _grid:IntelliGrid;
    private var _tileSize:Number;
    
    public function GridRenderer( grid:IntelliGrid, tileSize:Number )
    {
        _grid = grid;
        _tileSize = tileSize;
        
        this.addEventListener( Event.ENTER_FRAME, enterFrame );
    }
    
    private function enterFrame( event:Event ):void
    {
        this.graphics.beginFill(0);
        this.graphics.drawRect(0,0,100,100);
        
        draw();
    }

    
    public function draw():void
    {
        if( !_grid )
            return;
        
        //this.graphics.clear();
        for( var i:uint = 0; i < _grid.width; i++ )
        {
            for( var j:uint = 0; j < _grid.height; i++ )
            {
                var tile:IntelliTile = _grid.tile(i,j);
                this.graphics.lineStyle(0);
                this.graphics.beginFill(0x009900);
                this.graphics.drawRect(_tileSize*i, _tileSize*j, _tileSize, _tileSize);
                this.graphics.endFill();
            }
        }
    }
}

class IntelliGrid
{
    public var width:uint;
    public var height:uint;
    private var _grid:Array;
    
    public function IntelliGrid( width:uint, height:uint )
    {
        this.width = width;
        this.height = height;
        
        _grid = [];
        for( var i:uint = 0; i < width; i++ )
        {
            _grid[i] = [];
            for( var j:uint = 0; j < height; i++ )
            {
                _grid[i][j] = new IntelliTile();
            }
        }
    }
    
    public function tile( x:uint, y:uint ):IntelliTile
    {
        if( x >= _grid.length )
            return null;
           
        if( y >= _grid[x].length )
            return null;
             
        return _grid[x][y];
    }

}

class IntelliTile
{
    
}

