/**
 * Copyright matacat ( http://wonderfl.net/user/matacat )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wnD1
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.utils.getTimer;
    import flash.utils.Timer;
    
    public class Test extends Sprite
    {
        private const EX_PERIOD_MS:int = 1000;
        
        private const W:int = stage.stageWidth;
        private const H:int = stage.stageHeight;
        
        private var aDat:BitmapData = new BitmapData(W, H, true, 0x80FF0000);
        private var bDat:BitmapData = new BitmapData(W, H, true, 0x800000FF);
        private var a:Sprite            = new Sprite();
        private var b:CenterFixedBitmap = new CenterFixedBitmap(bDat);
        private function testA():void { a.rotation += 1; }
        private function testB():void { b.rotation += 1; }
        
        private function ex(sbj:Function):int
        {
            var cnt:int   = getTimer();
            var start:int = getTimer();
            
            while (cnt == start) {
                start = getTimer();
            }
            
            cnt = 0;
            do {
                cnt++;
                sbj();
            } while (getTimer() - start <= EX_PERIOD_MS);
            
            return cnt;
        }
        
        private var tf:TextField = new TextField();
        private var timer:Timer = new Timer(EX_PERIOD_MS + 1000);
        private var phase:int = 0;
        private var isRunning:Boolean = false;
        
        public function Test()
        {
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.background = true;
            tf.alpha = 0.9;
            tf.appendText("processing time(ms)\n");
            stage.addChild(tf);
            
            graphics.beginFill(0);
            graphics.moveTo(    W / 2,     0);
            graphics.lineTo(        0, H / 2);
            graphics.lineTo(    W / 4, H / 2);
            graphics.lineTo(    W / 4,     H);
            graphics.lineTo(W / 4 * 3,     H);
            graphics.lineTo(W / 4 * 3, H / 2);
            graphics.lineTo(        W, H / 2);
            graphics.lineTo(    W / 2,     0);
            graphics.drawCircle(W / 2, H / 2, 2);
            
            aDat.draw(this);
            bDat.draw(this);
            
            var bm:Bitmap = new Bitmap(aDat);
            a.addChild(bm);
            
            a.x = W / 2;
            a.y = H / 2;
            bm.x = -a.x;
            bm.y = -a.y;
            b.x = a.x;
            b.y = a.y;
            
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            stage.addEventListener(MouseEvent.CLICK, onClick);
        }
        
        private function onTimer(e:TimerEvent):void
        {
            var times:int = 0;
            switch (phase) {
                case 0:
                    times = ex(testA);
                    tf.appendText("a: " + (EX_PERIOD_MS / times) + "\n");
                    break;
                
                case 1:
                    removeChild(a);
                    addChild(b);
                    break;
                
                case 2:
                    times = ex(testB);
                    tf.appendText("b: " + (EX_PERIOD_MS / times) + "\n");
                    break;
                
                case 3:
                    timer.reset();
                    break;
            }
            phase++;
        }
        
        private function onClick(e:MouseEvent):void
        {
            if (!isRunning) {
                isRunning = true;
                
                a.rotation = 0;
                b.rotation = 0;
                phase = 0;
                if (b.parent == this) removeChild(b);
                addChild(a);
                
                timer.start();
                
                isRunning = false;
            }
        }
    }
}


import flash.display.Bitmap;
import flash.display.BitmapData;

class CenterFixedBitmap extends Bitmap
{
    private const DEG2PI:Number = Math.PI / 180;
    private var cx:Number = 0;
    private var cy:Number = 0;
    private var rx:Number = 0;
    private var ry:Number = 0;
    private var radius:Number = 0;
    private var phaseOffset:Number = 0;
    
    override public function get x():Number { return cx; }
    override public function set x(value:Number):void
    {
        cx = value;
        apply();
    }
    
    override public function get y():Number { return cy; }
    override public function set y(value:Number):void
    {
        cy = value;
        apply();
    }
    
    override public function set rotation(value:Number):void
    {
        super.rotation = value;
        rx = radius * Math.cos(value * DEG2PI + phaseOffset);
        ry = radius * Math.sin(value * DEG2PI + phaseOffset);
        apply();
    }
    
    override public function set bitmapData(value:BitmapData):void
    {
        super.bitmapData = value;
        init();
    }
    
    private function init():void
    {
        var w:int = bitmapData.width;
        var h:int = bitmapData.height;
        
        radius = Math.sqrt(w * w + h * h) / 2;
        phaseOffset = Math.atan2(h / -2, w / -2);
        rotation = rotation;
    }
    
    private function apply():void
    {
        super.x = cx + rx;
        super.y = cy + ry;
    }
    
    public function CenterFixedBitmap
    (
        bitmapData:BitmapData = null,
        pixelSnapping:String = "auto",
        smoothing:Boolean = false
    )
    {
        super(bitmapData, pixelSnapping, smoothing);
        if (bitmapData) init();
    }
}
