/**
 * Copyright nilab ( http://wonderfl.net/user/nilab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wmyr
 */

// forked from nilab's GuruGuru Cube for Papervision3D 2.0
package {
 
  import flash.events.*
  import flash.filters.GlowFilter;
  import org.papervision3d.materials.*;
  import org.papervision3d.materials.utils.*;
  import org.papervision3d.objects.primitives.*;
  import org.papervision3d.view.*;
 
  [SWF(backgroundColor="#000000", frameRate=30)]
 
  // for Papervision3D 2.0
  public class HelloWorld3dGlowCube extends BasicView {
 
    private var cube:Cube;
 
    public function HelloWorld3dGlowCube(){
 
      // make material list
      var wfm:WireframeMaterial = new WireframeMaterial(0x00FF00);
      var mlist:MaterialsList = new MaterialsList();
      mlist.addMaterial(wfm, "all");
 
      // make filters
      var filterList:Array = new Array();
      var glowFilter:GlowFilter = new GlowFilter(0xFFFFFF, 1, 16, 16, 2, 1, false, false);
      filterList.push(glowFilter);
 
      // make cube
      cube = new Cube(mlist, 600, 400, 100, 4, 2, 3);
      cube.useOwnContainer = true; // for filters
      cube.filters = filterList;
 
      // make world
      scene.addChild(cube);
      stage.addEventListener(Event.ENTER_FRAME, enterFrameListener);
    }
 
    private function enterFrameListener(event:Event):void {
      cube.yaw  ((200 - mouseX) / 120);
      cube.pitch((200 - mouseY) / 120);
      startRendering();
    }
  }
}

