/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wmnq
 */

package {
    import flash.display.Shape;
    import flash.utils.Timer;
    import flash.geom.Point;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.geom.Vector3D;
    
    [SWF(width='465', height='465', frameRate='30', backgroundColor='#222222')]
    public class Sphere extends Sprite {
        
        public static const W : int = 465;
        public static const R : int = 100;
        public static const COLORS : Array = [0x587b7C, 0x719b9E, 0x9FC1BE, 0xE0D9BB, 0xDACB94, 0xCABA88, 0xDABD55, 0xC49F32, 0xA97409];
        public static const SEED : int = Math.floor( Math.random() * 0xFFFF );
        public static const ROTATION : Number = .5;
        
        private var __bmpdPerlin : BitmapData;
        private var __particles : Vector.<Particle> = new Vector.<Particle>;
        private var __offset : Array = [ new Point, new Point ];
        
        public function Sphere() {
    
            __initParticles();
            __initPerlin();

            var timer:Timer = new Timer(200);
            timer.addEventListener(TimerEvent.TIMER, __initPerlin);
            timer.start();

            addEventListener(Event.ENTER_FRAME, render);
        }
        
        
        public function render(e:Event) : void {
            graphics.clear();
            
            var p:Particle;
            var pos:Vector3D;
            var posOrg:Vector3D;
            var color:Number;
            var count:int;
            var tx:Number, ty:Number;
         

            for each ( p in __particles) {
                p.matrix.appendRotation(ROTATION*.5, Vector3D.X_AXIS);
                p.matrix.appendRotation(ROTATION, Vector3D.Y_AXIS);
                pos = p.matrix.position;
                posOrg = p.mtxOrg.position;
                if(pos.z > 0) {
                    tx = Math.asin( posOrg.x / R ) / Math.PI + .5;
                    ty = Math.asin( posOrg.y / R ) / Math.PI + .5;

                    color = __bmpdPerlin.getPixel(tx*W*.5, ty*W*.5);
                    color /= 0xFF;
                    color = Math.pow(color, 5) * 14;

                    graphics.beginFill(p.color);
                    graphics.drawCircle(pos.x+W*.5, pos.y+W*.5, color);
                    graphics.endFill();
                }
                count ++;
            }

        }

        
        private function __initParticles() : void {
            const TOTAL:int = 72; 
            const DIS:int = 360 / TOTAL;
            var i:int, j:int;


            for (j=0; j<TOTAL*.5; j++ ) {
                for (i=0; i<TOTAL; i++ ) {
                    var p:Particle = new Particle();
                    p.matrix.identity();
                    p.matrix.appendTranslation(R, 0, 0);
                    p.matrix.appendRotation(i*DIS, Vector3D.Z_AXIS);
                    p.matrix.appendRotation(j*DIS, Vector3D.Y_AXIS);

                    p.mtxOrg.appendTranslation(R, 0, 0);
                    p.mtxOrg.appendRotation(i*DIS, Vector3D.Z_AXIS);
                    p.mtxOrg.appendRotation(j*DIS, Vector3D.Y_AXIS);

                    p.color = getRandomColor(COLORS);
                    __particles.push(p);
                }
            }
        }

        
        private function __initPerlin(e:Event=null) : void {
            if(__bmpdPerlin == null) __bmpdPerlin = new BitmapData(W*.5, W*.5);
            __bmpdPerlin.perlinNoise(W*.5, W*.5, 8, SEED, false, true, 4, false, __offset);
            __offset[0].x += 2;
            __offset[1].y += 2;
        }

        
        public static function getRandomColor(colors:Array) : uint {
            return colors[int(Math.random() * colors.length)];
        }

    }
}


import flash.geom.Matrix3D;

class Particle {
    public var matrix : Matrix3D = new Matrix3D;
    public var mtxOrg : Matrix3D = new Matrix3D;
    public var color : uint;
}
