/**
 * Copyright 0xABCDEF ( http://wonderfl.net/user/0xABCDEF )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wma5
 */

package {
    import flash.geom.Vector3D;
    import flash.events.Event;
    import flash.display.Sprite;
    
    import away3d.cameras.*;
    import away3d.containers.*;
    import away3d.materials.*;
    import away3d.primitives.*;
    
    public class HelloAway3D extends Sprite {

        private var sw:Number, sh:Number; 
        private var o:Vector3D;       
        private var view:View3D;
        
        public function HelloAway3D() {
            
            sw = stage.stageWidth;
            sh = stage.stageHeight;
            
            o = new Vector3D;
            
            view = new View3D;
            view.x = sw/2;
            view.y = sh/2;
            addChild( view );
            
            var trident:Trident = new Trident( 100, true );
            view.scene.addChild( trident );
            
            var box:Cube = new Cube;
            box.x = 75;
            box.y = 75;
            box.z = 75;
            view.scene.addChild( box );
            
            addEventListener( Event.ENTER_FRAME, ENTER_FRAME );
        }
        
        private function ENTER_FRAME( e:Event ):void
        {
            view.camera.x = mouseX-sw/2;
            view.camera.y = mouseY-sh/2;
            view.camera.lookAt( o );
            view.render();
        }
        
    }
}