/**
 * Copyright kappaLab ( http://wonderfl.net/user/kappaLab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wmMu
 */

package  
{
    import flash.display.Graphics;
    import flash.display.Sprite
    import flash.events.MouseEvent;
    import flash.text.TextField;
    /**
     * ...
     * @author gk
     */
    public class Reversi extends Sprite
    {
        private var model:Array;
        private var cells:Array;
        private var count:int;
        public static const UNIT:Number = 40
        public static const ENABLE:int = 1
        public static const DESABLE:int = 0
        
        private var col:int;
        private var row:int;
        private var target:int;
        private var state:int;
        private var rowModel:Array;
        private var textField:TextField
        
        public function Reversi() 
        {
            stage.scaleMode = "noScale"
            init()
        }
        
        private function init():void
        {
            model = [
            [0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 1, 2, 0, 0, 0],
            [0, 0, 0, 2, 1, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 0, 0, 0, 0, 0, 0]
            ];
            
            count = 0;
            state = (count) % 2 + 1;
            var bord:Sprite = addChild(new Sprite()) as Sprite
            var g:Graphics = bord.graphics;
            g.lineStyle(1, 0)
            
            textField = addChild(new TextField()) as TextField
            textField.text = "BLACK"
            textField.y = UNIT * 8;
            
            cells = [[], [], [], [], [], [], [], []];
            var n:int = model.length
            for (var i:int = 0; i < n; i++) 
            {
                var m:int = model[i].length
                for (var j:int = 0; j < m; j++) 
                {
                    var cell:Cell = addChild(new Cell(j,i)) as Cell;
                    cell.x = j * UNIT;
                    cell.y = i * UNIT;
                    cell.state = model[i][j];
                    cell.buttonMode = true;
                    cell.addEventListener(MouseEvent.MOUSE_UP,onMouseup)
                    cells[i][j] = (cell)
                }
            }
            
            
        }
        
        private function onMouseup(e:MouseEvent):void 
        {
            var cell:Cell = e.target as Cell
            col = cell.col;
            row = cell.row;
            rowModel = model[row];            
            target = (state == 1)?2:1;
            var result:int = 
                checkToLeft() + 
                checkToRight() +
                checkToTop() +
                checkToTopLeft() +
                checkToTopRight() +
                checkToBottom() +
                checkToBottomLeft() +
                checkToBottomRight() 
                
            if (result > 0) update();
        }
        
        private function update():void
        {
            var n:int = model.length;
            for (var i:int = 0; i < n; i++) 
            {
                var m:int = model[i].length
                for (var j:int = 0; j < m; j++) 
                {
                    cells[i][j].state = model[i][j];
                }
            }
            state = (++count) % 2 + 1; 
            textField.text = (state == 2)?"WHITE":"BLACK";
        }
        
private function checkToTop():int 
        {
            if (row == 0) return DESABLE;
            if (map[row-1][col] != target) return DESABLE;
            
            for (var i:int = row - 2; i >= 0; i--) 
            {
                if(map[i][col] == state)
                {
                    for (var j:int = row; j > i; j--) map[j][col] = state;
                    return ENABLE
                }
            }
            return DESABLE
        }
        private function checkToTopLeft():int 
        {
            if (row == 0 || col == 0) return DESABLE;
            if (map[row - 1][col - 1] != target) return DESABLE;
            var n:int  = (row < col)?row:col;
            for (var i:int = 2; i <= n; i++) 
            {
                if (map[row - i][col - i] == state)
                {
                    for (var j:int = 0; j < i; j++) 
                    {
                        map[row - j][col - j] = state;
                    }
                    return ENABLE;
                }
            }
            return DESABLE
        }
        
        private function checkToTopRight():int 
        {
            if (row == 0 || col == 7) return DESABLE;
            if (map[row - 1][col + 1] != target) return DESABLE;
            var n:int  = (row < (7-col))?row:(7-col);
            trace(row,col)
            for (var i:int = 2; i < n; i++) 
            {   trace(i,map[row - i][col + i])
                if (map[row - i][col + i] == state)
                {
                    trace(i)
                    for (var j:int = 0; j < i; j++) 
                    {
                        map[row - j][col + j] = state;
                    }
                    return ENABLE;
                }
            }
            return DESABLE
        }
        
        private function checkToBottom():int 
        {
            if (row == 7) return DESABLE;
            if (map[row+1][col] != target) return DESABLE;
            
            for (var i:int = row + 2; i < 8; i++) 
            {
                if(map[i][col] == state)
                {
                    for (var j:int = row; j < i; j++) map[j][col] = state;
                    return ENABLE;
                }
            }
            return DESABLE
        }
        private function checkToBottomLeft():int 
        {
            if (row == 7 || col == 0) return DESABLE;
            if (map[row + 1][col - 1] != target) return DESABLE;
            var n:int  = ((7-row) < col)?(7-row):col;
            for (var i:int = 2; i <= n; i++) 
            {
                if (map[row + i][col - i] == state)
                {
                    for (var j:int = 0; j < i; j++) 
                    {
                        map[row + j][col - j] = state;
                    }
                    return ENABLE;
                }
            }
            return DESABLE
        }
        
        private function checkToBottomRight():int 
        {
            if (row == 7 || col == 7) return DESABLE;
            if (map[row + 1][col + 1] != target) return DESABLE;
            var n:int  = ((7-row) < (7-col))?(7-row):(7-col);
            for (var i:int = 2; i < n; i++) 
            {
                if (map[row + i][col + i] == state)
                {
                    for (var j:int = 0; j < i; j++) 
                    {
                        map[row + j][col + j] = state;
                    }
                    return ENABLE;
                }
            }
            return DESABLE;
        }

        private function checkToLeft():int 
        {
            if (col == 0) return DESABLE;
            if (map[row][col - 1] != target) return DESABLE;
            
            for (var i:int = col-2; i >= 0; i--) 
            {
                if(map[row][i] == state)
                {
                    for (var j:int = col; j > i; j--) map[row][j] = state;
                    return ENABLE;
                }
            }
            return DESABLE
        }
        
        private function checkToRight():int
        {
            if (col == 7) return DESABLE;
            if (map[row][col + 1] != target) return DESABLE;
            
            for (var i:int = col+2; i < 8; i++) 
            {
                if(map[row][i] == state)
                {
                    for (var j:int = col; j < i; j++) map[row][j] = state;
                    return ENABLE;
                }
            }
            return DESABLE
        }
                
    }
}
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite
import flash.filters.DisplacementMapFilterMode;
class Cell extends Sprite
{
    private var _state:uint;
    private var g:Graphics;
    private var black:Shape;
    private var white:Shape;
    private var _col:int;
    private var _row:int;
    private var _tlCol:int;
    private var _tlraw:int;
    function Cell(col:int,row:int):void
    {
        _col = col;
        _row = row;
        _tlCol = (_col == 0)?0:_col;
        _tlraw = (_row == 0)?0:_row;
        
        g = this.graphics;
        g.lineStyle(1,0x000000)
        g.beginFill(0x55AA55)
        g.drawRect(0,0,Reversi.UNIT,Reversi.UNIT)
        g.endFill()
        
        var r:Number = Reversi.UNIT / 2
        black = addChild(new Shape()) as Shape
        black.graphics.beginFill(0)
        black.graphics.drawCircle(r, r, r * .8);
        black.visible = false;
        
        white = addChild(new Shape()) as Shape
        white.graphics.beginFill(0xFFFFFF);
        white.graphics.drawCircle(r, r, r * .8);
        white.visible = false;
    }
    
    public function get state():uint { return _state; }
    
    public function set state(value:uint):void 
    {
        _state = value;
        switch(value)
        {
            case 0:
            black.visible = white.visible = false
            break;
            case 1:
            black.visible = true
            white.visible = false
            mouseEnabled = false
            break;
            case 2:
            black.visible = false
            white.visible = true
            mouseEnabled = false
            break;
        }
    }
    
    public function get row():int { return _row; }
    
    public function get col():int { return _col; }
    
    public function get tlCol():int { return _tlCol; }
    
    public function get tlraw():int { return _tlraw; }
    
    public function set tlraw(value:int):void 
    {
        _tlraw = value;
    }
    
    
}
class CellModel
{
    public var col:int;
    public var raw:int;
}
