/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wlP7
 */

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.*;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.utils.Timer;
    
    public class winamp extends Sprite
    {
        
        private var bmd:BitmapData;
        private var bm:Bitmap;
        private var ba:ByteArray;
        private var s:Sound;
        private var bf:BlurFilter;
        private var cmf:ColorMatrixFilter;
        private var color:String;
        private var newcolor:String;
        private var newcolor2:String;
        private var timer:Timer;
        
        private var baseX:Number = 100;
        private var baseY:Number = 100;
        private var octaves:uint = 3;
        private var randomSeed:int = Math.random() * 0xffffffff;
        private var stitch:Boolean = true;
        private var fractalNoise:Boolean = true;
        private var channelOptions:int = BitmapDataChannel.RED | BitmapDataChannel.GREEN;
        private var grayScale:Boolean = false;
        private var offset:Array = [new Point(), new Point(), new Point()];
        
        private var bumblebee:Matrix;
        
        public function winamp():void
        {
            newcolor = "d58eab"; //some fancy start color. Everything is better than black
            newcolor2 = "78dfca";
            color = "789abcdef"; //all the values you want to be able to show up in the color codes
            
            timer = new Timer(2000);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
            
            bf = new BlurFilter(4, 4, 2);
            cmf = new ColorMatrixFilter([1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0.9, 0]);
            
            bmd = new BitmapData(465, 465, true, 0x000000);
            bm = new Bitmap(bmd);
            addChild(bm);
            
            bmd.perlinNoise(baseX, baseY, octaves, randomSeed, stitch, fractalNoise, channelOptions, grayScale, offset);
            offset[0].y += 2;
            offset[1].y += 1;
            offset[2].y += 0.5;
            
            ba = new ByteArray();
            
            s = new Sound(new URLRequest("http://www.takasumi-nagai.com/soundfiles/sound001.mp3"));
            s.play();
            
            this.stage.addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void
        {
            this.graphics.clear();
            this.graphics.moveTo(0, 300);
            this.graphics.lineStyle(5, uint("0x" + newcolor));
            SoundMixer.computeSpectrum(ba);
            
            for (var i:Number = 0; i < 512; i++)
            {
                this.graphics.lineTo(i * 2, ba.readFloat() * 200 + 300);
                
            }
            
            bmd.draw(this);
            bmd.applyFilter(bmd, bmd.rect, new Point(0, 0), bf);
            bmd.applyFilter(bmd, bmd.rect, new Point(0, 0), cmf);
            //bm.transform.matrix = bumblebee;
            bmd.scroll(0, 4);
        }
        
        private function timerHandler(e:TimerEvent):void
        {
            
            newcolor = "";
            newcolor2 = "";
            for (var k:uint = 0; k < 6; k++)
            {
                newcolor += color.substr(Math.floor(Math.random() * color.length), 1);
                newcolor2 += color.substr(Math.floor(Math.random() * color.length), 1);
            }
        }
    }
}