/**
 * Copyright syROBO ( http://wonderfl.net/user/syROBO )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wkep
 */

// forked from tkinjo's forked from: インボリュート曲線を Lines3D で描く
// forked from tkinjo's インボリュート曲線を Lines3D で描く
// forked from tkinjo's ターゲットの周りを飛ぶキューブ
package  
{
	/**
	 * アニメーション追加
	 * 
	 * 
	 * 
	 * --- 参考 ---
	 * 
	 * bkzen - LineWheel 
	 * http://wonderfl.kayac.com/code/34835cf083f82d845470086ea0ba9285107c635a
	 */
	
	import flash.events.Event;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	
	[SWF(width=465,height=465,frameRate=60,backgroundColor=0xffffff)]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class Main extends BasicView
	{
		private const a:Number = 30;
		private const radius:Number = -100;
		private const drawSpeed:Number = 5;
		
		private var angle:Number = 0;
		private var prevX:Number = 0, prevY:Number = 0, prevZ:Number = 0;
		
		private var draw:Boolean = true;
		private var linesVectors:Vector.<Lines3D>;
		
		public function Main() 
		{
			linesVectors = new Vector.<Lines3D>();
			
			var wireframeMaterial:WireframeMaterial = new WireframeMaterial( 0 );
			wireframeMaterial.doubleSided = true;
			
			var plane:Plane = new Plane( wireframeMaterial );
			plane.rotationX = 90;
			
			scene.addChild( plane );
			
			//camera.x = 1000;
			//camera.y = 1000;
			camera.target = null;
			//camera.zoom = 115;
			
			startRendering();
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			if ( draw ) {
				
				var lineMaterial:LineMaterial = new LineMaterial();
				var lines:Lines3D = new Lines3D( lineMaterial );
				
				var theta:Number = angleToRadian( angle );
				var x:Number = involuteX( theta, a );
				var y:Number = angle;
				var z:Number = involuteY( theta, a );
				
				lines.addNewLine( 3, prevX, prevY, prevZ, x, y, z );
				scene.addChild( lines );
				
				linesVectors.push( lines );
				
				prevX = x;
				prevY = y;
				prevZ = z;
				
			} else {
				
				scene.removeChild( linesVectors[ 0 ] );
				linesVectors.shift();
			}
			
			angle += drawSpeed;
			
			if ( 360 < angle ) {
				
				angle = 0;
				draw = !draw;
				
				prevX = 0;
				prevY = 0;
				prevZ = 0;
			}
			
			
			/**
			 * カメラの設定
			 */
			var thetaXZ:Number=360 * ( ( mouseX + stage.stageWidth / 2 ) / stage.stageWidth ) * Math.PI / 180;
			var thetaYZ:Number=360 * ( ( mouseY + stage.stageHeight / 2 ) / stage.stageHeight ) * Math.PI / 180;
			camera.x = radius * Math.cos( thetaYZ ) * Math.sin( thetaXZ );
			camera.y = -radius * Math.sin( thetaYZ );
			camera.z = radius * Math.cos( thetaYZ ) * Math.cos( thetaXZ );
			camera.rotationX = thetaYZ * 180 / Math.PI;
			camera.rotationY = thetaXZ * 180 / Math.PI;
		}
		
		/**
		 * ラジアン角に対するインボリュート曲線の x 座標を返します。
		 * 
		 * @param	a
		 * @param	theta
		 * @return
		 */
		private function involuteX( theta:Number, a:Number = 1 ):Number {
			
			return a * ( Math.cos( theta) + theta * Math.sin( theta ) );
		}
		
		/**
		 * ラジアン角に対するインボリュート曲線の y 座標を返します。
		 * 
		 * @param	a
		 * @param	theta
		 * @return
		 */
		private function involuteY( theta:Number, a:Number = 1 ):Number {
			
			return a * ( Math.sin( theta ) - theta * Math.cos( theta) );
		}
		
		/**
		 * 
		 * @param	angle
		 * @return
		 */
		private function angleToRadian( angle:Number ):Number {
			
			return angle * Math.PI / 180;
		}
	}
	
}