/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wkGC
 */

// forked from Scmiz's honeycomb
package {
    import flash.display.Sprite;
	import flash.events.Event;
    public class FlashTest extends Sprite {
		private var _array:/*Hex*/Array;
		private var _frame:uint;
		
		private const COLORS:Array = [0xffb0b0, 0x80ff80, 0xb0b0ff, 0xffff40, 0xffb0ff, 0x80ffff];
		
        public function FlashTest() {
			this.graphics.beginFill(0x404040);
			this.graphics.drawRect(0, 0, 465, 465);
			this.graphics.endFill();
			
			_array = new Array();
			_frame = 0;
			
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			
			// 追加
			++_frame;
			if (_frame >= 1) {
				_frame = 0;
				
				while (true) {
					var hexx:uint = Math.random() * 10;
					var hexy:uint = Math.random() * 12;
					
					var isExist:Boolean = false;
					for (var index:uint = 0; index < _array.length; ++index) {
						var h:Hex = _array[index];
						if (h.posx == hexx && h.posy == hexy) {
							isExist = true;
							break;
						}
					}
					if (isExist) {
						continue;
					}
					break;
				}
				
				var hex:Hex = new Hex(hexx, hexy, 25, COLORS[uint(Math.random() * COLORS.length)]);
				this.addChild(hex);
				_array.push(hex);
			}
			
			// 後始末
			for (var i:uint = 0; i < _array.length; ++i) {
				if (_array[i].isEnd) {
					_array.splice(i, 1);
				}
			}
		}

    }
}

import flash.display.Sprite;
import caurina.transitions.Tweener;

class Hex extends Sprite {
	public var posx:uint;
	public var posy:uint;
	public var isEnd:Boolean;
	
	public function Hex(x:uint, y:uint, radius:Number, color:uint) {
		posx = x;
		posy = y;
		isEnd = false;
		
		this.x = x * 52 + ((y % 2 ) * 26);
		this.y = 44 * y;
		
		this.graphics.beginFill(color);
		var num:uint = 6;

		var current:Number = Math.PI * 0.5;
		this.graphics.moveTo((Math.cos(current) * radius), (Math.sin(current) * radius));
		for (var index:uint = 0; index <  num; ++index) {
			var next:Number = (Math.PI * 0.5) + (((index + 1) % num) * (Math.PI * 2 / num));
			this.graphics.lineTo((Math.cos(next) * radius), (Math.sin(next) * radius));
		}
		this.graphics.endFill();
		
		this.scaleX = 0.01;
		this.scaleY = 0.01;
		
		Tweener.addTween(this,
		{
			scaleX:1,
			scaleY:1,
			time:6,
			useFrames:true,
			transition:"easeOutSine"
		});
		Tweener.addTween(this,
		{
			scaleX:1.1,
			scaleY:1.1,
			alpha:0,
			delay:15,
			time:10,
			useFrames:true,
			onComplete:onEnd
		});
	}
	
	private function onEnd():void {
		parent.removeChild(this);
		isEnd = true;
	}
}