/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wk9E
 */

/**
 * CirclesLoveLines step 2
 * @Revision 
 *              - Lets project pointX along line AB!
 *              - Lets Make a point X that is the mouse!
 * 		- Lets project a line segment from lineA to circlaA!
 * 
 * @author Mario Gonzalez
 * @see http://onedayitwillmake.com/
 * @note: This series of experiments is being created because.
 */
package
{ 
		
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix;
	
	[SWF(frameRate="60", width="465", height="465", backgroundColor="#00ffcc")]
	
    public class CircleLineSegmentTest extends Sprite
    {
    	private var A	:Vector2D; // Point A
    	private var B	:Vector2D; // Point B
    	private var V	:Vector2D; // Vector AB
    	
    	private var X	:Vector2D; // Point X
    	private var W	:Vector2D; // Vector AX
    	
    	//Graphical representation of elements above
    	private var lineAB		:Line	// Line segment between points AB
    	private var lineAX		:Line	// Line segment between points AX
    	private var circleX		:Circle	// Circle at Point X 
    	private var circleXonAB	:Circle // Point X projected along LineAB 
    	
    	public function CircleLineSegmentTest():void
    	{
    		addChild(createBG(0x500149, 0x000040));
    		
    		A = new Vector2D(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight);
    		B = new Vector2D(Math.random() * stage.stageWidth, Math.random() * stage.stageHeight);
    		V = B.minus(A);
    		
    		lineAB = new Line(A, B, 0xff0000);
    		lineAB = new Line(A, B, 0xff0000);
    		addChild(lineAB);

			// Create circleXonAB
			circleXonAB = new Circle(new Vector2D(), 8);
			addChild(circleXonAB);
    		addEventListener(Event.ENTER_FRAME, projectMouse);
    	}
    	
    	/**
    	 * Find T.
    	 * T is Point X (the mouse position), projected along Line AB
    	 * T is a number between -Infinity and Infinity where 0.0 and 1.0 represent A and B respectively.
    	 * Being the case, normally you only want T, clamped to 0.0 - 1.0.
    	 */
    	private function projectMouse(e:Event):void
    	{
    		X = new Vector2D(stage.mouseX, stage.mouseY);
    		W = X.minus(A);
    		
    		var t:Number = W.dot(V) / V.dot(V);
    		
    		circleXonAB.center = V.times(clamp(0, 1, t)).plus(A);
    	}
    	
    	private function createBG(topColor:uint, bottomColor:uint):Sprite
		{
			var matr:Matrix = new Matrix();
			matr.createGradientBox(465, 465, Math.PI / 2, 0, 0);
			
			var bg:Sprite = new Sprite();
			bg.graphics.beginGradientFill
			(
				GradientType.LINEAR, 
				[topColor, bottomColor], //colors
				[1, 1], //alphas
				[0, 255], //ratios
				matr, //matrix
				SpreadMethod.PAD
			);	
			
			bg.graphics.drawRect(0, 0, 465, 465);
			bg.graphics.endFill();
			
			return bg;
		}
    	
    	public static function clamp(min:Number, max:Number, val:Number):Number
    	{
    		 return Math.max(min, Math.min(max, val))
    	}
    }
}

import flash.geom.Point;
import flash.display.Shape;
import flash.display.Sprite;

internal class Vector2D
{
	public var x:Number, y:Number
	public function Vector2D(x1:Number = 0, y1:Number = 0):void
	{
		x = x1;
		y = y1;
	}
	
	public function minus(from:Vector2D):Vector2D
	{
		return new Vector2D(x - from.x, y - from.y);
	}
	
	public function plus(from:Vector2D):Vector2D
	{
		return new Vector2D(x + from.x, y + from.y);
	}
	
	public function times(z:Number):Vector2D
	{
		return new Vector2D(x * z, y * z);
	}
	
	//proj(w,v) = dot(w,v) / dot(v,v)
	public function project(from:Vector2D):Number
	{
		return dot(from) / from.dot(from);
	}
	
	// w.x * v.x + w.y * v.y
	public function dot(from:Vector2D):Number
	{
		return x * from.x + y * from.y;
	}
}

internal class Line extends Shape
{
	public var A:Vector2D, B:Vector2D; //A |----| B
	
	//Draw
	public var _color		:uint = 0x666666;
	public var __isDirty	:Boolean = false;
	public function Line(a:Vector2D, b:Vector2D, color:uint = 0x666666):void
	{
		A = a;
		B = b;
		_color = color;
		_isDirty = true;
	}
	
	public function draw():void
	{
		resetGraphics();
		graphics.moveTo(A.x, A.y);
		graphics.lineTo(B.x, B.y);
	}
	
	public function resetGraphics():void
	{
		graphics.clear();
		graphics.lineStyle(2, _color, 0.75);
	}
	
	public function get _isDirty():Boolean { return __isDirty };
	public function set _isDirty(value:Boolean):void
	{
		__isDirty = value;
		draw();
	}
}

internal class Circle extends Sprite
{
	public var _center	:Vector2D;
	public var _radius	:int;
	
	public function Circle(center:Vector2D, radius:int):void
	{
		_center = center;
		_radius = radius;
		
		x = _center.x;
		y = _center.y;
		
		//Draw
		graphics.beginFill(0xB8F1FE,1)
			graphics.drawCircle(0, 0, _radius * 0.25);
			graphics.drawCircle(0, 0, _radius * 0.5);
			graphics.drawCircle(0, 0, _radius);
		graphics.endFill();
	}
	
	public function resetGraphics():void
	{
		graphics.clear();
		graphics.lineStyle(1, 0xFE8DF5, 1);
	}
	
	public function set center(value:Vector2D):void
	{
		_center = value;
		x = _center.x;
		y = _center.y;
	}
	
	public function get center():Vector2D
	{
		return _center;
	}
}