/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wjsQ
 */

// forked from majoraze's bounce basic
// forked from majoraze's flash on 2010-11-22
package {
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    public class Boundaries extends Sprite {
        private var ball:Ball;
        private var vx:Number;
        private var vy:Number;
        private var friction:Number = .1;
        
        public function Boundaries() {
            init();
        }
        
        private function init():void {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            ball = new Ball();
            ball.x = stage.stageWidth/2;
            ball.y = stage.stageHeight/2;
            vx = Math.random() * 10 - 5;
            vy = Math.random() * 10 - 5;
            
            addChild(ball);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void {
            var speed:Number = Math.sqrt(vx * vx + vy * vy);
            var angle:Number = Math.atan2(vy,vx);
            if (speed > friction) {
                speed -= friction;
            } else {
                speed = 0;
            }
            
            vx = Math.cos(angle) * speed;
            vy = Math.sin(angle) * speed;
            
            
            ball.x += vx;
            ball.y += vy;
            


        }
    }
}




//ball class

import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    private var color:uint;
    public var vx:Number = 0;
    public var vy:Number = 0;    
    
    public function Ball(radius:Number = 40, color:uint = 0xff0000) {
        this.radius = radius;
        this.color = color;
        
        init();
    }
    
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0,0,radius);
        graphics.endFill()
    }
}
