/**
 * Copyright purin ( http://wonderfl.net/user/purin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wjAE
 */

package{

	import flash.display.*;
	import flash.events.Event;
	import flash.geom.Point;
	
	[SWF(width="512",height="512",backgroundColor="0x999999")]
	
	public class main extends Sprite{

		private var enemy:Enemy = new Enemy(150,180,20,0xFF00FF);
		private var hero:Hero = new Hero(220,120,20,0x00FF00);
		private var hero2:Hero2 = new Hero2(140,140,20,0x00FFFF);

		private function Draw():void{
			this.addChild(this.enemy.getPicture());
			this.addChild(this.hero.getPicture());
			this.addChild(this.hero2.getPicture());
			
			this.addChild(this.enemy.getVision());
			this.addChild(this.hero.getVision());
			this.addChild(this.hero2.getVision());
			
			this.addChild(this.hero2.getCollision().getColVision(this.enemy.getPoint()));
			
			this.addChild(this.hero2.getCollision().db[0].getText());
			this.addChild(this.hero2.getCollision().db[1].getText());
			this.addChild(this.hero2.getCollision().db[2].getText());

		}
		
		private function MoveCharactor(event:Event):void{
			this.enemy.RefleshCollision();
			this.hero.RefleshCollision();
			this.hero2.RefleshCollision();
			this.enemy.AI(this.hero.getCollision(),this.hero2.getCollision());
			this.hero.AI(this.enemy.getCollision(),this.hero2.getCollision());
			this.hero2.AI(this.enemy.getCollision(),this.hero.getCollision());

			this.Draw();
		}

		public function main():void{
			this.addEventListener(Event.ENTER_FRAME,this.MoveCharactor);
		}
	}
}

import flash.geom.Point;
import flash.display.*;
import flash.events.Event;
import flash.geom.ColorTransform;
import flash.text.TextField;

class Charactor extends Sprite {
	protected var pic:Sprite;
	protected var vision:Sprite;
	protected var collision:Collision;

	public function AI(enemy1:Collision,enemy2:Collision):void{
		this.pic.x += 1;
		this.pic.y += 1;
	}
	public function Charactor(vx:int,vy:int,rad:uint,col:uint):void{
		var pos:Point = new Point(vx,vy);

		this.collision = new Collision(rad,pos,col,25);

		this.pic = new Sprite();
		this.pic.x = vx;
		this.pic.y = vy;

                this.pic.graphics.beginFill(col);
                this.pic.graphics.drawCircle(0,0,rad);
                this.pic.graphics.endFill();

		this.vision = new Sprite();
	}

        //三角形を表示
	public function getVision():Sprite{
		this.vision.graphics.clear();
		this.vision.graphics.lineStyle(1,0xFFFFFF);
		this.vision.graphics.moveTo(this.collision.getP1().x,this.collision.getP1().y);
		this.vision.graphics.lineTo(this.collision.getP2().x,this.collision.getP2().y);
		this.vision.graphics.lineTo(this.collision.getP3().x,this.collision.getP3().y);
		this.vision.graphics.lineTo(this.collision.getP1().x,this.collision.getP1().y);
		return (this.vision);
	}
	public function getPicture():Sprite{
		return(this.pic);
	}
	public function getPoint():Point{
		return (this.collision.getPos());
	}
	public function getCollision():Collision{
		return (collision);
	}
	//円の中心座標と三角形の座標を更新
	public function RefleshCollision():void{
		var tmp:Point = new Point(this.pic.x,this.pic.y);
		this.collision.setPos(tmp);
		this.collision.RefleshVisionPos();
	}
}

class Collision {

	private var radius:uint;
	private var charactor_pos:Point;
	private var vision_pos1:Point;
	private var vision_pos2:Point;
	private var vision_pos3:Point;
	private var tripoint:Array;
	private var vision_size:uint;
	private var color:uint;
	private var col_vis:Sprite;
	
	public var db:Array;

	public function Collision(rad:uint,pc:Point,col:uint,size:uint):void{
		this.radius = rad;
		this.charactor_pos = pc;
		this.vision_pos1 = new Point(0,0);
		this.vision_pos2 = new Point(size,size*2);
		this.vision_pos3 = new Point(-1*size,size*2);
		this.color = col;
		this.vision_size = size;
		this.col_vis = new Sprite();
		this.tripoint = [new Point(this.vision_pos2.x-this.vision_pos1.x,this.vision_pos2.y-this.vision_pos1.y),
                                 new Point(this.vision_pos3.x-this.vision_pos2.x,this.vision_pos3.y-this.vision_pos2.y),
                                 new Point(this.vision_pos1.x-this.vision_pos3.x,this.vision_pos1.y-this.vision_pos3.y)];
		
 		this.db = [new Debug(10,10),new Debug(10,30),new Debug(10,50)];

	}
	public function getColor():uint{ return(this.color); }
	public function getRadius():uint{ return(this.radius); }
	public function getPos():Point{ return(this.charactor_pos); }
	public function getP1():Point{ return(this.vision_pos1); }
	public function getP2():Point{ return(this.vision_pos2); }
	public function getP3():Point{ return(this.vision_pos3); }

	public function setColor(col:uint):void{ this.color = col; }
	public function setRadius(rad:uint):void{ this.radius = rad; }
	public function setPos(pos:Point):void{ this.charactor_pos = pos; }
	public function setP1(p:Point):void{ this.vision_pos1 = p; }
	public function setP2(p:Point):void{ this.vision_pos2 = p; }
	public function setP3(p:Point):void{ this.vision_pos3 = p; }
	
	//三角形の各頂点と他の円の中心を結ぶ線
	public function getColVision(cpos:Point):Sprite{
	    this.col_vis.graphics.clear();
		this.col_vis.graphics.lineStyle(1,0xFF0000);
		this.col_vis.graphics.moveTo(this.vision_pos1.x,this.vision_pos1.y);
		this.col_vis.graphics.lineTo(cpos.x,cpos.y);
		this.col_vis.graphics.moveTo(this.vision_pos2.x,this.vision_pos2.y);
		this.col_vis.graphics.lineTo(cpos.x,cpos.y);
		this.col_vis.graphics.moveTo(this.vision_pos3.x,this.vision_pos3.y);
		this.col_vis.graphics.lineTo(cpos.x,cpos.y);
		return (this.col_vis);
	}
	
	public function RefleshVisionPos():void{
		this.vision_pos1.x = this.charactor_pos.x;
		this.vision_pos1.y = this.charactor_pos.y;
		this.vision_pos2.x =    this.vision_size + this.charactor_pos.x;
		this.vision_pos2.y =  2*this.vision_size + this.charactor_pos.y;
		this.vision_pos3.x = -1*this.vision_size + this.charactor_pos.x;
		this.vision_pos3.y =  2*this.vision_size + this.charactor_pos.y;
	}
	public function RotateVision(deg:Number):void{
		var rad:Number = deg*Math.PI/180;
		var vpl1:Point = new Point(this.vision_pos1.x - this.vision_pos1.x,this.vision_pos1.y - this.vision_pos1.y);
		var vpl2:Point = new Point(this.vision_pos2.x - this.vision_pos1.x,this.vision_pos2.y - this.vision_pos1.y);
		var vpl3:Point = new Point(this.vision_pos3.x - this.vision_pos1.x,this.vision_pos3.y - this.vision_pos1.y);
		this.vision_pos1.x = ((vpl1.x)*Math.cos(rad)-(vpl1.y)*Math.sin(rad))+this.vision_pos1.x;
		this.vision_pos1.y = ((vpl1.x)*Math.sin(rad)+(vpl1.y)*Math.cos(rad))+this.vision_pos1.y;
		this.vision_pos2.x = ((vpl2.x)*Math.cos(rad)-(vpl2.y)*Math.sin(rad))+this.vision_pos1.x;
		this.vision_pos2.y = ((vpl2.x)*Math.sin(rad)+(vpl2.y)*Math.cos(rad))+this.vision_pos1.y;
		this.vision_pos3.x = ((vpl3.x)*Math.cos(rad)-(vpl3.y)*Math.sin(rad))+this.vision_pos1.x;
		this.vision_pos3.y = ((vpl3.x)*Math.sin(rad)+(vpl3.y)*Math.cos(rad))+this.vision_pos1.y;
	}	

	//pos:enemy center point of circle
	public function CircleCollision(rad:uint,pos:Point):Boolean{

		var vMath:MathVec = new MathVec();

		this.tripoint[0] = new Point(this.vision_pos2.x-this.vision_pos1.x,this.vision_pos2.y-this.vision_pos1.y);
		this.tripoint[1] = new Point(this.vision_pos3.x-this.vision_pos2.x,this.vision_pos3.y-this.vision_pos2.y);
		this.tripoint[2] = new Point(this.vision_pos1.x-this.vision_pos3.x,this.vision_pos1.y-this.vision_pos3.y);

                for(var i:int=0;i<3;i++){
                    this.tripoint[i].x += this.charactor_pos.x;
                    this.tripoint[i].y += this.charactor_pos.y;
		}

		//始点から円の中心に対してのベクトル
		var vc:Array = [new Point(pos.x-this.vision_pos1.x,pos.y-this.vision_pos1.y),
                                new Point(pos.x-this.vision_pos2.x,pos.y-this.vision_pos2.y),
                                new Point(pos.x-this.vision_pos3.x,pos.y-this.vision_pos3.y)];
		
		//三角形のベクトルと始点から円の中心に対してのベクトルとの外積
		var m:Array = [ Math.abs(vMath.VectorCross(this.tripoint[0],vc[0])),
                                Math.abs(vMath.VectorCross(this.tripoint[1],vc[1])),
                                Math.abs(vMath.VectorCross(this.tripoint[2],vc[2]))];
		
		//三角形のベクトルと始点から円の中心に対してのベクトルとの内積
		var n:Array = [ vMath.VectorDot(this.tripoint[0],vc[0]),
                                vMath.VectorDot(this.tripoint[1],vc[1]),
                                vMath.VectorDot(this.tripoint[2],vc[2])];

		//始点から円の中心に対してのベクトルの内積
		var c:Array = [ vMath.VectorDot(vc[0],vc[0]),
                                vMath.VectorDot(vc[1],vc[1]),
                                vMath.VectorDot(vc[2],vc[2])];
		
		this.db[0].setText("tripoint[0]:"+this.tripoint[0]);
		this.db[1].setText("tripoint[1]:"+this.tripoint[1]);
		this.db[2].setText("tripoint[2]:"+this.tripoint[2]);
                
		for(i=0;i<3;i++){
        		if(n[i]<=0){
				if(rad >= m[i]/vMath.VectorLength(this.tripoint[i])){
					return(true);
				}
			}
		}
		for(i=0;i<3;i++){
                        if(n[i]>=0){
			    if(rad*rad >= c[i]){
				return(true);
			    }
			}
                }		
		if(m[0] <= 0 && m[1] <= 0 && m[2] <= 0){
			return(true);
		}

		return (false);
	}
}

class MathVec {

	public function VectorDot(a:Point,b:Point):int{
		return(a.x*b.x+a.y*b.y);
	}
	public function VectorCross(a:Point,b:Point):int{
		return(a.x*b.y-a.y*b.x);
	}	
	public function VectorLength(a:Point):Number{
		return(Math.sqrt(a.x*a.x +a.y*a.y));
	}
	public function VectorDistance(a:Point,b:Point):Number{
		return(Math.sqrt((a.x-b.x)*(a.x-b.x)+(a.y-b.y)*(a.y-b.y)));
	}
}

class Hero extends Charactor{

	private var fraction:int = 0;

	override public function AI(enemy1:Collision,enemy2:Collision):void{
/*
		var deltaX:int = enemy1.getPos().x - this.pic.x;
		var deltaY:int = enemy1.getPos().y - this.pic.y;

		var stepx:int;
		var stepy:int;

		if(deltaX < 0) stepx = -1; else stepx = 1;
		if(deltaY < 0) stepy = -1; else stepy = 1;
		
		deltaX = Math.abs(deltaX * 2);
		deltaY = Math.abs(deltaY * 2);

		if(deltaX > deltaY){
			this.fraction = deltaY  - deltaX / 2;
			if(this.pic.x != enemy1.getPos().x){
				if(this.fraction >= 0){
					this.pic.y += stepy;
					this.fraction -= deltaX;
				}
			this.pic.x += stepx;
			this.fraction += deltaY;
			}
		}
		else{
			this.fraction = deltaX  - deltaY / 2;
			if(this.pic.y != enemy1.getPos().y){
				if(this.fraction >= 0){
					this.pic.x += stepx;
					this.fraction -= deltaY;
				}
			this.pic.y += stepy;
			this.fraction += deltaX;
			}
		}
*/
	}
	function Hero(x:int,y:int,rad:uint,col:uint){
	super(x,y,rad,col);
	}
}


class Enemy extends Charactor{

	override public function AI(enemy1:Collision,enemy2:Collision):void{
//                this.pic.y++;
	}
	public function Enemy(x:int,y:int,rad:uint,col:uint){
		super(x,y,rad,col);
	}
}

class Hero2 extends Charactor{

	private var deg:Number = 0;
	override public function AI(enemy1:Collision,enemy2:Collision):void{
		var base:ColorTransform = new ColorTransform();
		var hit1:ColorTransform = new ColorTransform();
		var hit2:ColorTransform = new ColorTransform();
		base.color = 0x00FFFF;	//waterblue
		hit1.color = 0xff0000;	//red
		hit2.color = 0x00ff00;	//green

		if(deg >= 360)	deg = 0;	
		deg += 1; 

		this.collision.RotateVision(deg);

		if(this.collision.CircleCollision(enemy1.getRadius(),enemy1.getPos())==true){
			this.pic.transform.colorTransform = hit1;
		}
		/*
		else if(this.collision.CircleCollision(enemy2.getRadius(),enemy2.getPos())==true){
			this.pic.transform.colorTransform = hit2;
		}
		*/
		else{
			this.pic.transform.colorTransform = base;
		}
		//this.pic.y++;
	}	
	public function Hero2(x:int,y:int,rad:uint,col:uint){
		super(x,y,rad,col);
	}
}

class Debug extends Sprite{
	
	private var tf:TextField;
	
	public function setText(txt:String):void{
		this.tf.text = txt;
	}
	
	public function getText():TextField{
		return(this.tf);
	}
	
	
	public function Debug(x:int,y:int){
		this.tf = new TextField();
		this.tf.text = "NULL";
		this.tf.autoSize = "left"
		this.tf.x = x;
		this.tf.y = y;
	}
}