/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wj0N
 */

//「ブラウザで無料ではじめるActionScript」 3.0参照
package {
    import flash.display.Sprite;
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.BitmapDataChannel;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    [SWF(width=465,height=465,backgroundColor=0,frameRate=60)]
   
    public class GetSetPixel extends Sprite {
            
            public var bmpData:BitmapData;
            public var colortrans:ColorTransform;
            public var filter:BlurFilter;
            public var vectormap:BitmapData;
            public var particles:Array;
            public var particleNum:uint = 2000;
            public var size:Number = 465;
        
        public function GetSetPixel() {
            
            //bitmapを作って表示リストに追加
            bmpData=new BitmapData(size,size,false,0);
            addChild(new Bitmap(bmpData));
            
            //bmpDataに適用する為のカラーとフィルターを作っておく
            colortrans=new ColorTransform(0.2, 0.2, 0.75);
            filter=new BlurFilter(2,2,1);
            
            //パレット用のビットマップを作る（ここら色を採取してbmpDataに描画する,）
            vectormap=new BitmapData(size,size,false,0);
            reset();
            
            addEventListener(Event.ENTER_FRAME,enterFrame);
            stage.addEventListener(MouseEvent.CLICK,reset);
        //addEventListener(MouseEvent.MOUSE_MOVE,onMove);
            
        }
        
       
        public function reset(e:MouseEvent=null):void{ //関数を呼び出す時に引数が無いのでnullにしておかないとエラーになる
            //perlinNoise用のパラメーターを用意
            var randomSeed:int=Math.random()*0xffffff;
            var colors:uint=BitmapDataChannel.RED | BitmapDataChannel.GREEN ;
            //vectormapのperlinNoiseメソッドを実行
            vectormap.perlinNoise(size,size,10,randomSeed,true,true,colors);
            //パーティクル格納用配列を用意する
            particles =new Array(particleNum);
            //partilcleNumの数だけパーティクルを生成して配列に一つずつ格納する（その際各パーティクルの座標をランダムに指定する）
                for( var i:int = 0; i < particleNum; i++){
                    particles[i]=new Particle( Math.random()*size, Math.random()*size);
                }
        }
        
        public function enterFrame(e:Event):void{          
            //フィルターを設定
            bmpData.applyFilter(bmpData,bmpData.rect,bmpData.rect.topLeft,filter);
            //カラーを設定
            bmpData.colorTransform(bmpData.rect,colortrans);
            bmpData.lock();//いったんロックすると軽くなるらしい
            
            for(var i:int=0; i<particleNum ; i++){
                //配列から昇順で一つずつ取り出してParticle型の変数に入れる
                var p:Particle = particles[i];
                 //ベクトルマップのpの座標のピクセルの色を取得
                 var col:uint=vectormap.getPixel(p.x,p.y);
                 //色を分解した値をax,ayに加算する、これが加速度になる
                 p.ax += ((col >> 5 & 0xfff)+128)*0.00001;
                 p.ay += ((col >> 14 & 0xfff)+256)*0.00003;
                 p.x += p.vx += p.ax;
                 p.y += p.vy += p.ay;
                 
                 //パーティクルの移動範囲を制限する
                 if(p.x>size){
                     p.x-=size
                 }else if(p.x<0){
                     p.x+=size;
                 }
                 if(p.y>size){
                     p.y-=size;
                 }else if(p.y<0){
                     p.y+=size;
                 }
                 
                 //bmpDataに描画する
                 bmpData.setPixel(p.x,p.y,0xffffff);
                 p.ax*=0.9;
                 p.ay*=0.95;
                 p.vx*=0.9;
                 p.vy*=0.95;
                 
                }
                //ロックを解除
                bmpData.unlock();
            
        }
        
        
    }
}

class Particle{
    public var x:Number;
    public var y:Number;
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
    public var ax:Number = 0;
    public var ay:Number = 0;
    
    function Particle(px:Number,py:Number){
        x=px;
        y=py;
    }
    
}