/**
 * Copyright lewis_c1986 ( http://wonderfl.net/user/lewis_c1986 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wiIC
 */

package
{
	// Import required shizzle
	import flash.display.*;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.events.Event;
	import flash.ui.*;
	import flash.events.MouseEvent;

	public class ExampleApp extends MovieClip
	{
		private var dragging:String = "";
		private var tl_red:MovieClip;
		private var tr_blue:MovieClip;
		private var myContextMenu:ContextMenu;
		// constructor
		public function ExampleApp()
		{
			// change stage parameters
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			stage.addEventListener(Event.RESIZE, resizeHandler);
			
			myContextMenu = new ContextMenu();
			myContextMenu.hideBuiltInItems();
            var defaultItems:ContextMenuBuiltInItems = myContextMenu.builtInItems;
            defaultItems.print = true;
            
			var my_notice:ContextMenuItem = new ContextMenuItem("custom");
			myContextMenu.customItems.push(my_notice);
			
			// add a sample red square to the display list
			tl_red = new MovieClip();
			var tl_red_shape:Shape = new Shape();
			tl_red_shape.graphics.beginFill( 0xFF0000 );
			tl_red_shape.graphics.drawRect( 0, 0, 100, 100 );
			tl_red_shape.graphics.endFill();
			tl_red.addChild(tl_red_shape);
			
			tr_blue = new MovieClip();
			var tr_blue_shape:Shape = new Shape();
			tr_blue_shape.graphics.beginFill( 0x0000FF );
			tr_blue_shape.graphics.drawRect( 0, 0, 100, 100 );
			tr_blue_shape.graphics.endFill();
			tr_blue.addChild(tr_blue_shape);

			contextMenu = myContextMenu;
			
			tr_blue.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
			tr_blue.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
			this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			this.addChild( tl_red );
			this.addChild( tr_blue );
		}
		private function enterFrameHandler(e:Event):void
		{
			if(dragging != "")
			{
				getChildByName(dragging).x = mouseX;
				getChildByName(dragging).y = mouseY;
			}
		}
		private function mouseDownHandler(e:MouseEvent):void
		{
			dragging = e.target.name;
		}
		private function mouseUpHandler(e:MouseEvent):void
		{
			dragging = "";
		}
		public function resizeHandler():void
		{
			tr_blue.x = stage.stageWidth - tr_blue.width;
			tr_blue.y = stage.stageHeight - tr_blue.height;	
		}
	}
}