/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/whcU
 */

// perlinNoiseでstitchをtrueにすると上下左右が綺麗に繋がる
package {
    import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	[SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 60)]
    public class FlashTest extends Sprite {
		// Variables
		private const NUM:int = 10000;
		private const SIZE:Number = 465;
		private var bmpdata:BitmapData;
		private var vectormap:BitmapData;
		private var particles:Vector.<Particle>;
		private var filter:BlurFilter;
		private var colorTrans:ColorTransform;
		// Constructor
        public function FlashTest() {
			filter = new BlurFilter(2, 2);
			colorTrans = new ColorTransform(.95, .99, .99, .98);
			bmpdata = new BitmapData(SIZE, SIZE, true, 0x00000000);
			
			vectormap = new BitmapData(SIZE, SIZE, false, 0x000000);
			vectormap.perlinNoise(100, 100, 4, Math.random() * 0xFFFFFFFF, true, true,6);
			
			addChild(new Bitmap(vectormap));
			addChild(new Bitmap(bmpdata));
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
			particles = new Vector.<Particle>();
			for (var i:int = 0; i < NUM; i++) {
				var index:uint = particles.push(new Particle(Math.random() * SIZE, Math.random() * SIZE, 0, 0));
				particles[index - 1].time = i;
			}
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:Event):void {
				vectormap.perlinNoise(100, 100, 4, Math.random() * 0xFFFFFFFF, true, true,6);
			});
        }
		private var count:Number = 0;
		private function enterFrameHandler(e:Event):void 
		{
			count = (count + 1) % 360;
			vectormap.lock();
			var x:int = -1;
			var y:int = Math.sin(count * Math.PI / 180) * 2;
			bitmapScroll(vectormap, x, y);
			vectormap.unlock();
			
			bmpdata.lock();
			bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
			bmpdata.colorTransform(bmpdata.rect, colorTrans);
			
			particles.push(new Particle(Math.random() * SIZE, Math.random() * SIZE, 0, 0));
			particles.filter(function(p:Particle, index:int, vector:Vector.<Particle>):Boolean {
				var pixel:uint = vectormap.getPixel(p.x, p.y);
				p.ax += (((pixel / 0x000100) & 0xFF) - 128) * .001;
				p.ay += (((pixel / 0x000001) & 0xFF) - 128) * .001;
				if (p.update() > NUM) {
					return false;
				}
				if (p.x < 0) p.x += SIZE;
				if (p.x > SIZE) p.x -= SIZE;
				if (p.y < 0) p.y += SIZE;
				if (p.y > SIZE) p.y -= SIZE;
				bmpdata.setPixel32(p.x, p.y, 0xFFFFFFFF);
				return true;
			},this);
			bmpdata.unlock();
		}
		private function bitmapScroll(bitmapdata:BitmapData, x:int, y:int):void {
			var sizeWidth:Number = bitmapdata.rect.width;
			var sizeHeight:Number = bitmapdata.rect.height;
			var w:ByteArray;
			var h:ByteArray;
			if (x >= 0) {
				h = bitmapdata.getPixels(new Rectangle(sizeWidth - x, 0, x, sizeHeight));
			} else {
				h = bitmapdata.getPixels(new Rectangle(0, 0, -x, sizeHeight));
			}
			bitmapdata.scroll(x, 0);
			h.position = 0;
			if (x >= 0) {
				bitmapdata.setPixels(new Rectangle(0, 0, x, sizeHeight), h);
			}else {
				bitmapdata.setPixels(new Rectangle(sizeWidth + x, 0, -x, sizeHeight) , h);
			}
			
			if (y >= 0) {
				w = bitmapdata.getPixels(new Rectangle(0, sizeHeight - y,  sizeWidth, y));
			} else {
				w = bitmapdata.getPixels(new Rectangle(0, 0, sizeWidth, -y));
			}
			bitmapdata.scroll(0, y);
			w.position = 0;
			if (y>= 0) {
				bitmapdata.setPixels(new Rectangle(0, 0, sizeWidth, y), w);
			}else {
				bitmapdata.setPixels(new Rectangle(0, sizeHeight + y, sizeWidth, -y) , w);
			}
		}
    }
}
class Particle {
	private var _time:Number;
	private var _x:Number;
	private var _y:Number;
	private var _vx:Number;
	private var _vy:Number;
	private var _ax:Number;
	private var _ay:Number;
	public function Particle(x:Number, y:Number, vx:Number = 0, vy:Number = 0) {
		_time = 0;
		_x = x;
		_y = y;
		_vx = vx;
		_vy = vy;
		_ax = 0;
		_ay = 0;
	}
	public function update():Number {
		_x += _vx+= _ax;
		_y += _vy+= _ay;
		_ax *= .94;
		_ay *= .94;
		_vx *= .88;
		_vy *= .88;
		_time++;
		return _time;
	}
	public function get x():Number { return _x; }
	public function set x(value:Number):void { _x = value; }
	public function get y():Number { return _y; }
	public function set y(value:Number):void { _y = value; }
	public function get vx():Number { return _vx; }
	public function set vx(value:Number):void { _vx = value; }
	public function get vy():Number { return _vy; }
	public function set vy(value:Number):void { _vy = value; }
	public function get ax():Number { return _ax; }
	public function set ax(value:Number):void { _ax = value; }
	public function get ay():Number { return _ay; }
	public function set ay(value:Number):void { _ay = value; }
	public function get time():Number { return _time; }
	public function set time(value:Number):void { _time = value; }
}