/**
 * Copyright n0wri ( http://wonderfl.net/user/n0wri )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/whSs
 */

// forked from n0wri's ピクセルディゾルブ基本
//low pixel
package
{
	import flash.geom.Matrix;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.events.TimerEvent;
	import flash.utils.Timer;
	import flash.display.BitmapData;
	import jp.progression.commands.net.LoadBitmapData;
	import jp.progression.commands.lists.LoaderList;
	import flash.system.LoaderContext;
	import flash.display.Bitmap;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextField;
	import flash.net.URLRequest;
	import flash.display.Sprite;

	public class PixelDissolveLow extends Sprite
	{
		private var txt:TextField;
		private var lst:LoaderList;
		private var bmdCanvas:BitmapData;
		private var bmd2:BitmapData;
		private var rect:Rectangle;
		private var pt:Point;
		private var randomSeed:int;
		private var allPixel:int;
		private var interval:int;
		private var px:uint;
		
		public function PixelDissolveLow()
		{
			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.frameRate = 30;
			
			var url1:String="http://assets.wonderfl.net/images/related_images/1/1a/1afe/1afe5ff5b68f32f280753a05f2e08e4ad4c0f076m";
			var url2:String="http://assets.wonderfl.net/images/related_images/3/30/30dc/30dc90d884393e1f57e5a37b09ca5ad54ca9370em";
			
			lst = new LoaderList();
			lst.addCommand
			(
				new LoadBitmapData(new URLRequest(url1),{context:new LoaderContext(true)}),
				new LoadBitmapData(new URLRequest(url2),{context:new LoaderContext(true)}),
				completeFunc
			);
			lst.execute();	
			txt = new TextField();
			txt.textColor=0x000000;
			txt.autoSize=TextFieldAutoSize.LEFT;
			addChild(txt);
		}

		private function completeFunc():void
		{
			dissolve();
		}

		private function dissolve():void
		{
			//set src bmd
			var bmd1:BitmapData = lst.data[0];
			bmd2 = lst.data[1];
			var bmp1:Bitmap = new Bitmap(bmd1);
			var bmp2:Bitmap = new Bitmap(bmd2);
			var mat:Matrix = new Matrix();
			mat.scale(0.1, 0.1);
			
			var bmdLow1:BitmapData = new BitmapData(bmd1.width/5, bmd1.height/10);
			var bmdLow2:BitmapData = new BitmapData(bmd2.width/5, bmd2.height/10);
			
			bmdLow1.draw( bmd1, mat);
			bmdLow2.draw( bmd2, mat );
			
			bmd1 = bmdLow1;
			bmd2 = bmdLow2;
			
			bmp1.scaleX=bmp1.scaleY=bmp2.scaleX=bmp2.scaleY=0.5;
			addChild(bmp1);
			addChild(bmp2);
			bmp2.x = -bmp2.width+stage.stageWidth;
			bmp1.y=20;
			
			//set canvas
			bmdCanvas = bmdLow1.clone();
			var bmdW:int = bmdCanvas.width;
			var bmdH:int = bmdCanvas.height;
			var bmpCanvas:Bitmap = new Bitmap(bmdCanvas);
			addChild(bmpCanvas);
			bmpCanvas.scaleX=bmpCanvas.scaleY=10;
			bmpCanvas.x=stage.stageWidth/2 - (bmpCanvas.width/2);
			bmpCanvas.y=stage.stageHeight-bmpCanvas.height-50;
			
			
			rect = new Rectangle(0,0,bmdCanvas.width,bmdCanvas.height);
			pt = new Point(0,0);
			allPixel = bmdW*bmdH;
			interval = 8;
			px = getPixelBySecond(2);
			var timer:Timer = new Timer(interval);
			timer.addEventListener(TimerEvent.TIMER, update);
			timer.start();
		}

		private function update(event:TimerEvent):void
		{
			randomSeed = bmdCanvas.pixelDissolve(bmd2, rect, pt, randomSeed, px);
		}
		
		private function getPixelBySecond( time:Number ):uint
		{
			return uint(allPixel/(time*1000/interval));
		}
		
		//util
		private function setText(nanika:*):void
		{
			txt.text = String(nanika) + "\n";
		}
	}
}