/**
 * Copyright hrtsgt ( http://wonderfl.net/user/hrtsgt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/whQH
 */

package
{
    import com.adobe.images.PNGEncoder;
    import com.bit101.components.*;
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    [SWF(width=465, height=465, backgroundColor=0xCCCCCC, frameRate=30)]
    
    public class SimpleCrop extends Sprite
    {
        private const W:Number = 300;
        private const H:Number = 300;
        private var WW:Number;
        private var HH:Number;
        private var AX:Number;
        private var AY:Number;
        private const BX:Number = 10;
        private const BY:Number = 10;
        private var fr:FileReference;
        private var loader:Loader;
        private var bmp:Bitmap;
        private var wrapper:Sprite;
        private var frame:Sprite;
        private var handle:Sprite;
        private var handles:Vector.<Maru>;
        private var maru:Maru;
        private var cMaru:Maru;
        private var marus:Array;
        private var m:int;
        private var fileName:String;
        
        private var label0:Label;
        private var label1:Label;
        private var loadButton:PushButton;
        private var saveButton:PushButton;
        private var cwRotateButton:PushButton;
        private var ccwRotateButton:PushButton;
        private var bar:ProgressBar;
        
        //------------------------------------------------------------------------------------- コンストラクタ
        public function SimpleCrop()
        {
            if( stage ) init();
            else  this.addEventListener( Event.ADDED_TO_STAGE, init);//
            Wonderfl.capture_delay(5);
        }
    
        //------------------------------------------------------------------------------------- init
        private function init( e:Event=null ):void
        {
            if( e ) this.removeEventListener( Event.ADDED_TO_STAGE, init);//
            
            AX = (stage.stageWidth - W)*0.5 | 0;
            AY = (stage.stageHeight - H)*0.5 | 0;
            initItems();////
            loadButton.visible = true;
        }
        
        //------------------------------------------------------------------------------------- ロードボタンクリック
        private function onClickStart( e:MouseEvent ):void
        {            
            fr = new FileReference();
            fr.addEventListener( Event.SELECT, onFileSelect);
            //fr.addEventListener(Event.OPEN, onFileOpen);
            //fr.addEventListener(ProgressEvent.PROGRESS, onProgress);
            fr.addEventListener(Event.COMPLETE, onFileComplete);
            //fr.addEventListener(DataEvent.UPLOAD_COMPLETE, onFileUpload);
            //fr.addEventListener(IOErrorEvent.IO_ERROR, ioErrorHandler);
            //fr.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityErrorHandler);
            fr.browse();
        }
        //------------------------------------------------------------------------------------- ファイルセレクト
        private function onFileSelect( e:Event ):void
        {
            stage.addEventListener( KeyboardEvent.KEY_DOWN, onKeyDown);//
            if( wrapper.numChildren > 0 ){
                loadButton.visible = saveButton.visible = cwRotateButton.visible = ccwRotateButton.visible = handle.visible = frame.visible = label0.visible = label1.visible = false;
                wrapper.removeChildAt(0);
            }else{
                loadButton.visible = false;
            }
            
            loader = new Loader();
            loader.contentLoaderInfo.addEventListener( ProgressEvent.PROGRESS, onProgress);//
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onComplete);//
            
            fileName = fr.name;
            bar.visible = true;
            fr.load();
        }    
        //------------------------------------------------------------------------------------- セレクト完了アップロード開始
        private function onFileComplete( e:Event ):void
        {
            fr.removeEventListener( Event.SELECT, onFileSelect);//
            fr.removeEventListener( Event.COMPLETE, onFileComplete);//
            loader.loadBytes( fr.data );
        }
        private function onProgress( e:ProgressEvent ):void
        {
            bar.value = e.bytesLoaded;
            bar.maximum = e.bytesTotal;
        }
        private function onComplete( e:Event=null ):void
        {
            loader.contentLoaderInfo.removeEventListener( ProgressEvent.PROGRESS, onProgress);//
            loader.contentLoaderInfo.removeEventListener( Event.COMPLETE, onComplete);//
            bmp = loader.content as Bitmap;
            bmp.smoothing = true;
            
            handle.x = AX;
            handle.y = AY;
            handle.rotation = 0;
            wrapper.addChild( bmp );
            wrapper.x = wrapper.y = 0;
            wrapper.scaleX = wrapper.scaleY = 1;
            
            WW = bmp.width;
            HH = bmp.height;
            var r:Number = WW > W ? 1/((WW/W)) : 1;
            wrapper.width = r*wrapper.width | 0;
            wrapper.height = r*wrapper.height | 0;
            
            deploy();//
        }
        //------------------------------------------------------------------------------------- deploy
        private function deploy():void
        {
            stage.addEventListener( KeyboardEvent.KEY_DOWN, onKeyDown);//
            bar.visible = false;
            
            for(var i:int=0; i<4; i++)
            {
                handles[i].visible = true;
                handles[i].x = i%2*wrapper.width;
                handles[i].y = (i/2 | 0)*wrapper.height;
            }
            label0.text = "[ORIGINAL IMAGE] name=" + fileName + " ,width=" + bmp.bitmapData.width + ", height=" + bmp.bitmapData.height;
            loadButton.visible = saveButton.visible = cwRotateButton.visible = ccwRotateButton.visible = handle.visible = frame.visible = label0.visible = label1.visible = true;
        }
        //------------------------------------------------------------------------------------- イメージドラッグ
        private function onImageDown( e:MouseEvent ):void
        {
            stage.addEventListener( MouseEvent.MOUSE_UP, onImageUp );
            handle.startDrag();
        }
        private function onImageUp( e:MouseEvent ):void
        {
            stage.removeEventListener( MouseEvent.MOUSE_UP, onImageUp );
            stopDrag();
            reloadLabel1();//
        }
        //------------------------------------------------------------------------------------- ハンドルドラッグ
        private function onMaruDown( e:MouseEvent ):void
        {
            maru = e.target as Maru;
            m = Number(maru.name);
            cMaru = handles[marus[0][m]];
            stage.addEventListener( MouseEvent.MOUSE_MOVE, onMaruMove);//
            stage.addEventListener( MouseEvent.MOUSE_UP, onMaruUp);//
        }
        private function onMaruUp( e:MouseEvent ):void
        {
            stage.removeEventListener( MouseEvent.MOUSE_MOVE, onMaruMove);//
            stage.removeEventListener( MouseEvent.MOUSE_UP, onMaruUp);//
        }
        private function onMaruMove( e:MouseEvent ):void
        {
            var _w:Number = Math.abs(handle.mouseX - cMaru.x);
            var _h:Number = Math.abs(handle.mouseY - cMaru.y);
            if( _w/_h >= WW/HH ){
                maru.y = handle.mouseY;
                maru.x = Math.abs(maru.y - cMaru.y)*WW/HH | 0;
                if( m == 0 || m == 2 ) maru.x *= -1;
                maru.x += cMaru.x;
            }else{
                maru.x = handle.mouseX;
                maru.y = Math.abs(maru.x - cMaru.x)*HH/WW | 0;
                if( m == 0 || m == 1 ) maru.y *= -1;
                maru.y += cMaru.y;
            }
            handles[marus[1][m]].x = maru.x;
            handles[marus[2][m]].y = maru.y;
            wrapper.x = handles[0].x;
            wrapper.y = handles[0].y;
            wrapper.width = handles[3].x - handles[0].x;
            wrapper.height = handles[3].y - handles[0].y;
            
            reloadLabel1();//
        }
        //------------------------------------------------------------------------------------- 回転
        private function onClickRotate( _b:Boolean ):Function
        {
            return function(e:MouseEvent):void
            {
                 handle.x = AX + (W*0.5 | 0);
                handle.y = AY + (H*0.5 | 0);
                for(var i:int=0; i<4; i++)
                {
                    handles[i].x -= wrapper.x;
                    handles[i].y -= wrapper.y;
                }
                wrapper.x = wrapper.y = 0;

                handle.rotation += _b ? 90 : -90;
            };
        }
        
        //------------------------------------------------------------------------------------- キーダウン
        private function onKeyDown( e:KeyboardEvent ):void
        {
            var d:Number = e.shiftKey ? 10 : 1;
            switch( e.keyCode ){
                case 37 :
                    handle.x -= d;
                    break;
                case 38 :
                    handle.y -= d;
                    break;
                case 39 :
                    handle.x += d;
                    break;
                case 40 :
                    handle.y += d;
                    break;
                default :
                    break;
            }
            reloadLabel1();//
        }
        
        private function reloadLabel1():void
        {
            label1.text = "[DEFORMED IMAGE] width=" + wrapper.width + ", height=" + wrapper.height + ", x=" + (handle.x-AX+wrapper.x) + ", y=" + (handle.y-AY+wrapper.y);
        }
        
        //------------------------------------------------------------------------------------- 画像保存
        private function onClickSave( e:MouseEvent ):void
        {
            var bmpd:BitmapData = new BitmapData( W, H, false, 0xFFFFFF);
            var matrix:Matrix = new Matrix();
            matrix.scale( wrapper.scaleX, wrapper.scaleY);
            matrix.translate( wrapper.x, wrapper.y);
            matrix.rotate( handle.rotation/180*Math.PI );
            matrix.translate( handle.x-AX, handle.y-AY);
            var rect:Rectangle = new Rectangle( 0, 0, W, H);
            bmpd.draw( bmp.bitmapData, matrix, null, null, rect, true);
            
            fr.save(PNGEncoder.encode(bmpd), uniqueFileName() );
        }
        
        //------------------------------------------------------------------------------------- 一意のファイル名
        private function uniqueFileName():String
        {
            var t:String = String( new Date().getTime() );
            var s:String = fileName.substr( 0, fileName.indexOf(".") ) + "_";
            
            for(var i:int=0; i<t.length; i++)
            {
                var n:int = Number(t.charAt(i));
                n = Math.round(n*(25/9)) + 97;
                s += String.fromCharCode( n );
            }
            s +=  ".png";
            return s;
        }
        
        
        //------------------------------------------------------------------------------------- アイテムの初期化
        private function initItems():void
        {
            bar = new ProgressBar( this, AX, AY);
            bar.visible = false;
            bar.setSize( 200, 10);
            handle = new Sprite();
            handle.visible = false;
            addChild( handle );
            
            wrapper = new Sprite();
            wrapper.addEventListener( MouseEvent.MOUSE_DOWN, onImageDown );
            handle.addChild( wrapper );
            
            loadButton = new PushButton(this, BX, BY, "UPLOAD IMAGE", onClickStart);
            saveButton = new PushButton( this, BX+105, BY, "SAVE IMAGE", onClickSave);//
            cwRotateButton = new PushButton( this, BX+210, BY, "ROTATE CW", onClickRotate(true));
            ccwRotateButton = new PushButton( this, BX+315, BY, "ROTATE CCW", onClickRotate(false));//
            label0 = new Label( this, BX, BY+20, "");
            label1 = new Label( this, BX, BY+35, "[DEFORMED IMAGE]");
            saveButton.visible = cwRotateButton.visible = ccwRotateButton.visible = label0.visible = label1.visible = false;
            
            frame = new Sprite();
            frame.x = AX;
            frame.y = AY;
            frame.visible = false;
            frame.mouseEnabled = false;
            frame.graphics.beginFill( 0x0, 0.8);
            frame.graphics.drawRect( -3, -3, W+6, H+6);
            frame.graphics.drawRect( 0, 0, W, H);
            addChild( frame);
            
            marus = [ [3,2,1,0], [2,3,0,1], [1,0,3,2]];
            handles = new Vector.<Maru>( 4, true);
            for(var i:int=0; i<4; i++)
            {
                maru = new Maru();
                maru.alpha = 0.8;
                maru.visible = false;
                maru.buttonMode = true;
                maru.name = String(i);
                maru.addEventListener( MouseEvent.MOUSE_DOWN, onMaruDown);//
                handle.addChild( maru );
                handles[i] = maru;
            }
        }
        
    }
}

import flash.display.Sprite;

class Maru extends Sprite
{
    function Maru()
    {
        this.graphics.beginFill( 0x0 );
        this.graphics.drawCircle( 0, 0, 7);
        this.graphics.beginFill( 0x666666, 0.5 );
        this.graphics.drawCircle( 0, 0, 5);
        this.graphics.endFill();
    }

}