/**
 * Copyright kihon ( http://wonderfl.net/user/kihon )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/whK6
 */

package
{
    import flash.display.Sprite;

    public class Main extends Sprite
    {
        public function Main()
        {
            // 背景を真っ黒に
            graphics.beginFill(0x0);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();

            var panel:Panel = new Panel();
            addChild(panel);
        }
    }
}

import flash.display.Sprite;

class Panel extends Sprite // ブロックはパネルに貼る
{
    public static const WIDTH:int = 10;     // ブロックの数 - 横
    public static const HEIGHT:int = 10;     // ブロックの数　- 縦

    private var blocks:Array;

    public function Panel()
    {
        createBlocks();
    }

    private function createBlocks():void
    {
        blocks = new Array(WIDTH);

        for (var y:int = 0; y < HEIGHT; y++)
        {
            blocks[y] = new Array(HEIGHT);

            for (var x:int = 0; x < WIDTH; x++)
            {
                var block:Block = new Block();
                block.x = x * Block.WIDTH;
                block.y = y * Block.HEIGHT;
                addChild(block);

                blocks[y][x] = block;
            }
        }
    }
}

class Block extends Sprite
{
    public static const WIDTH:int = 30; // ブロックの横幅
    public static const HEIGHT:int = 30; // ブロックの縦幅
    public static const MARGIN_W:int = 1;
    public static const MARGIN_H:int = 1;

    public function Block()
    {    
        graphics.beginFill(0xED1A3D);
        graphics.drawRect(MARGIN_W, MARGIN_H, WIDTH - MARGIN_W * 2, HEIGHT - MARGIN_H * 2);
        graphics.endFill();
    }
}