/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wh1V
 */

package {
  import flash.display.Shape;
  import flash.display.Sprite;
  import flash.events.Event;

  import funnel.*;
  import funnel.i2c.*;

  [SWF(backgroundColor="0xFFFFFF")]

  public class MeasureAzimuth extends Sprite {
    private var arduino:Arduino;

    // デジタルコンパスHMC6352
    private var compass:HMC6352;

    // コンパスの針
    private var clockHand:Shape;

    public function MeasureAzimuth() {
      // A2とA3を電源ピンにセットして、準備完了のイベントにリスナをセット
      var config:Configuration = Arduino.FIRMATA;
      config.enablePowerPins();
      arduino = new Arduino(config);
      arduino.addEventListener(FunnelEvent.I2C_POWER_PINS_READY, 
                               onPowerPinsReady);

      // コンパスの針を初期化
      initClockHand();
    }

    // 電源ピンの準備が完了したら
    private function onPowerPinsReady(e:Event):void {
      // デジタルコンパスのインスタンスを生成してイベントリスナをセット
      compass = new HMC6352(arduino);
      compass.addEventListener(Event.CHANGE, onChange);
    }

    private function onChange(e:Event):void {
      // コンパスの方位が更新されたら針の回転角を更新
      clockHand.rotation = compass.heading;
    }

    // コンパスの針をShapeとして用意する
    private function initClockHand():void {
      clockHand = new Shape();
      clockHand.x = 200;
      clockHand.y = 200;
      clockHand.graphics.clear();
      clockHand.graphics.beginFill(0x000000);
      clockHand.graphics.moveTo(0, -100);
      clockHand.graphics.lineTo(20, 20);
      clockHand.graphics.lineTo(0, 0);
      clockHand.graphics.lineTo(-20, 20);
      clockHand.graphics.lineTo(0, -100);
      clockHand.graphics.endFill();
      clockHand.graphics.lineStyle(1, 0x000000);
      clockHand.graphics.drawCircle(0, 0, 102);
      clockHand.rotation = 0;
      this.addChild(clockHand);
    }
  }
}
