/**
 * Copyright paulstamp1 ( http://wonderfl.net/user/paulstamp1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wgru
 */

package {
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
            ScreenManager.addScreenClass( Screen, "LayerA" );
            ScreenManager.addScreenClass( Screen, "LayerB" );
            
            ScreenManager.addScreenClass( TestScreenA, "TestA" );
            ScreenManager.addScreenClass( TestScreenB, "TestB" );
            
            ScreenManager.buildScreen( "TestA", this );
            ScreenManager.buildScreen( "TestB", this );

        }
    }
}
import flash.text.TextField;

import flash.utils.Dictionary;
import flash.display.Sprite;
import flash.display.DisplayObjectContainer;

class ScreenManager{
    
    private static var _screenClasses:Dictionary = new Dictionary();    
    private static var _screenInstances:Dictionary = new Dictionary();
    
    public static function addScreenClass( screenClass:Class, screenName:String ):void{
        _screenClasses[ screenName ] = screenClass;                
    }
    
    public static function removeScreenClass( screenName:String ):void{
        
        if( _screenClasses[ screenName ] == null )
           throw new Error( "ScreenManager :" + screenName + " is not a valid screenName" );
           
        _screenClasses[ screenName ] = null;
    }
   
    public static function buildScreen( screenName:String, container:DisplayObjectContainer ):void{
       
       if( _screenClasses[ screenName ] == null )
           throw new Error( "ScreenManager :" + screenName + " is not a valid screenName" );
       
       var screen:Screen = new _screenClasses[ screenName ]();
       _screenInstances[ screenName] = screen;
       container.addChild( screen );
   }
   
   public static function notifyScreen( screenName:String, notificationName:String, args:Array = null ):void{
       
       if( _screenClasses[ screenName ] == null )
           throw new Error( "ScreenManager :" +  screenName + " is not a valid screenName" );
           
       if( _screenInstances[ screenName ] == null )
           throw new Error( "ScreenManager :" + screenName + " has not been initiated" );
           
       var screen:Screen = _screenInstances[ screenName ];
       screen.notify.apply( null, [, args] );
   }

   public static function destroyScreen( screenName:String ):void{
       
       if( _screenClasses[ screenName ] == null )
           throw new Error( "ScreenManager :" + screenName + " is not a valid screenName" );
           
       if( _screenInstances[ screenName ] == null )
           throw new Error( "ScreenManager :" + screenName + " has not been initiated" );
           
         var screen:Screen = _screenInstances[ screenName ];
         
         if( screen.parent )
             screen.parent.removeChild( screen );
             
         _screenInstances[ screenName ] = null;
   }

    
  
}

class Screen extends Sprite{
    
    public function notify( notificationName:String, args:Array = null ):void{
        
    }

}

class TestScreenA extends Screen{
    public function TestScreenA(){
        graphics.beginFill( 0x990000 );
        graphics.drawRect(0,0,100,100);
        graphics.endFill();
    }
}

class TestScreenB extends Screen{
    public function TestScreenB(){
        graphics.beginFill( 0x009900 );
        graphics.drawRect(100,0,100,100);
        graphics.endFill();
    }
}


