/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wg38
 */

// forked from osamX's スメる
// forked from checkmate's Saqoosha challenge for professionals
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.events.TweenEvent;
	
	/**
	 * おまえん家のｗｗｗｗｗｗマウスｗｗｗｗカーソルｗｗｗｗｗｗｗｗ
	 */
	[SWF(width=465, height=465, backgroundColor=0xffffff, frameRate=30)]
	public class Smell extends Sprite
	{
		private var smellPoint:Point;
		
		private var flyPoint:Point;
		private var flyRot:Number = 0;
		private var flyPointArr:Array;
		private const LENGTH:uint = 5;
		private var boSprite:Sprite;
		private var buTf:TextField;
		private var nnTf:TextField;
		private var paletteArr:Array;
		
		public function Smell():void 
		{
			initSmell();
			initFly();
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			var timer:Timer = new Timer(600, 0);
			timer.addEventListener(TimerEvent.TIMER, timerHandler);
			timer.start();
			
			createSmell();
		}
		
		private function initSmell():void {
			smellPoint = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
			paletteArr = [0x00cc66, 0x66cc66, 0x00cc66, 0x006633, 0x00ffcc];
		}
		
		private function initFly():void {
			flyPoint = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
			flyPointArr = new Array();
			
			//ブ
			buTf = new TextField();
			buTf.selectable = false;
                        buTf.autoSize = "center";
			buTf.defaultTextFormat = new TextFormat("Courier New", null, 0x0, true);
			buTf.text = 
'   　　　 　　　／⌒ヽ\n' + 
'　　　⊂二二二（　＾ω＾）二⊃ \n' + 
'　　　　　　　　|　　　 / 　　　　　　ﾌﾞ\n' +  
'　　　　 　　　 （　ヽノ\n' +
'　　　　　　　　 ﾉ>ノ\n' +
'　　　　 三　　レﾚ';
			addChild(buTf);
			
			//ー
			boSprite = new Sprite();
			addChild(boSprite);
			
			//ン
			nnTf = new TextField();
			nnTf.selectable = false;
			nnTf.defaultTextFormat = new TextFormat(null, null, 0x0, true);
			nnTf.text = 'ﾝ';
			addChild(nnTf);
			
			//init flyPointArr
			for (var i:uint = 0; i < LENGTH; i++) {
				flyPointArr[i] = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
			}
		}
		
		private function createSmellBmp(size:uint):Bitmap {
			var tf:TextField = new TextField();
			tf.x = stage.stageWidth * Math.random();
			tf.y = stage.stageHeight * Math.random();
			var fmt:TextFormat = new TextFormat(null, size, 0xcc6600, true);
			fmt.color = paletteArr[Math.floor(Math.random()*5)];
			tf.defaultTextFormat = fmt;
			tf.text = "うぇ" + new Array(int(Math.random() * 4 + 2)).join('ｗ');
			tf.background = false;
			tf.width = tf.textWidth + 10;
			tf.height = tf.textHeight + 10;
			tf.selectable = false;
			tf.filters = [ new BlurFilter() ];
			var bmd:BitmapData = new BitmapData(tf.width, tf.height, true, 0xFFFFFF);
			bmd.draw(tf);
			return new Bitmap(bmd);
		}
		
		private function createSmell():void {
			var size:uint = Math.floor(Math.random() * 24 + 8);
			var rot:Number = 360 * Math.random();
			var bmp:Bitmap = createSmellBmp(size);
			addChild(bmp);
			bmp.rotation = rot + 90;
			bmp.x = smellPoint.x;
			bmp.y = smellPoint.y;
			bmp.scaleX = 0;
			bmp.scaleY = 0;
			var tween:ITween = BetweenAS3.tween(bmp, 
			{	x:bmp.x + 5 * size * Math.cos(Math.PI * rot / 180) ,
				y:bmp.y + 5 * size * Math.sin(Math.PI * rot / 180) ,
				scaleX:5 ,
				scaleY:5 ,
				alpha:0
			},
			null, 2);
			tween.addEventListener(TweenEvent.COMPLETE, function(e:TweenEvent):void {
				removeChild(bmp);
				bmp = null;
			});
			tween.play();
		}
		
		private function timerHandler(e:TimerEvent):void {
			BetweenAS3.tween(flyPoint, {x: smellPoint.x, y: smellPoint.y }, null, 0.5, Back.easeOutWith(1.9)).play();
		}
		
		private function onEnterFrame(e:Event):void {
			smellPoint.x += (stage.mouseX - smellPoint.x) / 10;
			smellPoint.y += (stage.mouseY - smellPoint.y) / 10;

			if (Math.random() * 3 < 1) createSmell();
			
			flyRot = (flyRot + 10) % 360;
			buTf.x = flyPoint.x + 150 * Math.cos(Math.PI * flyRot / 180) - 200;
			buTf.y = flyPoint.y + 30 * Math.sin(Math.PI * flyRot / 180) - 36;
			refreshFlyPoint(new Point(buTf.x + 200, buTf.y + 36));
			var tp:Point = flyPointArr[LENGTH-1];
			nnTf.x = tp.x;
			nnTf.y = tp.y;
			drawBo();
		}
		
		private function refreshFlyPoint(p:Point):void {
			for (var i:uint = LENGTH; i > 0; i--) {
				flyPointArr[i] = flyPointArr[i - 1];
			}
			flyPointArr[0] = p;
		}
		
		private function drawBo():void {
			boSprite.graphics.clear();
			boSprite.graphics.lineStyle(1);
			for (var i:uint = 1; i < LENGTH - 2; i++) {
				boSprite.graphics.moveTo(flyPointArr[i].x, flyPointArr[i].y+7);
				boSprite.graphics.lineTo(flyPointArr[i+1].x, flyPointArr[i+1].y+7);
			}
		}
	}
	
}