/**
 * Copyright flashisobar ( http://wonderfl.net/user/flashisobar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wfuC
 */

package 
{
    import away3d.cameras.Camera3D;
    import away3d.cameras.lenses.PerspectiveLens;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.debug.AwayStats;
    import away3d.debug.Debug;
    import away3d.debug.Trident;
    import away3d.entities.Mesh;
    import away3d.lights.DirectionalLight;
    import away3d.lights.PointLight;
    import away3d.materials.ColorMaterial;
    import away3d.materials.lightpickers.StaticLightPicker;
    import away3d.primitives.CapsuleGeometry;
    import away3d.primitives.CubeGeometry;
    import away3d.primitives.SphereGeometry;
    import away3d.primitives.TorusGeometry;
    import away3d.primitives.WireframePlane;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    import flash.utils.getTimer;
    
    /**
     * away3d v4 test demo
     * @author flashisobar
     */
    [SWF(width="465",height="465",frameRate="60",backgroundColor="0x0")]
    public class Main extends Sprite 
    {
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var view:View3D;
        private var move:Boolean;
        private var lastPanAngle:Number;
        private var lastTiltAngle:Number;
        private var lastMouseX:Number;
        private var lastMouseY:Number;
        private var cube:Mesh;
        private var stats:AwayStats;
        private var plight:PointLight;
        private var dlight:DirectionalLight;
        private var sphere:Mesh;
        private var torustexture:ColorMaterial;
        private var torus:Mesh;
        private var capsule:Mesh;
        
        ///private var source:BitmapData = new BitmapData(465, 465, false, 0x000000);
        
        public function Main():void 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;

            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            Wonderfl.disable_capture();
            ///addChild(new Bitmap(source));
            
            // debug
            //Debug.active = true;

            init3D();
        }
        
        /*
         * scene
         * camera
         * view
         * light
         * 3D Object
         * render
         */
        private function init3D():void 
        {
            scene = new Scene3D();
            camera = new Camera3D();
            camera.x = 0;
            camera.y = 500
            camera.z = -1000
            camera.lookAt(new Vector3D());
            
            view = new View3D();
            view.backgroundColor = 0x999999;
            view.antiAlias = 2;
            view.scene = scene;
            view.camera = camera;
            addChild(view);
            
            plight = new PointLight();
            //light.y = 1000;
            //light.z = -1000;
            plight.ambient = 0.1;
            plight.diffuse = 0.7;
            plight.position = camera.position;
            scene.addChild(plight);
            
            /*
            dlight = new DirectionalLight(0, -1, 0);
            dlight.ambient = 0.1;
            dlight.diffuse = 0.7;
            scene.addChild(dlight);
            */
            
            var axis:Trident = new Trident(250, true);
            scene.addChild(axis);
            
            // floor
            var floor:WireframePlane = new WireframePlane(2000, 2000, 20, 20, 0x0F0F0F, 1,"xz");
            floor.y = -450;
            scene.addChild(floor);
            
            // cube
            var geomtry:CubeGeometry = new CubeGeometry(200, 150, 100, 1, 1, 1, false);
            var texture:ColorMaterial = new ColorMaterial(Math.random() * 0xFFFFFF, 1);
            texture.lightPicker = new StaticLightPicker([plight]);
            cube = new Mesh(geomtry, texture);
            scene.addChild(cube);
            
            // sphere
            var spheregeomtry:SphereGeometry = new SphereGeometry(100, 64, 32);
            var texture1:ColorMaterial = new ColorMaterial(Math.random() * 0xFFFFFF, 1);
            texture1.lightPicker = new StaticLightPicker([plight]);
            sphere = new Mesh(spheregeomtry, texture1);
            sphere.x = 300;
            scene.addChild(sphere);
            
            // donut
            var torusgeometry:TorusGeometry = new TorusGeometry(100, 60, 40, 20);
            var texture2:ColorMaterial = new ColorMaterial(Math.random() * 0xFFFFFF, 1);
            texture2.lightPicker = new StaticLightPicker([plight]);
            torus = new Mesh(torusgeometry, texture2);
            torus.x = -350;
            scene.addChild(torus);
            
            // 膠囊
            var capsulegeometry:CapsuleGeometry = new CapsuleGeometry(50, 100, 40, 20);
            var texture3:ColorMaterial = new ColorMaterial(Math.random() * 0xFFFFFF, 1);
            texture3.lightPicker = new StaticLightPicker([plight]);
            capsule = new Mesh(capsulegeometry, texture3);
            capsule.y = 250;
            scene.addChild(capsule);

            // stats            
            stats = new AwayStats(view);
            addChild(stats);

            addEventListener(Event.ENTER_FRAME, _onEnterFrame);
            addEventListener(Event.ADDED_TO_STAGE, _onAddedToStage);
            
            stage.addEventListener(Event.RESIZE, onResize);
            onResize();
        }
        
        private function onResize(event:Event = null):void
        {
            view.width = stage.stageWidth;
            view.height = stage.stageHeight;
        }

        private function _onAddedToStage(e:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, _onAddedToStage);

            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        }
        
        private function onMouseUp(e:MouseEvent):void 
        {
            move = false;
        }
        
        private function onMouseDown(e:MouseEvent):void 
        {
            move = true;
        }
        
        private function _onEnterFrame(e:Event):void
        {
            var msec:Number = getTimer();
            
            // update camera position
            camera.x = 1500 * Math.sin(msec / 1200);
            //camera.z = 1500 * Math.cos(msec / 1200);
            //camera.y = 500 * Math.sin(msec / 3000) + 100;
            camera.lookAt(new Vector3D());

            // update 3D object
            cube.rotationY += 1;
            torus.rotationX += 1;
            sphere.y = (Math.sin(msec / 200) * 200);
            capsule.rotationZ += 1;
            view.render();
            ///view.renderer.queueSnapshot(source);
        }
    }
    
}