/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wfcK
 */

// ref 
// Flash Math & Physics Design ActionScript 3.0による数学・物理学表現[実践編]
package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    public class FlashTest extends MovieClip {
        public function FlashTest() {
            // write as3 code here..
            var kazuH:Number = 4;
            var kazuV:Number = 1; 
            var intervalH:Number = 120;
            var intervalV:Number = 200;
            for (var i:Number = 0; i < kazuH; ++i) {
                for (var j:Number = 0; j < kazuV; ++j) {
                    var tx:Number = stage.stageWidth/2
                                    - intervalH*(kazuH - 1)/2
                                    + intervalH*i;
                    var ty:Number = stage.stageHeight/2
                                    - intervalV*(kazuV - 1)/2
                                    + intervalV*j;
                    addChild(new ThePlate(tx, ty));
                    addChild(new TheCircle(tx, ty));
                    addChild(new TheTriangle(tx, ty));
                }

            }

        }
    }
}
import flash.display.ShaderPrecision;
import flash.accessibility.Accessibility;
import flash.display.Shape;
import flash.display.AVM1Movie;
import flash.trace.Trace;

import flash.display.Sprite;
import flash.events.MouseEvent;
import flash.events.TimerEvent;
import flash.geom.Point;
import flash.utils.Timer;

class TheShape extends Sprite {
    public var pin:Sprite = new Sprite();
    public var shapeContent:Sprite = new Sprite();
    public var ppt:PhysicalPoint;
    public var isPressed:Boolean = false;
    
    public var curMouse:Point;
    public var preMouse:Point;
    
    public var color:Number = (Math.random()*10000000)%1677215;
    
    public function onMDown(ev:MouseEvent) :void {
        parent.setChildIndex(this, parent.numChildren-1);
        ppt.x = curMouse.x;
        ppt.y = curMouse.y;
        var kaitenX:Number = (curMouse.x - this.x)
                             * Math.cos(-ppt.angle)
                             - (curMouse.y - this.y)
                             * Math.sin(-ppt.angle);
        var kaitenY:Number = (curMouse.x - this.x)
                             * Math.sin(-ppt.angle)
                             + (curMouse.y - this.y)
                             * Math.cos(-ppt.angle);
        shapeContent.x -= kaitenX;
        shapeContent.y -= kaitenY;
        this.x = ppt.x;
        this.y = ppt.y;
        isPressed = true;
    }
    
    
    public function onMUp(ev:MouseEvent) :void {
        isPressed = false;
    }

    public function loop(event:TimerEvent) :void {
        preMouse = curMouse;
        curMouse = this.localToGlobal(
                   new Point(this.mouseX, this.mouseY));
        ppt.setKakuKasokudo2(
        -Math.atan2(shapeContent.y, shapeContent.x) + Math.PI/2, 30);
        
        if (isPressed) {
            ppt.x = curMouse.x;
            ppt.y = curMouse.y;
            var mouseAngle:Number = Math.atan2(
                                    curMouse.y - preMouse.y,
                                    curMouse.x - preMouse.x);
            var mouseDist:Number = Point.distance(
                                   new Point(curMouse.x, curMouse.y),
                                   new Point(curMouse.x, curMouse.y));
            var distpar:Number = Point.distance(
                                 new Point(shapeContent.x, shapeContent.y),
                                 new Point(0, 0)) / (Math.sqrt(
                                 shapeContent.width * shapeContent.width + 
                                 shapeContent.height * shapeContent.height)/2);
            var k:Number = Math.atan2(shapeContent.y,
                                      shapeContent.x) + ppt.angle;
            var h:Number = mouseAngle + Math.PI;
            var ak:Number = mouseDist * distpar * Math.sin(h-k);
            ppt.setKakuKasokudo(ak*3);
        }
        
        this.x = ppt.x;
        this.y = ppt.y;
        this.rotation = ppt.angle/Math.PI*180;
        

    }
}

class TheCircle extends TheShape {
    public var r:Number = 50;
    function TheCircle(xx:Number, yy:Number) {
        ppt = new PhysicalPoint(xx, yy);
        pin.graphics.lineStyle(1, 0x222222);
        pin.graphics.beginFill(0x222222);
        pin.graphics.drawCircle(0, 0, 5);
        pin.graphics.endFill();
        
        shapeContent.graphics.clear();
        shapeContent.graphics.lineStyle(1, 0x000000);
        //var color:Number = (Math.random()*10000000)%1677215;
        shapeContent.graphics.beginFill(color, 0.8);
        shapeContent.graphics.drawCircle(0, 0, r);
        shapeContent.graphics.endFill();
        
        addChild(shapeContent);
        addChild(pin);
        
        curMouse = this.localToGlobal(
                   new Point(this.mouseX, this.mouseY));
                   
        addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        addEventListener(MouseEvent.MOUSE_UP, onMUp);
        
        var timer:Timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start(); 
    }

}

class TheTriangle extends TheShape {
    public var edge:Number = 100;
    public var tmp:Number = 0.433012702;
    function TheTriangle(xx:Number, yy:Number) {
        ppt = new PhysicalPoint(xx, yy);
        pin.graphics.lineStyle(1, 0x222222);
        pin.graphics.beginFill(0x222222);
        pin.graphics.drawCircle(0, 0, 5);
        pin.graphics.endFill();
        
        shapeContent.graphics.clear();
        shapeContent.graphics.lineStyle(1, 0x000000);
        //var color:Number = (Math.random()*10000000)%1677215;
        shapeContent.graphics.beginFill(color, 0.8);
        var vertices:Vector.<Number>=Vector.<Number>([0,tmp*edge, (edge/2),-(tmp*edge), -(edge/2),-(tmp*edge)]);
        shapeContent.graphics.drawTriangles(vertices);
        shapeContent.graphics.endFill();
        
        addChild(shapeContent);
        addChild(pin);
        
        curMouse = this.localToGlobal(
                   new Point(this.mouseX, this.mouseY));
                   
        addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        addEventListener(MouseEvent.MOUSE_UP, onMUp);
        
        var timer:Timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start(); 
    }

}

class ThePlate extends TheShape {
    public var haba:Number = 80;
    public var takasa:Number = 160;
    
    function ThePlate(xx:Number, yy:Number) {
        ppt = new PhysicalPoint(xx, yy - takasa/4);
        pin.graphics.lineStyle(1, 0x222222);
        pin.graphics.beginFill(0x222222);
        pin.graphics.drawCircle(0, 0, 5);
        pin.graphics.endFill();
        
        shapeContent.graphics.clear();
        shapeContent.graphics.lineStyle(1, 0x000000);
        var color:Number = (Math.random()*10000000)%1677215;
        shapeContent.graphics.beginFill(color, 0.8);
        shapeContent.graphics.drawRect(
                      -haba/2, -takasa/2, haba, takasa);
        shapeContent.graphics.endFill();
        shapeContent.y = takasa/4;
        
        addChild(shapeContent);
        addChild(pin);
        
        curMouse = this.localToGlobal(
                   new Point(this.mouseX, this.mouseY));
                   
        addEventListener(MouseEvent.MOUSE_DOWN, onMDown);
        addEventListener(MouseEvent.MOUSE_UP, onMUp);
        
        var timer:Timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start(); 
    }
}

class PhysicalPoint extends Point {
    public var vx:Number, vy:Number;
    public var ax:Number, ay:Number;
    public var b:Number;
    public var sakkiTime:Number;
    public var timer:Timer;
    
    public var preX:Number, preY:Number;
    
    public var kb:Number;
    public var angle:Number;
    public var preAngle:Number;
    public var kakusokudo:Number;
    public var kakukasokudo:Number;
    
    public var limitter:Number = 0.3;
    
    function PhysicalPoint(xx: Number = 0, yy:Number = 0, an:Number = 0) {
        x = xx; y = yy;
        preX = xx; preY = yy;
        b = 1;
        vx = 0; vy = 0;
        ax = 0; ay = 0;
        
        angle = an;
        preAngle = an;
        kb = 1;
        kakusokudo = 0;
        kakukasokudo = 0;
        
        sakkiTime = new Date().getTime();
        timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
        
    }
    
    public function loop(event:TimerEvent) :void {
        var nowTime:Number = new Date().getTime();
        var t:Number = (nowTime - sakkiTime)/1000;
        
        if (t > limitter) t = limitter;
        
        preX = x;
        preY = y;
        
        x += vx*t + 0.5*ax*t*t;
        y += vy*t + 0.5*ay*t*t;
        
        vx += ax*t; vy += ay*t;
        vx *= b;    vy *= b;
        ax = 0;     ay = 0;
        preAngle = angle;
        angle += kakusokudo * t + 0.5*kakukasokudo*t*t;
        kakusokudo += kakusokudo*t;
        
        kakusokudo *= kb;
        kakukasokudo = 0;
        sakkiTime = nowTime;
    }
    
    public function setKasokudo(aax:Number = 0, aay:Number = 0) :void {
        ax += aax;
        ay += aay;
    }
    
    public function setKasokudoByPolar(r:Number=0, dire:Number = 0) :void {
        ax += r*Math.cos(dire);
        ay += r*Math.sin(dire);
    }
    
    public function setKakuKasokudo(aan:Number = 0) :void {
        kakukasokudo += aan;
    }
    
    public function setKakuKasokudo2(dire:Number, val:Number) :void {
        var aan:Number = val * Math.sin(dire - angle);
        setKakuKasokudo(aan);
    }

}

