/**
 * Copyright Quasimondo ( http://wonderfl.net/user/Quasimondo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wfUL
 */

// forked from matsumos's GetBoundsTest
package
{
    import flash.geom.Point;
    import flash.geom.Matrix;
    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    
    public class GetCircleBoundTest extends Sprite
    {
        private const _circle:Sprite = new Sprite();
        private const _sqare:Sprite = new Sprite();
        private const _rect:Sprite = new Sprite();
        private const _ellipse:Sprite = new Sprite();
        private const _triangle:Sprite = new Sprite();
        private const _roundRect:Sprite = new Sprite();
        private const _rectangles:Sprite = new Sprite();
        
        public function GetCircleBoundTest() 
        {
            _circle.graphics.beginFill(0xFF0000);
            _circle.graphics.drawCircle(0,0,25);
            addChild(_circle);
            _circle.x = 100;
            _circle.y = 50;
            
            _sqare.graphics.beginFill(0xFF0000);
            _sqare.graphics.drawRect(-25, -25, 50, 50);
            addChild(_sqare);
            _sqare.x = 200;
            _sqare.y = 50;
            
            _rect.graphics.beginFill(0xFF0000);
            _rect.graphics.drawRect(-25, -20, 50, 80);
            addChild(_rect);
            _rect.x = 250;
            _rect.y = 150;
            
            _ellipse.graphics.beginFill(0xFF0000);
            _ellipse.graphics.drawEllipse( -25, -15, 50, 30);
            addChild(_ellipse);
            _ellipse.x = 300;
            _ellipse.y = 50;
            
            _roundRect.graphics.beginFill(0xFF0000);
            _roundRect.graphics.drawRoundRect( -25, -15, 50, 30, 20, 20);
            addChild(_roundRect);
            _roundRect.x = 400;
            _roundRect.y = 50;
            
            _rectangles.graphics.beginFill(0xFF0000);
            _rectangles.graphics.drawRect(-25, -25, 50, 50);
            _rectangles.graphics.drawRect(15, 15, 50, 50);
            addChild(_rectangles);
            _rectangles.x = 100;
            _rectangles.y = 200;
            
            _triangle.graphics.beginFill(0xFF0000);
            _triangle.graphics.lineTo(0, 0);
            _triangle.graphics.lineTo(20, 20);
            _triangle.graphics.lineTo(-20, 20);
            _triangle.graphics.lineTo(0, 0);
            _triangle.graphics.endFill();
            addChild(_triangle);
            _triangle.x = 400;
            _triangle.y = 200;
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        }
        
        private function enterFrameHandler(e:Event):void 
        {
            graphics.clear();
            
            _circle.rotation += 1;
            drawBounds(_circle);
            
            _sqare.rotation += 1;
            drawBounds(_sqare);
            
            _ellipse.rotation += 1;
            drawBounds(_ellipse);
            
            _triangle.rotation += 1;
            drawBounds(_triangle);
            
            _rectangles.rotation += 1;
            drawBounds(_rectangles);
            
            _roundRect.rotation += 1;
            drawBounds(_roundRect);
            
            _rect.rotation += 1;
            drawBounds(_rect);
        }
        
        private function drawBounds(target:DisplayObject):void
        {
            graphics.beginFill(0x0, 0.5);
            const rect:Rectangle = target.getBounds(target);
            var m:Matrix = target.transform.matrix;
            var p1:Point = rect.topLeft;
            var p2:Point = new Point( p1.x + rect.width,p1.y );
            var p3:Point = rect.bottomRight;
            var p4:Point = new Point( p1.x,p1.y + rect.height);
            
            p1 = m.transformPoint(p1);
            p2 = m.transformPoint(p2);
            p3 = m.transformPoint(p3);
            p4 = m.transformPoint(p4);
            
            graphics.moveTo( p1.x, p1.y );
            graphics.lineTo( p2.x, p2.y );
            graphics.lineTo( p3.x, p3.y );
            graphics.lineTo( p4.x, p4.y );
            graphics.endFill();
        }
        
    }

}