/**
 * Copyright christian ( http://wonderfl.net/user/christian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wfJZ
 */

package
{
    import flash.events.*;
    import flash.display.*;
    import flash.system.System;
    import flash.net.FileReference;

    import com.bit101.components.*;
    import com.adobe.images.PNGEncoder;

    /**  @author SPANVEGA // CHRISTIAN  **/

    [ SWF (width = '465', height = '465', backgroundColor = '0xFFFFFF', frameRate = '25')]

    public class NOISE_PATTERN_GENERATOR extends Sprite
    {
        private var g_com : Vector.<int> = new <int>[1, 2, 2, 2, 2];
        private var g_dat : Vector.<Number> = new <Number>[];

        private var W : uint, H : uint;

        private var panel_btn : CheckBox;
        private var panel_sel : Sprite;
        private var panel : Sprite;

        private var gs : Boolean = false;
        private var sd : int =  0xDC;
        private var lo : uint = 0xA0;
        private var hi : uint = 0xFF;
        private var ch : uint = 7;

        private var _h : uint = 25;
        private var _w : uint = 1;


        public function NOISE_PATTERN_GENERATOR ()
        {
            Wonderfl.disable_capture ();

            stage ? init () : addEventListener (Event.ADDED_TO_STAGE, init);
        }

        private function init (e : Event = null) : void
        {
            if (hasEventListener (Event.ADDED_TO_STAGE))
            {removeEventListener (Event.ADDED_TO_STAGE, init);}

            stage.scaleMode = 'noScale';

            H = stage.stageHeight;
            W = stage.stageWidth;

            //

            g_dat.push (0, 0, W, 0, W, H, 0, H, 0, 0);

            setUI ();
        }

        private function pattern () : void
        {
            graphics.clear ();
            graphics.drawGraphicsData
            (
                Vector.<IGraphicsData>
                ([
                    new GraphicsBitmapFill
                    (
                        NOISE_PATTERN.build (_w, _h, sd, lo, hi, ch, gs)
                    ),
                    new GraphicsPath (g_com, g_dat)
                ])
            );
        }

        private function setUI () : void
        {
            panel = new Sprite ();

            panel_sel = new Sprite ();
            panel_sel.graphics.drawGraphicsData
            (
                Vector.<IGraphicsData>
                ([
                    new GraphicsStroke
                    (
                        1, true, 'normal', 'none', 'round', 3, new GraphicsSolidFill (0xAAAAAA, 1)
                    ),
                    new GraphicsSolidFill (0xFFFFFF, 0.75),
                    graphicsBorderPath (0, 0, 179, 159)
                ])
            );

            panel_sel.addEventListener (MouseEvent.MOUSE_DOWN, drag);
            panel_sel.addEventListener (MouseEvent.MOUSE_UP,   drag);

            panel.addChild (panel_sel);

            panel_btn = new CheckBox (panel, 5, 5, null, display);
            panel_btn.selected = true;

            var _lbl : Label = new Label (panel, 30, 1, 'NOISE PATTERN');

            var separator : Shape = new Shape ();
            separator.graphics.drawGraphicsData
            (
                Vector.<IGraphicsData>
                ([
                    new GraphicsStroke (1, true, 'normal', 'none', 'round', 3, new GraphicsSolidFill (0xAAAAAA, 1)),
                    new GraphicsPath (Vector.<int>([1, 2]), Vector.<Number>([32, 20, 102, 20]))
                ])
            );

            panel.addChild (separator);

            //

            var l__w : Label = new Label (panel, 30, 27, 'W');

            var n__w : NumericStepper = new NumericStepper (panel, 47, 27, set_W);
            n__w.setSize (60, 16);
            n__w.maximum = W;
            n__w.minimum = 1;
            n__w.value = _w;
            n__w.draw ();

            var l__h : Label = new Label (panel, 111, 27, 'H');

            var n__h : NumericStepper = new NumericStepper (panel, 128, 27, set_H);
            n__h.setSize (60, 16);
            n__h.maximum = H;
            n__h.minimum = 1;
            n__h.value = _h;
            n__h.draw ();

            var l__s : Label = new Label (panel, 30, 48, 'SEED');

            var n__r : NumericStepper = new NumericStepper (panel, 75, 49, setSD);
            n__r.setSize (113, 16);
            n__r.maximum = int.MAX_VALUE;
            n__r.minimum = int.MIN_VALUE;
            n__r.value = sd;
            n__r.draw ();

            var b_rd : PushButton = new PushButton (panel, 140, 49, 'R', setRD);
            b_rd.setSize (16, 16);
            b_rd.draw ();

            var l_hl : Label = new Label (panel, 30, 65, 'RANGE');

            var s_hl : HRangeSlider = new HRangeSlider (panel, 75, 83, null);
            s_hl.maximum = 0xFF;
            s_hl.minimum = 0x00;
            s_hl.highValue = hi;
            s_hl.lowValue  = lo;
            s_hl.width = 113;
            s_hl.draw ();

            s_hl.addEventListener (Event.CHANGE, setRG);

            var cb_a : Array =
            [
                // RGB
                { label : 'RED', data : 1 },
                { label : 'GREEN', data : 2 },
                { label : 'RED | GREEN', data : 3 },
                { label : 'BLUE', data : 4 },
                { label : 'RED | BLUE', data : 5 },
                { label : 'GREEN | BLUE', data : 6 },
                { label : 'RED | GREEN | BLUE', data : 7 },
                { label : 'ALPHA', data : 8 },
                // ARGB
                { label : 'ALPHA | R', data : 9 },
                { label : 'ALPHA | G', data : 10 },
                { label : 'ALPHA | R | G', data : 11 },
                { label : 'ALPHA | B', data : 12 },
                { label : 'ALPHA | R | B', data : 13 },
                { label : 'ALPHA | G | B', data : 14 },
                { label : 'ALPHA | R | G | B', data : 15 }
            ];

            var l_ch : Label = new Label (panel, 30, 98, 'COLOR');

            var cb_c : ComboBox = new ComboBox (panel, 75, 99, '', cb_a);
            cb_c.addEventListener (Event.SELECT, setCH);
            cb_c.numVisibleItems = cb_a.length;
            cb_c.selectedIndex = ch - 1;
            cb_c.setSize (113, 16);
            cb_c.draw ();

            var c_gs : CheckBox = new CheckBox (panel, 75, 121, 'GRAYSCALE', setGS);

            //

            var b_sv : PushButton = new PushButton (panel, 75, 137, 'EXPORT', export);
            b_sv.setSize (57, 16);
            b_sv.draw ();

            var b_cp : PushButton = new PushButton (panel, 131, 137, 'COPY', clipboard);
            b_cp.setSize (57, 16);
            b_cp.draw ();

            //

            panel.x = W - (panel_sel.width + 10);
            panel.y = 10;

            addChild (panel);
        }

        private function set_W (e : Event) : void { try { _w = e.target.value; } catch (e : Error) {} pattern (); }
        private function set_H (e : Event) : void { try { _h = e.target.value; } catch (e : Error) {} pattern (); }
        private function setSD (e : Event) : void { try { sd = e.target.value; } catch (e : Error) {} pattern (); }
        private function setRG (e : Event) : void { lo = e.target.lowValue; hi = e.target.highValue;  pattern (); }
        private function setRD (e : Event) : void { sd = panel.getChildAt(9)['value'] = getInt (); pattern (); }
        private function setCH (e : Event) : void { ch = e.target.selectedItem.data; pattern (); }
        private function setGS (e : Event) : void { gs = e.target.selected; pattern (); }

        private function getInt () : int
        {
            return int (int.MIN_VALUE + Math.random () * int.MAX_VALUE * 2);
        }

        private function display (e : Event) : void
        {
            panel.x = W - (e.target.selected ? panel_sel.width + 10 : 20);
            panel.y = 10;
        }

        private function drag (e : MouseEvent) : void
        {
            if (panel_btn.selected) panel[(e.type == 'mouseUp' ? 'stopDrag' : 'startDrag')]();
        }

        private function graphicsBorderPath (x : int, y : int, w : Number, h : Number) : GraphicsPath
        {
            var header_w : uint = 20;
            var header_h : uint = 20;

            return new GraphicsPath
            (
                Vector.<int>([1, 2, 2, 2, 2, 2, 2]),
                Vector.<Number>
                ([
                    x, y,
                    x + w + header_w, y, x + w + header_w, y + h,
                    x + header_w, y + h, x + header_w, y + header_h,
                    x, y + header_h,  x, y
                ])
            );
        }

        private function export (e : Event) : void
        {
            new FileReference().save (PNGEncoder.encode (NOISE_PATTERN.b), 'NOISE_PATTERN.png');
        }

        private function clipboard (e : Event) : void
        {
            System.setClipboard ('noise (' + sd + ', ' + lo + ', ' + hi + ', ' + ch + ', ' + gs +')');
        }
    }
}

//

import flash.display.BitmapData;

internal class NOISE_PATTERN
{
    public static function build
    (
        width : uint, height : uint, seed : int, lo : uint, hi : uint, colors : uint, grayscale : Boolean
    ) : BitmapData
    {
        b = new BitmapData (width, height, true, 0x00FFFFFF);
        b.noise (seed, lo, hi, colors, grayscale);
        return b;
    }

    public static var b : BitmapData;
}