/**
 * Copyright zob ( http://wonderfl.net/user/zob )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wdsy
 */

package  {
    import flash.events.Event;
    import flash.display.Sprite;
    import flash.display.Loader;
    import flash.system.LoaderContext;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.net.URLRequest;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.display.MovieClip;
    import flash.media.Camera;
    import flash.media.Video;
    
    public class hahaha extends Sprite {
        private var BMPD           :BitmapData;
        private var DRAW_PANEL:Sprite = new Sprite();
        
        private var DRAGGING:Boolean = false;
        private var OLD_MOUSE:Point = new Point();
        private var NEW_MOUSE:Point = new Point();
        private var mouse:MovieClip = new MovieClip();
        private var cameraWidth_:uint;
        private var cameraHeight_:uint;
        private var webcam:Camera;
        private var video:Video;
        public function hahaha() {
            // constructor code
            webcam = Camera.getCamera();
            if (webcam) {
                webcam.setMode(stage.stageWidth, stage.stageHeight, stage.frameRate);
                video = new Video(stage.stageWidth, stage.stageHeight);
                video.attachCamera(webcam);
            }
            
            BMPD = new BitmapData(stage.stageWidth, stage.stageHeight, false);
            addChild(new Bitmap(BMPD));
            
            mouse.addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0)));
            addChild(mouse);
            mouse.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onmouseUp);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onmouseMove);
            stage.addEventListener(Event.ENTER_FRAME, processing);
        }
        
        private function processing(e:Event):void
        {
            BMPD.draw(video);
        }
        
        private function onmouseDown(e:MouseEvent):void
        {
            OLD_MOUSE.x = mouseX; OLD_MOUSE.y = mouseY;
            DRAGGING = true;
        }
        
        private function onmouseUp(e:MouseEvent):void
        {
            mouse.graphics.clear();
            if(DRAGGING)
            {
                var VX:Number = mouseX - OLD_MOUSE.x;
                var VY:Number = mouseY - OLD_MOUSE.y;
                addChild(new Cropper(BMPD, OLD_MOUSE.x, OLD_MOUSE.y, VX, VY, NEW_MOUSE, stage));
            }
            DRAGGING = false;
        }
        
        private function onmouseMove(e:MouseEvent):void
        {
            NEW_MOUSE.x = mouseX; NEW_MOUSE.y = mouseY;
            if(DRAGGING)
            {
                var VX:Number = mouseX - OLD_MOUSE.x;
                var VY:Number = mouseY - OLD_MOUSE.y;
                mouse.graphics.clear();
                mouse.graphics.lineStyle(0.1, 0xFF0000);
                mouse.graphics.drawEllipse(OLD_MOUSE.x,OLD_MOUSE.y,VX,VY);
            }
        }
    }
}
import flash.display.MovieClip;
import flash.geom.Matrix;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.display.BitmapData;
import flash.ui.Mouse;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.display.Stage;

class Cropper extends MovieClip
{
    private var OLD_MOUSE:Point = new Point();
    private var matrix:Matrix = new Matrix();
    private var ecllipse:MovieClip = new MovieClip();
    private var adjustor:MovieClip = new MovieClip();
    private var ADJ_WIDTH:MovieClip = new MovieClip();
    private var ADJ_HEIGHT:MovieClip = new MovieClip();
    private var ADJ_ROTATION:MovieClip = new MovieClip();
    private var BMPD:BitmapData;
    private var PX:Number = 0;
    private var PY:Number = 0;
    private var W:Number = 0;
    private var H:Number = 0;
    private var startRotation:Boolean = false;
    private var mouse:Point;
    public function Cropper(bmpd:BitmapData, px:Number, py:Number, w:Number, h:Number, m:Point, s:Stage)
    {
        BMPD = bmpd;
        PX = px;
        PY = py;
        W = w;
        H = h;
        mouse = m;
        x = px+w/2; y = py+h/2;        
        matrix.translate(-PX-W/2,-PY-H/2);
        addChild(ecllipse);
        addChild(adjustor);
        adjustor.visible = false;
        adjustor.addChild(ADJ_WIDTH);
        adjustor.addChild(ADJ_HEIGHT);
        adjustor.addChild(ADJ_ROTATION);
        drawButton(ADJ_WIDTH, 5, 0xFF0000);
        drawButton(ADJ_HEIGHT, 5, 0x00FF00);
        drawButton(ADJ_ROTATION, 5, 0x0000FF);
        ADJ_WIDTH.addEventListener(MouseEvent.MOUSE_DOWN, onStartDrag);
        s.addEventListener(MouseEvent.MOUSE_UP, onStopDrag);
        ADJ_HEIGHT.addEventListener(MouseEvent.MOUSE_DOWN, onStartDrag);
        s.addEventListener(MouseEvent.MOUSE_UP, onStopDrag);
        ADJ_ROTATION.addEventListener(MouseEvent.MOUSE_DOWN, onStartDragRot);
        s.addEventListener(MouseEvent.MOUSE_UP, onStopDragRot);
        ADJ_WIDTH.x = w/4;
        ADJ_HEIGHT.y = h/4;
        ADJ_ROTATION.y = -h/4;
        
        ecllipse.addEventListener(MouseEvent.MOUSE_DOWN, onmouseDown);
        ecllipse.addEventListener(MouseEvent.MOUSE_UP, onmouseUp);
        addEventListener(MouseEvent.MOUSE_OVER, onmouseOver);
        addEventListener(MouseEvent.MOUSE_OUT, onmouseOut);
        addEventListener(Event.ENTER_FRAME, update);
    }
    
    public function update(e:Event):void
    {
        if(startRotation)
        {
            var VX:Number = mouse.x - x;
            var VY:Number = mouse.y - y;
            rotation = Math.atan2(VY, VX) * 180 /Math.PI + 90;
        }
        ADJ_ROTATION.y = -ecllipse.height/4;
        ecllipse.scaleX = ADJ_WIDTH.x/(W/4);
        ecllipse.scaleY = ADJ_HEIGHT.y/(H/4);
        ecllipse.graphics.beginBitmapFill(BMPD, matrix);
        ecllipse.graphics.drawEllipse(-W/2,-H/2,W,H);
        ecllipse.graphics.endFill();
    }
    
    private function onmouseDown(e:MouseEvent):void
    {
        startDrag();
    }
    
    private function onmouseUp(e:MouseEvent):void
    {
        stopDrag();
    }
    
    private function onmouseOver(e:MouseEvent):void
    {
        adjustor.visible = true;
    }
    
    private function onmouseOut(e:MouseEvent):void
    {
        adjustor.visible = false;
    }
    
    private function drawButton(m:MovieClip, rad:Number, c:uint):void
    {
        
        m.graphics.beginFill(c);
        m.graphics.drawCircle(0,0,rad);
        m.graphics.endFill();
    }
    
    private function onStartDrag(e:Event):void
    {
        var rect:Rectangle;
        rect = (e.target.y != 0)? new Rectangle(0, 0, 0, 9999): new Rectangle(0, 0, 9999, 0);
        e.target.startDrag(true, rect);
    }
    
    private function onStopDrag(e:Event):void
    {
        ADJ_WIDTH.stopDrag();
        ADJ_HEIGHT.stopDrag();
    }
    
    private function onStartDragRot(e:Event):void
    {
        startRotation = true;
        OLD_MOUSE.x = mouseX; OLD_MOUSE.y = mouseY;
    }
    
    private function onStopDragRot(e:Event):void
    {
        startRotation = false;
    }
}