/**
 * Copyright faunus ( http://wonderfl.net/user/faunus )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wdmb
 */

// forked from mex_ny's forked from: 【AS100本ノック】8回目：水
// forked from mex's 【AS100本ノック】8回目：水
/* 
 * AS100本ノック
 * 8回目のお題は「水」
 * あなたなりの「水」を表現してください。
 * 
 * 適当でサーセン。
 */
package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.BitmapDataChannel;
	import flash.display.Loader;
	import flash.display.Shape;
	import flash.events.IOErrorEvent;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Matrix;
	import flash.filters.ConvolutionFilter;
	import flash.filters.DisplacementMapFilter;


	import flash.display.Stage;

	dynamic public class Water extends Sprite
	{
		private const STAGE_WIDTH:uint = 465 , STAGE_HEIGHT:uint = 465 , DIST:uint = 6 , OCTAVES:uint = 6 , 
						POINT:Point = new Point( 0 , 0 ),
						IMAGE_URL:String = "http://farm3.static.flickr.com/2290/2485682500_bc54bb0a33.jpg";

		private var _width:uint , _height:uint , _cloudBitmap:Bitmap , _bitmap:Bitmap , _offset:Array , _offxy:Array ,
					_clt:ColorTransform , _convolution:ConvolutionFilter , _loader:Loader , _waterBitmap:Bitmap , _sp:Sprite;
		
		public function Water()
		{
			init();
		}

		private function init():void
		{
			loadImage();
		}
		
		private function loadImage():void
		{
			var loaderContext:LoaderContext = new LoaderContext(true);
			_loader = new Loader();
			_loader.contentLoaderInfo.addEventListener( Event.COMPLETE , loadImageCompleteHandler );
			_loader.contentLoaderInfo.addEventListener( IOErrorEvent.IO_ERROR , loadImageIOErrorHandler );
			
			_loader.load( new URLRequest( IMAGE_URL ) , loaderContext );

		}
		
		private function loadImageIOErrorHandler( $evt:IOErrorEvent ):void
		{
			trace("IOError DEATH!");
		}
		
		private function loadImageCompleteHandler( $event:Event ):void
		{
			makeCloudImage();
			addWaterImage();
			animationStart();
		}
		
		private function addWaterImage():void
		{
			var bitmapData:BitmapData , s:Shape , g:Graphics;
			
			_sp = new Sprite();
			addChild( _sp );

			bitmapData = new BitmapData( STAGE_WIDTH , STAGE_HEIGHT , true , 0x00000000 );
			bitmapData.draw( _loader );

			_waterBitmap = new Bitmap();
			_sp.addChild( _waterBitmap );
			_waterBitmap.bitmapData = bitmapData;
			
			s = new Shape();
			g = s.graphics;
			g.beginFill( 0x000000 , 1 );
			g.drawRect( 0 , 0 , 110 , 20 );
			g.endFill();
			s.x = 190;
			s.y = 110;
			_sp.addChild( s );
			
			s = new Shape();
			g = s.graphics;
			g.beginFill( 0x000000 , 1 );
			g.drawRect( 0 , 0 , 210 , 78 );
			g.endFill();
			s.x = 10;
			s.y = 370;
			_sp.addChild( s );
		}

		private function makeCloudImage():void
		{
			var dist:uint, bd:BitmapData , i:uint , p1:Point , p2:Point;
			bd = new BitmapData( STAGE_WIDTH , STAGE_HEIGHT, true);
			
			_offset = new Array();
			_offxy = new Array();

			for (i = 0; i < OCTAVES; i++) {
				_offset[i] = new Point( Math.random() * STAGE_WIDTH , Math.random() * STAGE_HEIGHT );
				_offxy[i] = new Point( 3, Math.random() * 4 - 2 );
			}
			
			var matrix:Array = [0, 0, 0, 
								0, 0, 1, 
								0, 0, 0]; 
			
			_cloudBitmap = new Bitmap( bd );
			_clt = new ColorTransform(0, 0, 1, 1, 0, 0, 1 ,0);
			_convolution = new ConvolutionFilter(); 
			_convolution.matrixX = 3; 
			_convolution.matrixY = 3; 
			_convolution.matrix = matrix; 
			_convolution.divisor = 1; 
			addChild( _cloudBitmap );
		}

		private function animationStart():void
		{
			addEventListener( Event.ENTER_FRAME , loop );
		}

		private function loop( $event:Event ):void
		{
			var i:uint , filter:DisplacementMapFilter;

			for (i = 0; i < OCTAVES; i++) {
				_offset[i].x += _offxy[i].x;
				_offset[i].y += _offxy[i].y;
			}

			_cloudBitmap.bitmapData.perlinNoise( 36 , 36 , OCTAVES, 11 , false , true , 4 , false , _offset );
			_cloudBitmap.bitmapData.colorTransform( _cloudBitmap.getRect( this ) , _clt );
			_cloudBitmap.filters = [_convolution];
			

			filter = new DisplacementMapFilter( _cloudBitmap.bitmapData, POINT, BitmapDataChannel.BLUE, BitmapDataChannel.BLUE, 10, 5 , "color", 0, 0 );

			_sp.filters = [filter];
			
		}
		
		
	}
}