/**
 * Copyright Glidias ( http://wonderfl.net/user/Glidias )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wcyJ
 */

package  {
    
    import alternativ7.engine3d.alternativa3d;
    import alternativ7.engine3d.controllers.SimpleObjectController;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Object3DContainer;
    import alternativ7.engine3d.core.Vertex;
    import alternativ7.engine3d.core.View;
    import alternativ7.engine3d.materials.FillMaterial;
    import alternativ7.engine3d.objects.Mesh;
    import flash.display.GradientType;
    import flash.display.GraphicsEndFill;
    import flash.display.GraphicsGradientFill;
    import flash.display.GraphicsPath;
    import flash.display.GraphicsSolidFill;
    import flash.display.GraphicsStroke;
    import flash.display.InterpolationMethod;
    import flash.display.SpreadMethod;
    import flash.geom.Matrix;
    
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    
    /**
     * Working with vector graphics in 3d.
     */
    public class VectorShape3DExample extends Sprite {
        
        private var rootContainer:Object3DContainer = new Object3DContainer();
        
        private var camera:Camera3D;
        private var controller:SimpleObjectController;
        private var helloUpContainer:Object3DContainer;
        
        public function VectorShape3DExample() {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            // Camera and view
            // Создание камеры и вьюпорта
            camera = new Camera3D();
            camera.view = new View(stage.stageWidth, stage.stageHeight);
            addChild(camera.view);
            addChild(camera.diagram);
            
            // Initial position
            // Установка начального положения камеры
            camera.rotationX = -120*Math.PI/180;
            camera.y = -400;
            camera.z = 200;
            controller = new SimpleObjectController(stage, camera, 500);
            rootContainer.addChild(camera);
            
            // Adding of geometry
            // Создание геометрии
            
            var graphics3D:VectorShape3D = new VectorShape3D();
            
            var path:GraphicsPath = new GraphicsPath();

            
            var width:Number = 100;
            var height:Number = 200;

            
            var type:String = GradientType.RADIAL; 
            var colors:Array = [0x00FF00, 0x000088]; 
            var alphas:Array = [1, 1]; 
            var ratios:Array = [0, 255]; 
            var spreadMethod:String = SpreadMethod.PAD; 
            var interp:String = InterpolationMethod.LINEAR_RGB; 
            var focalPtRatio:Number = 0; 
             
            var matrix:Matrix = new Matrix(); 
            var boxWidth:Number = 512; 
            var boxHeight:Number = 512; 
            var boxRotation:Number = 0;// Math.PI / 2; // 90° 
            var tx:Number = -256; 
            var ty:Number = -256; 
            matrix.createGradientBox(boxWidth, boxHeight, boxRotation, tx, ty); 

    
            var spr:Sprite = new Sprite();
            spr.graphics.beginGradientFill("radial", [0x000000, 0x000000], [1, 0], [0, 255], matrix, "pad", "rgb", 0);
            spr.graphics.drawCircle(0, 0, 150);
            spr.x = 200;
            spr.y = 200;
            graphics3D.graphicsData.push( 
                new GraphicsStroke(5, false, "normal", "none", "round", 3,
                new GraphicsGradientFill("radial", [0x000000, 0x000000,0x000000], [0, .3, 0], [0, 120, 255], matrix, "pad", "rgb", 0)
            ));
            GraphicsPathUtils.drawEllipse(path, 0, 0, 256,256, 16);
            graphics3D.addGraphicsPath(path);
            graphics3D.clipping = 1;
            graphics3D.calculateBounds();

            rootContainer.addChild ( new Text3D("Hello World rl \nWelcome rw!", new HelveticaRoman() ) );
            var helloUp:Text3D =  new Text3D("Hello World rl\nWelcome to the Upscape rw!", new HelveticaRoman() );
            helloUp.rotationX = 90 * Math.PI / 180;
            helloUp.y = 600;
            helloUp.z = (helloUp.boundMaxZ - helloUp.boundMinZ) + 150 ;
            helloUpContainer = new Object3DContainer();
            helloUpContainer.addChild(helloUp);
            rootContainer.addChild (helloUpContainer);
        
            rootContainer.addChild(graphics3D);
            
            // Listeners
            // Подписка на события
            stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(Event.RESIZE, onResize);
        }
        
        private function onEnterFrame(e:Event):void {
            controller.update();
            helloUpContainer.rotationZ += .005;
            camera.render();
        }
        
        private function onResize(e:Event = null):void {
            // Width and height of view
            // Установка ширины и высоты вьюпорта
            camera.view.width = stage.stageWidth;
            camera.view.height = stage.stageHeight;
        }
        
    }
}

//package 
//{
    import alternativ7.engine3d.alternativa3d;
    import alternativ7.engine3d.core.Camera3D;
    import alternativ7.engine3d.core.Canvas;
    import alternativ7.engine3d.core.Clipping;
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Vertex;
    import alternativ7.engine3d.core.Wrapper;
    import alternativ7.engine3d.objects.Mesh;
    import flash.display.GraphicsEndFill;
    import flash.display.GraphicsPath;
    import flash.display.GraphicsPathCommand;
    import flash.display.GraphicsPathWinding;
    import flash.display.GraphicsSolidFill;
    import flash.display.GraphicsStroke;
    import flash.display.GraphicsTrianglePath;
    import flash.display.IGraphicsData;
    import flash.display.IGraphicsPath;
    use namespace alternativa3d;

    
    /**
     * Rough class to handle vector shape drawing.
     * 
     * What's missing? :
     * - VG implementation for dynamic bsp cases
     * - CurveTo implementation
     * - Add Triangle path implementation
     * - Public Methods to provide proxy mesh geometry for collision detection.
     *   (currently, you can just add faces manually), as they won't be drawn.
     * 
     * @author Glenn Ko
     */
    //public 
    class VectorShape3D extends Mesh
    {
        public var graphicsData:Vector.<IGraphicsData> = new Vector.<IGraphicsData>();
        //protected var vertexList:Vertex;
        protected var _lastVertex:Vertex;
        private var _lastPath:GraphicsPath;
        
        public function VectorShape3D() 
        {
            super();
        }
    
        // -- Boiler plate
        public function endFill():void {
            graphicsData.push( new GraphicsEndFill() );
            _lastPath = null;
        }
        public function beginFill(color:uint=0, alpha:Number=1):void  {
            graphicsData.push( new GraphicsSolidFill(color, alpha) );
        }
        
        public function lineStyle(thickness:Number = 0, color:uint = 0, alpha:Number = 1, pixelHinting:Boolean = false, scaleMode:String = "normal", caps:String = "none", joints:String = "round", miterLimit:Number = 3):void {
            graphicsData.push( new GraphicsStroke(thickness, pixelHinting, scaleMode, caps, joints, miterLimit, new GraphicsSolidFill(color, alpha) ) );
        }
    
        public function lineTo(x:Number, y:Number, z:Number=0):void {
            if (_lastPath == null) {
                _lastPath = new GraphicsPath();
                graphicsData.push(_lastPath);
            }
            var v:Vertex = new Vertex();
            v.x = x;
            v.y = y;
            v.z = z;
            
            _lastPath.lineTo(x, y);
            v.index = _lastPath.data.length - 2;
            v.id = _lastPath.data;
            
            if (_lastVertex != null) 
                _lastVertex.next = v;
            else vertexList = v;
            
            _lastVertex = v;
        }
        
        public function moveTo(x:Number, y:Number, z:Number=0):void {
            if (_lastPath == null) {
                _lastPath = new GraphicsPath();
                graphicsData.push(_lastPath);
            }
            var v:Vertex = new Vertex();
            v.x = x;
            v.y = y;
            v.z = z;
            
            _lastPath.moveTo(x, y);
            v.index = _lastPath.data.length - 2;
            v.id = _lastPath.data;
            
            if (_lastVertex != null) 
                _lastVertex.next = v;
            else vertexList = v;
            
            _lastVertex = v;
        }
        
                
        /**
         * Registers a graphic path instance
         * @param    path    A valid graphics path where each command represents 1 vertex.
         *                     So, each command cannot be a 'zero' (do nothing) command.
         */
        public function addGraphicsPath(path:GraphicsPath):void {
            _lastPath = path;
            var i:int = 0;
            var v:Vertex;
            var cmds:Vector.<int>  = path.commands;
            var len:int = cmds.length;
            var data:Vector.<Number> = path.data;
        
            var dataCount:int = 0;
            for (i = 0; i < len; i++ ) {
                if (cmds[i] != GraphicsPathCommand.CURVE_TO) {
                    v = new Vertex();
                    v.id = path.data;
                    v.index = dataCount;
                    v.x = data[dataCount++];
                    v.y = data[dataCount++];
                    
                    if (_lastVertex != null) 
                        _lastVertex.next = v;
                    else vertexList = v;
                }
                else {    // 2 control vertices for curve
                    v = new Vertex();
                    v.id = path.data;
                    v.index = dataCount;
                    v.x = data[dataCount++];
                    v.y = data[dataCount++];
                    if (_lastVertex != null) 
                        _lastVertex.next = v;
                    else vertexList = v;
                    
                    v.next = new Vertex();
                    v = v.next;
                    v.id = path.data;
                    v.index = dataCount;
                    v.x = data[dataCount++];
                    v.y = data[dataCount++];
                }
                _lastVertex = v;
            }
            
            graphicsData.push(path);
        }
        
        
        
        /*
        public function addGraphicsTrianglePath(path:GraphicsTrianglePath):void {
        
            graphicsData.push(path);
        }
        */
        
        override alternativa3d function draw(camera:Camera3D, parentCanvas:Canvas):void {
        
            ///*
            if (culling > 0 && clipping > 0) {
                if (culling & 1) {  // cull against near clip plane at least
                    return;
                }
                // todo: vertex path clipping for option 2. Clipping.FACE_CLIPPING
            }
            //*/
            

            // Simple implementation of drawing items without clipping
            var viewSizeX:Number = camera.viewSizeX;
            var viewSizeY:Number = camera.viewSizeY;
            for (var v:Vertex = vertexList; v != null; v = v.next) {
                var pathData:Vector.<Number> = v.id as Vector.<Number>;
                var x:Number = v.x;
                var y:Number = v.y;
                var z:Number = v.z;
                v.cameraX = ma*x + mb*y + mc*z + md;
                v.cameraY = me*x + mf*y + mg*z + mh;
                v.cameraZ = mi*x + mj*y + mk*z + ml;
                x = v.cameraX*viewSizeX/v.cameraZ;
                y =  v.cameraY*viewSizeY/v.cameraZ;

                pathData[v.index] = x;
                pathData[v.index + 1] = y;
            }
            
            parentCanvas.getChildCanvas(true, false, this, alpha, blendMode, colorTransform, filters).gfx.drawGraphicsData(graphicsData);
        }


    }

//}

    
    import alternativ7.engine3d.core.Vertex;
    import flash.display.GraphicsPath;
    import alternativ7.engine3d.alternativa3d;
    use namespace alternativa3d;
    
    /**
     * @author Mark Barcinski
     * @author Glenn Ko
     */
    //public
    class VectorLetter3D extends VectorShape3D implements Letter3D {
        private var _width:Number;
        private var _height:Number;
        private var _char : String;
        private var _font:Font3D;

        
        public function VectorLetter3D() {
            
        }
        
        public function setup(char:String , font :Font3D):void {
            this._char = char;
            this._font = font;

            getLetterFromFont();

            //center vertices & flip vertically
            for (var v:Vertex = vertexList; v != null; v = v.next) {
                v.x -= _width/2;
                v.y -= _height/2;
            
                // flip 
                v.y *= -1;
            }
            calculateBounds();
        }
        
        protected function getLetterFromFont():void
        {
            _width = _font.widths[_char];
            _height = _font.height;
            createVertices(_font.motifs[_char]);
        }

        protected function createVertices(motif:Array):void
        {
            var letterPath:GraphicsPath = new GraphicsPath();
            
            var len:int = motif.length;
        
            if (len == 0) return;
            
            for (var i:int = 0; i < len; i++) {
                switch (motif[i][0]) 
                {
                    case "M":
                        letterPath.moveTo(motif[i][1][0], motif[i][1][1]);  
                        break;
                    case "L":
                        letterPath.lineTo(motif[i][1][0], motif[i][1][1]); 
                        break;
                    case "C":
                        letterPath.curveTo(motif[i][1][0], motif[i][1][1], motif[i][1][2], motif[i][1][3]); 
                        break;
                    
                }
            }
            addGraphicsPath(letterPath);
        }
        
        /* INTERFACE iss.engine3d.typography.Letter3D */
        
        public function get xP():Number 
        {
            return x;
        }
        
        public function set xP(value:Number):void 
        {
            x = value;
        }
        
        public function get yP():Number 
        {
            return y;
        }
        
        public function set yP(value:Number):void 
        {
            y = value;
        }
        
        public function get zP():Number 
        {
            return z;
        }
        
        public function set zP(value:Number):void 
        {
            z = value;
        }
        
        public function get width() : Number {
            return _width;
        }
        
        public function set width(value : Number) : void {
            _width = value;
        }
        
        public function get height() : Number {
            return _height;
        }
        
        public function set height(height : Number) : void {
            _height = height;
        }
        
        public function get char() : String {
            return _char;
        }
        
        public function set char(value : String) : void {
            _char = value;
        }
        
        public function get font() : Font3D {
            return _font;
        }
        
        public function set font(value : Font3D) : void {
            _font = value;
        }
    }
//}


//package 
//{
    import flash.display.GraphicsPath;
    /**
     * From PV3D
     * @author Glenn Ko
     */
    //public
    class GraphicsPathUtils 
    {
        
        public static function drawRect(path:GraphicsPath,  x : Number, y : Number, width : Number, height : Number) : void
                {
                        path.moveTo(x, y);
                        path.lineTo(x + width, y);
                        path.lineTo(x + width, y + height);
                        path.lineTo(x, y + height);
                        path.lineTo(x, y);
                }
                

                
                public static function drawRoundRect(path:GraphicsPath, x : Number, y : Number, width : Number, height : Number, ellipseWidth : Number, ellipseHeight : Number) : void
                {
                        path.moveTo(x, y + ellipseHeight);
                        path.curveTo(x, y , x + ellipseWidth, y);
                        
                        path.lineTo(x + width - ellipseWidth, y);
                        path.curveTo(x + width , y , x + width , y + ellipseHeight);
                        
                        path.lineTo(x + width, y + height - ellipseHeight);
                        path.curveTo(x + width, y + height , x + width - ellipseHeight, y + height);
                        
                        path.lineTo(x + ellipseWidth, y + height);
                        path.curveTo(x , y + height , x , y + height - ellipseHeight);
                        
                        path.lineTo(x, y + ellipseHeight);
                }
        
                    //Based on Keith Peters MultiCurves
                public static function drawEllipse(path:GraphicsPath, x: Number , y:Number , width  : Number , height : Number , numPoints : int = 8, arcSize:Number=0, arcOffset:Number=0):void
                {
                        arcSize = arcSize == 0 ? Math.PI * 2 : arcSize;
                        var points:Array = new Array();
                        var step : Number = arcSize / numPoints; 

                        for (var i:int = 0; i < numPoints; i++)
                        {
                                points[i] = new Object();
                                points[i].x = x + Math.sin(i * step + arcOffset) * width;
                                points[i].y = y + Math.cos(i * step + arcOffset) * height;
                        }
                        
                        // find the first midpoint and move to it
                        var xc1:Number = (points[0].x + points[numPoints - 1].x) * .5;
                        var yc1:Number = (points[0].y + points[numPoints - 1].y) * .5;
                        path.moveTo(xc1, yc1);

                        // curve through the rest, stopping at midpoints
                        for (i = 0; i < numPoints - 1; i ++)
                        {
                                var xc:Number = (points[i].x + points[i + 1].x) *.5;
                                var yc:Number = (points[i].y + points[i + 1].y) *.5;
                                path.curveTo(points[i].x, points[i].y, xc, yc);
                        }
                        
                        // curve through the last point, back to the first midpoint
                        path.curveTo(points[i].x, points[i].y, xc1, yc1);
                }
        
    }

//}

//package

    /**
     * @author Mark Barcinski
     */
    //public 
    class Font3D {
        public function get motifs():Object
        {
            //Override me
            return new Object();
        }
        
        public function get widths():Object
        {
            //Override me
            return new Object();
        }
        
        public function get height():Number
        { 
            //Override me
            return -1;
        }
        
    }
//}

//package 

    /**
     * @author Mark Barcinski
     * @author Glenn Ko
     */

    //public 
    interface Letter3D  {
        function get width():Number;
        function set width(value:Number):void;
        
        function get height():Number;
        function set height(value:Number):void;
        
        function get char() : String;
        function set char(value:String) : void;
        
        function get font():Font3D;
        function set font(value:Font3D):void;
        
        
        //DisplayObject3D methods
        ///*
        function get xP():Number;
        function set xP(value:Number):void;
        
        function get yP():Number;
        function set yP(value:Number):void;
        
        function get zP():Number;
        function set zP(value:Number):void;
        //*/
        
        
    }
//}

//package
    import alternativ7.engine3d.core.Object3D;
    import alternativ7.engine3d.core.Object3DContainer;
    

    /**
     * @author Mark Barcinski
     * @author Glenn Ko 
     */
    //public
    class Text3D extends Object3DContainer {
        public var letters : Array;
        
        protected var _text : String;
        public var font : Font3D;
        
        public var lines : Array;
        
        
        private var _letterSpacing : Number = 0;
        private var _lineSpacing : Number = 0;
        private var _align : String = "center";
        
        private var _lineHeight : Number = 0;
        
            
        public function Text3D(text:String , font : Font3D
                                 ) {
            //super(name, geometry);
            //TODO temp stuff , revert textfield back to displayobject after debug
            
            super();
            
            this.font = font;
            _text = text.replace(/\r/gi, "\n");
            
            //letters = [];
            
            _lineHeight = font.height + _lineSpacing;
            
            
            createLetters();
            alignLetters();
            calculateBounds();
            
        }
        
        protected function createLetters( ) : void 
        {
            lines = [];
            letters = [];
            var textLine:String;
            var textLines:Array = _text.split("\n");
            var letter : VectorLetter3D;
            var lineLetters : Array;
            
            var iLen:int = textLines.length;
            for (var i:int = 0 ; i <iLen ; i++)
            {
                lineLetters = new Array();
                lines[i] = lineLetters;
                textLine = textLines[i];
                
                var jLen:int = textLine.length;
                for(var j:int = 0 ; j < jLen ; j++)
                {
                    var char:String = textLine.charAt(j);
                    letter = new VectorLetter3D();
                    letter.beginFill(0, 1);  // TODO have prepended data setting for text
                    letter.setup(char, font);
                    addChild(letter);
                    
                    
                    lineLetters.push(letter);
                    if(char != " ") addChild(letter);    
                    letters.push(letter);
                }
            }
        }
        
        private function alignLetters() : void 
        {
            var letter : Letter3D;
            var prevLetter : Letter3D;
            var lineLetters : Array;
            var currY:Number = 0;
            
            
            // used for align
            var first : Letter3D;
            var last  : Letter3D;
            var tx : Number;
            
            for (var i:int = 0 ; i < lines.length ; i++)
            {
                lineLetters = lines[i];
                currY = i * - _lineHeight;
                
                first = lineLetters[0];
                last = lineLetters[lineLetters.length-1];
                
                for(var j:int = 0 ; j < lineLetters.length ; j++)
                {
                    letter = lineLetters[j];
                    
                    letter.xP = j > 0 ? prevLetter.xP + (prevLetter.width/2 + letter.width/2)  + _letterSpacing : letter.width / 2;
                    letter.yP = currY;
                    
                    prevLetter = letter;
                }
                
                if(align == "center" && last){
                    tx = ( last.xP + last.width/2) / 2;
                    for(j = 0 ; j < lineLetters.length ; j++)
                    {
                        (lineLetters[j]  as Object3D).x -= tx;        
                    }
                }
                
                if(align == "right" && last){
                    tx = last.xP + last.width/2;
                    for(j = 0 ; j < lineLetters.length ; j++)
                    {
                        (lineLetters[j] as Object3D).x -= tx;        
                    }
                }                
            }
        }
        
        private function removeLetters():void {
            for each( var l:Object3D in letters){
                removeChild(l);    
            }
            
            letters.length = 0;
            lines.length = 0;
        }
        
        
        ///////////////////////////////////////////////
        // getters and setters
        ///////////////////////////////////////////////
                
        public function get letterSpacing() : Number {
            return _letterSpacing;
        }
        
        public function set letterSpacing(spacing : Number) : void {
            _letterSpacing = spacing;
            
            alignLetters();
        }
        
        public function get lineSpacing() : Number {
            return _lineSpacing;
        }
        
        public function set lineSpacing(lineSpacing : Number) : void {
            _lineSpacing = lineSpacing;
            _lineHeight = font.height + lineSpacing; 
            
            alignLetters();
        }
        
        public function get align() : String {
            return _align;
        }
        
        public function set align(align : String) : void {
            _align = align;
            
            alignLetters();
        }
        
        public function get text() : String {
            return _text;
        }
        
        public function set text(text : String) : void {
            _text = text.replace(/\r/gi, "\n");
            
            removeLetters();
            
            createLetters();
            alignLetters();
        }
    }
//}


/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

  FIVe3D v2.0  -  2008-04-14
  Flash Interactive Vector-based 3D
  Mathieu Badimon  |  five3d.mathieu-badimon.com  |  www.mathieu-badimon.com  |  contact@mathieu-badimon.com

/*//////////////////////////////////////////////////////////////////////////////////////////////////////////

//package

    //public 
    class HelveticaRoman extends Font3D{

        static public var __motifs:Object = {};
        static public var __widths:Object = {};
        static public var __height:Number = 117;
        static public var __initialized:Boolean = false;

        static public function initialize():void {
            initializeMotifsUppercase();
            initializeMotifsLowercase();
            initializeMotifsNumbers();
            initializeMotifsPunctuation();
            initializeWidthsUppercase();
            initializeWidthsLowercase();
            initializeWidthsNumbers();
            initializeWidthsPunctuation();
            __initialized = true;
        }
        
        ////////////////////////////////////////////
        override public function get motifs():Object
        {
            if(!__initialized)initialize();
            return __motifs;
        }

        override public function get widths():Object
        {
            if(!__initialized)initialize();
            return __widths;
        }
        
        override public function get height():Number
        { 
            if(!__initialized)initialize();
            return __height;
        }
        ////////////////////////////////////////////

        static private function initializeMotifsUppercase():void {
            __motifs["A"] = [['M',[32.4,32.4]],['L',[44.35,65.7]],['L',[20.1,65.7]],['L',[32.25,32.4]],['L',[32.4,32.4]],['M',[27.2,23.8]],['L',[-0.7,95.2]],['L',[9.15,95.2]],['L',[17.15,73.7]],['L',[47.3,73.7]],['L',[55.15,95.2]],['L',[65.65,95.2]],['L',[37.75,23.8]],['L',[27.2,23.8]]];
            __motifs["B"] = [['M',[51.5,43.1]],['C',[51.55,48.7,47.95,51.6]],['C',[44.35,54.5,36.35,54.5]],['L',[17.35,54.5]],['L',[17.35,31.8]],['L',[36.35,31.8]],['L',[43.9,32.55]],['C',[47.3,33.35,49.4,35.8]],['C',[51.45,38.2,51.5,43.1]],['M',[40.5,23.9]],['L',[33.75,23.8]],['L',[7.8,23.8]],['L',[7.8,95.2]],['L',[42.3,95.2]],['C',[49.4,95.1,54.25,92.2]],['C',[59.1,89.35,61.5,84.65]],['C',[64,80,64,74.7]],['C',[63.95,68,60.5,63.45]],['C',[57.05,58.9,50.4,57.5]],['L',[50.4,57.25]],['C',[55.4,55.2,58.2,51.1]],['C',[61,47,61.05,41.3]],['C',[60.95,36.05,58.6,32.3]],['C',[56.25,28.55,52.65,26.4]],['C',[50.45,25.15,47.2,24.6]],['L',[40.5,23.9]],['M',[17.35,62.5]],['L',[39,62.5]],['C',[43.05,62.45,46.6,63.5]],['C',[50.1,64.55,52.25,67.15]],['C',[54.45,69.75,54.5,74.4]],['C',[54.45,80.3,50.9,83.75]],['C',[47.3,87.15,41.1,87.2]],['L',[17.35,87.2]],['L',[17.35,62.5]]];
            __motifs["C"] = [['M',[67.55,45.3]],['C',[66.35,37.7,62.2,32.55]],['C',[58.1,27.4,51.85,24.75]],['C',[45.65,22.1,38.15,22.1]],['C',[27.1,22.25,19.6,27.3]],['C',[12.05,32.25,8.2,40.75]],['C',[4.3,49.25,4.3,59.7]],['C',[4.3,70.2,7.9,78.6]],['C',[11.55,86.95,18.9,91.9]],['C',[26.2,96.8,37.3,96.9]],['C',[50.9,96.75,58.85,89.3]],['C',[66.8,81.75,68.2,68.3]],['L',[58.7,68.3]],['C',[58.25,74.25,55.75,78.9]],['C',[53.2,83.55,48.85,86.15]],['C',[44.4,88.85,38.15,88.9]],['C',[29.6,88.8,24.2,84.8]],['C',[18.85,80.75,16.3,74]],['C',[13.75,67.25,13.8,59]],['C',[13.75,51.45,16.3,44.9]],['C',[18.85,38.35,24.15,34.3]],['C',[29.55,30.2,38,30.1]],['C',[43,30.1,47.15,31.8]],['C',[51.3,33.5,54.15,36.9]],['C',[57,40.25,58,45.3]],['L',[67.55,45.3]]];
            __motifs["D"] = [['M',[54.8,44.45]],['C',[57.15,50.55,57.1,59.1]],['C',[57,68.9,54.25,74.6]],['C',[51.5,80.3,47.55,83]],['C',[43.55,85.75,39.6,86.5]],['L',[33.1,87.2]],['L',[17.35,87.2]],['L',[17.35,31.8]],['L',[33.3,31.8]],['C',[42,31.85,47.25,35.1]],['C',[52.5,38.35,54.8,44.45]],['M',[7.8,23.8]],['L',[7.8,95.2]],['L',[32.3,95.2]],['C',[50.05,95.1,58.35,85.5]],['C',[66.7,75.8,66.6,57.8]],['C',[66.5,40.6,57.7,32.2]],['C',[48.9,23.75,32.3,23.8]],['L',[7.8,23.8]]];
            __motifs["E"] = [['M',[57.15,23.8]],['L',[7.8,23.8]],['L',[7.8,95.2]],['L',[57.4,95.2]],['L',[57.4,87.2]],['L',[17.35,87.2]],['L',[17.35,62.5]],['L',[54.45,62.5]],['L',[54.45,54.5]],['L',[17.35,54.5]],['L',[17.35,31.8]],['L',[57.15,31.8]],['L',[57.15,23.8]]];
            __motifs["F"] = [['M',[54.75,23.8]],['L',[7.8,23.8]],['L',[7.8,95.2]],['L',[17.35,95.2]],['L',[17.35,62.5]],['L',[50.15,62.5]],['L',[50.15,54.5]],['L',[17.35,54.5]],['L',[17.35,31.8]],['L',[54.75,31.8]],['L',[54.75,23.8]]];
            __motifs["G"] = [['M',[52.6,24.55]],['C',[46.15,22.1,38.3,22.1]],['C',[29.85,22.15,23.45,25.25]],['C',[17.1,28.3,12.85,33.75]],['C',[8.6,39.1,6.45,46.1]],['C',[4.3,53.05,4.3,60.9]],['C',[4.3,67.95,6.65,74.4]],['C',[8.95,80.8,13.35,85.85]],['C',[17.7,90.95,24,93.9]],['C',[30.3,96.85,38.3,96.9]],['C',[42.55,96.9,46.75,95.85]],['C',[50.95,94.7,54.7,92.35]],['C',[58.4,90,61.2,86.3]],['L',[63.65,95.2]],['L',[69.7,95.2]],['L',[69.7,57.6]],['L',[38.4,57.6]],['L',[38.4,65.6]],['L',[61.2,65.6]],['C',[61.45,72.15,58.8,77.45]],['C',[56.1,82.65,50.9,85.8]],['C',[45.65,88.85,38.3,88.9]],['C',[30.3,88.8,24.9,84.85]],['C',[19.45,80.85,16.65,74.4]],['C',[13.8,67.95,13.8,60.4]],['C',[13.8,54.6,15.2,49.2]],['C',[16.6,43.85,19.6,39.55]],['C',[22.5,35.25,27.2,32.7]],['C',[31.85,30.15,38.3,30.1]],['C',[43.65,30.1,48.1,31.75]],['C',[52.5,33.5,55.5,36.95]],['C',[58.5,40.4,59.45,45.8]],['L',[69,45.8]],['C',[67.6,37.5,63.3,32.25]],['C',[59.05,27,52.6,24.55]]];
            __motifs["H"] = [['M',[54.9,23.8]],['L',[54.9,54.5]],['L',[17.35,54.5]],['L',[17.35,23.8]],['L',[7.8,23.8]],['L',[7.8,95.2]],['L',[17.35,95.2]],['L',[17.35,62.5]],['L',[54.9,62.5]],['L',[54.9,95.2]],['L',[64.4,95.2]],['L',[64.4,23.8]],['L',[54.9,23.8]]];
            __motifs["I"] = [['M',[8.2,23.8]],['L',[8.2,95.2]],['L',[17.7,95.2]],['L',[17.7,23.8]],['L',[8.2,23.8]]];
            __motifs["J"] = [['M',[2.2,71.7]],['L',[2.2,76.1]],['C',[2.25,86.2,7.6,91.55]],['C',[13,96.85,23,96.9]],['C',[30.95,96.8,35.55,94.05]],['C',[40.2,91.2,42.2,86.75]],['C',[44.15,82.35,44.1,77.45]],['L',[44.1,23.8]],['L',[34.55,23.8]],['L',[34.55,76]],['C',[34.65,82,32.15,85.45]],['C',[29.6,88.85,23.2,88.9]],['C',[18.6,88.85,16.1,87.05]],['C',[13.55,85.3,12.65,82.05]],['C',[11.65,78.9,11.7,74.7]],['L',[11.7,71.7]],['L',[2.2,71.7]]];
            __motifs["K"] = [['M',[53.5,23.8]],['L',[17.35,59.4]],['L',[17.35,23.8]],['L',[7.8,23.8]],['L',[7.8,95.2]],['L',[17.35,95.2]],['L',[17.35,70.2]],['L',[29.25,59.1]],['L',[55.05,95.2]],['L',[67.05,95.2]],['L',[35.75,52.6]],['L',[65.8,23.8]],['L',[53.5,23.8]]];
            __motifs["L"] = [['M',[7.8,23.8]],['L',[7.8,95.2]],['L',[55.15,95.2]],['L',[55.15,87.2]],['L',[17.35,87.2]],['L',[17.35,23.8]],['L',[7.8,23.8]]];
            __motifs["M"] = [['M',[66.1,23.8]],['L',[43.5,83.8]],['L',[21,23.8]],['L',[8,23.8]],['L',[8,95.2]],['L',[17,95.2]],['L',[17,35.85]],['L',[17.2,35.85]],['L',[39.5,95.2]],['L',[47.6,95.2]],['L',[69.9,35.85]],['L',[70.1,35.85]],['L',[70.1,95.2]],['L',[79.1,95.2]],['L',[79.1,23.8]],['L',[66.1,23.8]]];
            __motifs["N"] = [['M',[55.6,23.8]],['L',[55.6,81.7]],['L',[55.4,81.7]],['L',[17.75,23.8]],['L',[7.7,23.8]],['L',[7.7,95.2]],['L',[16.7,95.2]],['L',[16.7,37.9]],['L',[16.9,37.9]],['L',[54.2,95.2]],['L',[64.6,95.2]],['L',[64.6,23.8]],['L',[55.6,23.8]]];
            __motifs["O"] = [['M',[61.3,48.85]],['C',[62.7,54.05,62.7,59.5]],['C',[62.7,65,61.3,70.15]],['C',[59.85,75.4,56.9,79.6]],['C',[53.9,83.8,49.2,86.3]],['C',[44.55,88.85,38.05,88.9]],['C',[31.5,88.85,26.8,86.3]],['C',[22.1,83.8,19.15,79.6]],['C',[16.15,75.4,14.75,70.15]],['C',[13.35,65,13.35,59.5]],['C',[13.35,54.05,14.75,48.85]],['C',[16.15,43.65,19.15,39.4]],['C',[22.1,35.2,26.8,32.7]],['C',[31.5,30.15,38.05,30.1]],['C',[44.55,30.15,49.2,32.7]],['C',[53.9,35.2,56.9,39.4]],['C',[59.85,43.65,61.3,48.85]],['M',[52.95,25.25]],['C',[46.55,22.15,38.05,22.1]],['C',[29.5,22.15,23.1,25.25]],['C',[16.7,28.25,12.4,33.55]],['C',[8.1,38.8,5.95,45.5]],['C',[3.8,52.2,3.8,59.5]],['C',[3.8,66.85,5.95,73.5]],['C',[8.1,80.2,12.4,85.5]],['C',[16.7,90.75,23.1,93.8]],['C',[29.5,96.85,38.05,96.9]],['C',[46.55,96.85,52.95,93.8]],['C',[59.35,90.75,63.6,85.5]],['C',[67.9,80.2,70.05,73.5]],['C',[72.2,66.85,72.2,59.5]],['C',[72.2,52.2,70.05,45.5]],['C',[67.9,38.8,63.6,33.55]],['C',[59.35,28.25,52.95,25.25]]];
            __motifs["P"] = [['M',[51.5,44.9]],['C',[51.55,51.3,47.75,54.65]],['C',[43.9,58.05,35.95,58]],['L',[17.35,58]],['L',[17.35,31.8]],['L',[35.95,31.8]],['C',[43.9,31.8,47.75,35.2]],['C',[51.55,38.5,51.5,44.9]],['M',[55.4,29.45]],['C',[49.8,23.9,39.1,23.8]],['L',[7.8,23.8]],['L',[7.8,95.2]],['L',[17.35,95.2]],['L',[17.35,66]],['L',[39.1,66]],['C',[49.8,66,55.4,60.45]],['C',[61,54.85,61.05,44.9]],['C',[61,34.95,55.4,29.45]]];
            __motifs["Q"] = [['M',[61.3,48.85]],['C',[62.7,54.05,62.7,59.5]],['C',[62.7,66.05,60.7,72.1]],['C',[58.7,78.15,54.5,82.4]],['L',[45,74.8]],['L',[40,80.6]],['L',[47.9,86.9]],['L',[43.2,88.4]],['L',[38.05,88.9]],['C',[31.5,88.85,26.8,86.3]],['C',[22.1,83.8,19.15,79.6]],['C',[16.15,75.4,14.75,70.15]],['C',[13.35,65,13.35,59.5]],['C',[13.35,54.05,14.75,48.85]],['C',[16.15,43.65,19.15,39.4]],['C',[22.1,35.2,26.8,32.7]],['C',[31.5,30.15,38.05,30.1]],['C',[44.55,30.15,49.2,32.7]],['C',[53.9,35.2,56.9,39.4]],['C',[59.85,43.65,61.3,48.85]],['M',[52.95,25.25]],['C',[46.55,22.15,38.05,22.1]],['C',[29.5,22.15,23.1,25.25]],['C',[16.7,28.25,12.4,33.55]],['C',[8.1,38.8,5.95,45.5]],['C',[3.8,52.2,3.8,59.5]],['C',[3.8,66.85,5.95,73.5]],['C',[8.1,80.2,12.4,85.5]],['C',[16.7,90.75,23.1,93.8]],['C',[29.5,96.85,38.05,96.9]],['C',[43.05,96.9,47.3,95.8]],['C',[51.6,94.7,55.15,92.6]],['L',[66,101.4]],['L',[70.8,95.4]],['L',[61.45,87.9]],['C',[66.8,82.55,69.55,75.2]],['C',[72.2,67.75,72.2,59.5]],['C',[72.2,52.2,70.05,45.5]],['C',[67.9,38.8,63.6,33.55]],['C',[59.35,28.25,52.95,25.25]]];
            __motifs["R"] = [['M',[41.4,23.8]],['L',[7.8,23.8]],['L',[7.8,95.2]],['L',[17.35,95.2]],['L',[17.35,64.7]],['L',[40.55,64.7]],['C',[45.05,64.75,47.45,66.5]],['C',[49.85,68.2,50.95,71.15]],['C',[51.95,74.05,52.4,77.55]],['C',[53.05,81.15,53.1,84.6]],['L',[53.4,90.9]],['C',[53.7,93.7,55,95.2]],['L',[65.6,95.2]],['C',[63.6,92.7,62.85,89.5]],['C',[62.05,86.2,61.8,82.6]],['L',[61.4,75.45]],['C',[61.1,71.95,60.15,68.95]],['C',[59.2,65.9,57,63.75]],['C',[54.8,61.6,50.7,60.8]],['L',[50.7,60.6]],['C',[57.15,58.7,60.15,53.85]],['C',[63.2,49.05,63.15,42.5]],['C',[63.05,33.85,57.3,28.9]],['C',[51.55,23.9,41.4,23.8]],['M',[53.6,44]],['C',[53.55,49.15,51.3,51.9]],['C',[49.05,54.65,45.35,55.7]],['C',[41.65,56.7,37.1,56.65]],['L',[17.35,56.65]],['L',[17.35,31.8]],['L',[40.9,31.8]],['C',[47.55,31.9,50.6,35.3]],['C',[53.65,38.65,53.6,44]]];
            __motifs["S"] = [['M',[58.1,44.7]],['C',[57.7,36.9,54.25,31.85]],['C',[50.8,26.9,44.95,24.5]],['C',[39.2,22.1,31.85,22.1]],['C',[25.2,22.1,19.35,24.3]],['C',[13.5,26.5,9.75,31.15]],['C',[6.05,35.8,5.9,43]],['C',[6,49.5,9.35,53.15]],['C',[12.6,56.85,17.8,58.8]],['C',[23,60.75,28.8,61.9]],['C',[34.6,63.05,39.8,64.5]],['C',[44.95,65.85,48.25,68.5]],['C',[51.5,71.1,51.6,75.9]],['C',[51.5,81,48.85,83.85]],['C',[46.15,86.7,42.05,87.85]],['C',[37.9,88.95,33.5,88.9]],['C',[28.05,88.9,23.3,87.1]],['C',[18.6,85.3,15.65,81.5]],['C',[12.8,77.65,12.7,71.7]],['L',[3.7,71.7]],['C',[3.8,80.4,7.8,85.95]],['C',[11.75,91.55,18.45,94.2]],['C',[25.1,96.9,33.2,96.9]],['C',[38.15,96.9,43.05,95.75]],['C',[47.95,94.5,52.05,92]],['C',[56.1,89.4,58.6,85.35]],['C',[61.1,81.3,61.15,75.6]],['C',[61.05,68.7,57.75,64.65]],['C',[54.5,60.55,49.3,58.4]],['C',[44.15,56.25,38.35,55]],['L',[27.3,52.5]],['C',[22.05,51.25,18.8,48.9]],['C',[15.55,46.6,15.45,42.3]],['C',[15.5,37.7,17.75,35]],['C',[20.05,32.3,23.75,31.2]],['C',[27.35,30.05,31.45,30.1]],['C',[38.85,30.05,43.55,33.6]],['C',[48.2,37.1,49.1,44.7]],['L',[58.1,44.7]]];
            __motifs["T"] = [['M',[57.3,23.8]],['L',[0.2,23.8]],['L',[0.2,31.8]],['L',[23.95,31.8]],['L',[23.95,95.2]],['L',[33.5,95.2]],['L',[33.5,31.8]],['L',[57.3,31.8]],['L',[57.3,23.8]]];
            __motifs["U"] = [['M',[55.25,23.8]],['L',[55.25,69.4]],['C',[55.2,78.9,50.5,83.85]],['C',[45.7,88.85,36.65,88.9]],['C',[27.2,88.85,22.05,83.85]],['C',[16.95,78.9,16.9,69.4]],['L',[16.9,23.8]],['L',[7.35,23.8]],['L',[7.35,69.4]],['C',[7.45,83.6,15.15,90.25]],['C',[22.8,96.95,36.65,96.9]],['C',[50.1,96.85,57.4,89.95]],['C',[64.7,82.95,64.8,69.4]],['L',[64.8,23.8]],['L',[55.25,23.8]]];
            __motifs["V"] = [['M',[51.35,23.8]],['L',[30.8,85.7]],['L',[30.6,85.7]],['L',[10.2,23.8]],['L',[-0.1,23.8]],['L',[25.1,95.2]],['L',[35.9,95.2]],['L',[61.3,23.8]],['L',[51.35,23.8]]];
            __motifs["W"] = [['M',[81.9,23.8]],['L',[67.45,83.2]],['L',[67.2,83.2]],['L',[51.4,23.8]],['L',[41.1,23.8]],['L',[25.1,83.2]],['L',[24.9,83.2]],['L',[10.9,23.8]],['L',[1.2,23.8]],['L',[19.5,95.2]],['L',[29.4,95.2]],['L',[45.9,35.2]],['L',[46.1,35.2]],['L',[62.4,95.2]],['L',[72.3,95.2]],['L',[91.4,23.8]],['L',[81.9,23.8]]];
            __motifs["X"] = [['M',[49.05,23.8]],['L',[30.45,51.7]],['L',[12.7,23.8]],['L',[1.3,23.8]],['L',[24.8,58.55]],['L',[-0.1,95.2]],['L',[10.6,95.2]],['L',[30.35,65.7]],['L',[49.55,95.2]],['L',[61.2,95.2]],['L',[36.1,58.55]],['L',[59.65,23.8]],['L',[49.05,23.8]]];
            __motifs["Y"] = [['M',[53.8,23.8]],['L',[32.9,57.8]],['L',[11.45,23.8]],['L',[0.2,23.8]],['L',[27.8,66]],['L',[27.8,95.2]],['L',[37.3,95.2]],['L',[37.3,66]],['L',[64.6,23.8]],['L',[53.8,23.8]]];
            __motifs["Z"] = [['M',[57.75,23.8]],['L',[5.6,23.8]],['L',[5.6,31.8]],['L',[46.6,31.8]],['L',[2.2,87.2]],['L',[2.2,95.2]],['L',[59,95.2]],['L',[59,87.2]],['L',[13.5,87.2]],['L',[57.75,31.8]],['L',[57.75,23.8]]];
        }

        static private function initializeMotifsLowercase():void {
            __motifs["a"] = [['M',[8.95,49.4]],['C',[5.95,53.2,5.6,59.6]],['L',[14.1,59.6]],['C',[14.5,54,18,51.85]],['C',[21.5,49.7,27,49.8]],['L',[32.35,50.4]],['C',[35,51,36.7,52.85]],['C',[38.45,54.7,38.5,58.4]],['C',[38.45,61.5,36.1,62.8]],['C',[33.7,64.1,29.8,64.65]],['L',[21.1,66]],['C',[16.6,66.8,12.65,68.3]],['C',[8.7,69.8,6.2,73]],['C',[3.7,76.15,3.6,81.9]],['C',[3.65,87.05,5.95,90.25]],['C',[8.25,93.45,12.1,94.95]],['C',[15.9,96.4,20.7,96.4]],['C',[26.1,96.4,30.7,94.45]],['C',[35.35,92.5,38.85,88.4]],['C',[38.9,92.55,40.8,94.5]],['C',[42.7,96.4,46.1,96.4]],['L',[49.55,96.05]],['C',[51.05,95.7,52.15,95]],['L',[52.15,88.4]],['L',[50.75,88.8]],['L',[49.55,88.9]],['C',[47.6,88.9,47.2,87.5]],['C',[46.8,86.1,46.9,83.1]],['L',[46.9,56.5]],['C',[46.8,50.5,43.9,47.45]],['C',[41.05,44.3,36.6,43.25]],['C',[32.25,42.2,27.5,42.25]],['C',[21.7,42.2,16.85,43.95]],['C',[11.95,45.6,8.95,49.4]],['M',[38.4,68.5]],['L',[38.4,77.2]],['C',[38.4,79.6,36.75,82.3]],['C',[35.15,85,31.65,86.9]],['C',[28.15,88.8,22.6,88.9]],['C',[19.95,88.9,17.7,88.15]],['C',[15.45,87.45,14,85.8]],['C',[12.65,84.05,12.6,81.3]],['C',[12.65,78.15,14.05,76.3]],['C',[15.5,74.45,17.8,73.45]],['C',[20.15,72.45,23,72]],['L',[31.6,70.8]],['C',[35.8,70.2,38.4,68.5]]];
            __motifs["b"] = [['M',[6.7,23.8]],['L',[6.7,95.2]],['L',[15.2,95.2]],['L',[15.2,88.3]],['L',[15.4,88.3]],['C',[17.35,91.35,20.2,93.1]],['C',[23.1,94.9,26.25,95.7]],['L',[32.15,96.4]],['C',[40.05,96.3,45.25,92.65]],['C',[50.5,89.05,53.15,82.95]],['C',[55.7,76.9,55.7,69.5]],['C',[55.7,62.1,53.1,55.95]],['C',[50.45,49.8,45.15,46.1]],['C',[39.85,42.35,31.9,42.25]],['C',[26.45,42.25,22,44.2]],['C',[17.6,46.25,15.4,50.45]],['L',[15.2,50.45]],['L',[15.2,23.8]],['L',[6.7,23.8]],['M',[30.7,49.8]],['C',[36.2,49.9,39.75,52.55]],['C',[43.3,55.3,45,59.6]],['C',[46.75,63.95,46.75,68.9]],['C',[46.8,74.05,45.3,78.6]],['C',[43.8,83.1,40.4,85.95]],['C',[36.95,88.8,31.2,88.9]],['C',[25.4,88.85,21.8,86.05]],['C',[18.15,83.35,16.5,78.95]],['C',[14.85,74.5,14.9,69.25]],['C',[14.85,64.35,16.45,59.95]],['C',[18,55.5,21.55,52.65]],['C',[25,49.9,30.7,49.8]]];
            __motifs["c"] = [['M',[14.4,46.05]],['C',[9,49.7,6.3,55.9]],['C',[3.6,62.15,3.6,70]],['C',[3.6,77.75,6.4,83.7]],['C',[9.15,89.65,14.5,93]],['C',[19.85,96.35,27.8,96.4]],['C',[37.55,96.3,43.35,91.1]],['C',[49.1,85.85,50.6,76.3]],['L',[41.9,76.3]],['C',[41.05,82.2,37.45,85.55]],['C',[33.85,88.85,27.7,88.9]],['C',[22.3,88.8,19,86.1]],['C',[15.65,83.45,14.1,79.15]],['C',[12.6,74.85,12.6,70]],['C',[12.55,64.7,14,60.1]],['C',[15.55,55.5,19.05,52.65]],['C',[22.6,49.9,28.7,49.8]],['C',[34,49.85,37.25,52.5]],['C',[40.5,55.15,41.5,60.1]],['L',[50.3,60.1]],['C',[49.65,53.95,46.6,50]],['C',[43.5,46.1,38.7,44.15]],['C',[33.9,42.25,28,42.25]],['C',[19.8,42.35,14.4,46.05]]];
            __motifs["d"] = [['M',[44.1,23.8]],['L',[44.1,50.4]],['L',[43.9,50.4]],['C',[41.95,47.35,39.05,45.6]],['C',[36.2,43.8,33.05,43]],['L',[27.2,42.25]],['C',[19.3,42.35,14.05,46.05]],['C',[8.85,49.65,6.2,55.75]],['C',[3.6,61.8,3.6,69.15]],['C',[3.6,76.6,6.25,82.75]],['C',[8.9,88.9,14.15,92.6]],['C',[19.45,96.3,27.4,96.4]],['C',[32.8,96.4,37.25,94.45]],['C',[41.7,92.45,43.9,88.2]],['L',[44.1,88.2]],['L',[44.1,95.2]],['L',[52.6,95.2]],['L',[52.6,23.8]],['L',[44.1,23.8]],['M',[37.5,52.6]],['C',[41.1,55.35,42.75,59.75]],['C',[44.45,64.2,44.4,69.4]],['C',[44.45,74.35,42.8,78.75]],['C',[41.25,83.2,37.75,86]],['C',[34.3,88.8,28.6,88.9]],['C',[23.1,88.8,19.6,86.1]],['C',[16,83.4,14.3,79.1]],['C',[12.6,74.75,12.6,69.8]],['C',[12.55,64.65,14,60.1]],['C',[15.55,55.6,18.9,52.7]],['C',[22.3,49.9,28.1,49.8]],['C',[33.95,49.85,37.5,52.6]]];
            __motifs["e"] = [['M',[27.9,42.25]],['C',[20.8,42.35,15.35,45.8]],['C',[9.85,49.25,6.8,55.3]],['C',[3.65,61.35,3.6,69.2]],['C',[3.75,73.35,4.55,77]],['C',[5.3,80.35,6.6,83.3]],['C',[9.35,89.4,14.75,92.85]],['C',[20.15,96.35,28.35,96.4]],['C',[37.15,96.35,42.9,91.9]],['C',[48.7,87.4,50.5,78.8]],['L',[42.1,78.8]],['C',[40.9,83.8,37.45,86.35]],['C',[34,88.9,28.7,88.9]],['C',[23.05,88.85,19.45,86.5]],['C',[15.8,84.15,14.1,80.3]],['C',[13.4,78.7,13.05,77]],['C',[12.5,74.55,12.6,71.9]],['L',[51.25,71.9]],['C',[51.45,67.1,50.4,62]],['C',[49.3,56.85,46.65,52.4]],['C',[43.95,47.95,39.3,45.15]],['C',[34.7,42.35,27.9,42.25]],['M',[34.9,51.8]],['C',[38.2,53.7,40.15,57]],['C',[42.05,60.3,42.3,64.4]],['L',[12.6,64.4]],['C',[12.9,60.4,14.7,57.1]],['C',[16.55,53.8,19.75,51.8]],['C',[22.95,49.85,27.4,49.8]],['C',[31.65,49.85,34.9,51.8]]];
            __motifs["f"] = [['M',[26.95,23.25]],['L',[24.2,23]],['C',[17.2,23,13.55,26.25]],['C',[9.95,29.5,9.9,35.8]],['L',[9.9,43.5]],['L',[1.2,43.5]],['L',[1.2,51]],['L',[9.9,51]],['L',[9.9,95.2]],['L',[18.4,95.2]],['L',[18.4,51]],['L',[28.4,51]],['L',[28.4,43.5]],['L',[18.4,43.5]],['L',[18.4,36.3]],['C',[18.4,33,20.1,31.7]],['C',[21.85,30.45,24.9,30.5]],['L',[27.3,30.65]],['L',[29.7,31.2]],['L',[29.7,23.8]],['L',[26.95,23.25]]];
            __motifs["g"] = [['M',[43,43.5]],['L',[43,50.85]],['L',[42.9,50.85]],['C',[40.55,46.6,36.45,44.4]],['C',[32.45,42.25,27.5,42.25]],['C',[20.8,42.35,16.2,44.8]],['C',[11.6,47.3,8.85,51.35]],['C',[6.05,55.4,4.85,60.2]],['C',[3.6,64.95,3.6,69.55]],['C',[3.6,76.75,6.2,82.65]],['C',[8.75,88.55,13.85,92.1]],['C',[19,95.7,26.7,95.8]],['C',[30,95.8,33.15,94.75]],['C',[36.35,93.7,38.85,91.65]],['C',[41.35,89.55,42.8,86.35]],['L',[43,86.35]],['L',[43,89.8]],['C',[43.05,95.65,41.45,100.05]],['C',[39.9,104.5,36.45,106.95]],['C',[33.05,109.4,27.5,109.45]],['C',[24.6,109.45,21.65,108.7]],['C',[18.65,107.85,16.5,106]],['C',[14.4,104.15,14.1,101]],['L',[5.6,101]],['C',[5.95,106.65,9.25,110]],['C',[12.5,113.35,17.3,114.85]],['C',[22.05,116.3,27,116.25]],['C',[39.2,116.25,45.1,109.85]],['C',[51.05,103.45,51.05,90.75]],['L',[51.05,43.5]],['L',[43,43.5]],['M',[36.45,52.55]],['C',[39.75,55.25,41.2,59.45]],['C',[42.65,63.65,42.65,68.3]],['C',[42.65,73.25,41.1,77.75]],['C',[39.6,82.3,36.2,85.25]],['C',[32.75,88.15,27.2,88.25]],['C',[21.65,88.15,18.45,85.25]],['C',[15.25,82.3,13.9,77.8]],['C',[12.55,73.35,12.6,68.6]],['C',[12.6,63.55,14.15,59.3]],['C',[15.7,55.05,19.1,52.5]],['C',[22.45,49.85,27.95,49.8]],['C',[33.25,49.9,36.45,52.55]]];
            __motifs["h"] = [['M',[6.4,23.8]],['L',[6.4,95.2]],['L',[14.9,95.2]],['L',[14.9,66]],['C',[14.9,61.3,16.55,57.65]],['C',[18.25,54,21.65,51.95]],['C',[25.05,49.85,30.2,49.8]],['C',[35.15,49.85,37.9,52.6]],['C',[40.65,55.4,40.7,60.2]],['L',[40.7,95.2]],['L',[49.2,95.2]],['L',[49.2,61.15]],['C',[49.25,55.6,47.6,51.35]],['C',[46,47.1,42.1,44.7]],['C',[38.2,42.3,31.4,42.25]],['C',[28.25,42.25,25.05,43.2]],['C',[21.85,44.1,19.2,46.05]],['C',[16.55,48,15.1,51.05]],['L',[14.9,51.05]],['L',[14.9,23.8]],['L',[6.4,23.8]]];
            __motifs["i"] = [['M',[15.4,23.8]],['L',[6.9,23.8]],['L',[6.9,34.2]],['L',[15.4,34.2]],['L',[15.4,23.8]],['M',[6.9,43.5]],['L',[6.9,95.2]],['L',[15.4,95.2]],['L',[15.4,43.5]],['L',[6.9,43.5]]];
            __motifs["j"] = [['M',[15.4,23.8]],['L',[6.9,23.8]],['L',[6.9,34.2]],['L',[15.4,34.2]],['L',[15.4,23.8]],['M',[6.9,43.5]],['L',[6.9,100.4]],['C',[6.95,104.35,5.85,105.95]],['C',[4.85,107.55,2.1,107.5]],['L',[0.35,107.5]],['L',[-1.4,107.3]],['L',[-1.4,114.65]],['L',[0.85,114.95]],['L',[3,115]],['C',[8.7,115.05,12,111.85]],['C',[15.3,108.7,15.4,101.8]],['L',[15.4,43.5]],['L',[6.9,43.5]]];
            __motifs["k"] = [['M',[6.9,23.8]],['L',[6.9,95.2]],['L',[15.4,95.2]],['L',[15.4,75.6]],['L',[23.4,68.2]],['L',[41.05,95.2]],['L',[51.85,95.2]],['L',[29.9,62.3]],['L',[50.4,43.5]],['L',[38.95,43.5]],['L',[15.4,66.1]],['L',[15.4,23.8]],['L',[6.9,23.8]]];
            __motifs["l"] = [['M',[6.9,23.8]],['L',[6.9,95.2]],['L',[15.4,95.2]],['L',[15.4,23.8]],['L',[6.9,23.8]]];
            __motifs["m"] = [['M',[52.4,44.6]],['C',[48.15,46.9,45.45,51.05]],['C',[43.8,46.35,39.95,44.3]],['C',[36.1,42.2,31.3,42.25]],['C',[25.95,42.25,21.7,44.5]],['C',[17.5,46.7,14.6,51.05]],['L',[14.4,51.05]],['L',[14.4,43.5]],['L',[6.4,43.5]],['L',[6.4,95.2]],['L',[14.9,95.2]],['L',[14.9,62.95]],['C',[14.9,61.45,15.65,59.25]],['C',[16.35,57.05,18,54.9]],['C',[19.65,52.75,22.25,51.3]],['C',[24.9,49.85,28.65,49.8]],['C',[34.3,49.9,36.4,53]],['C',[38.5,56.2,38.4,61.25]],['L',[38.4,95.2]],['L',[46.9,95.2]],['L',[46.9,62.95]],['C',[46.9,56.9,50.55,53.4]],['C',[54.15,49.85,60.35,49.8]],['C',[64.45,49.85,66.65,51.35]],['C',[68.85,52.85,69.65,55.45]],['C',[70.4,58.05,70.35,61.25]],['L',[70.35,95.2]],['L',[78.85,95.2]],['L',[78.85,57.25]],['C',[78.75,49.3,74.1,45.8]],['C',[69.5,42.2,61.65,42.25]],['C',[56.65,42.3,52.4,44.6]]];
            __motifs["n"] = [['M',[6.4,43.5]],['L',[6.4,95.2]],['L',[14.9,95.2]],['L',[14.9,66]],['C',[14.9,61.3,16.55,57.65]],['C',[18.25,54,21.65,51.95]],['C',[25.05,49.85,30.2,49.8]],['C',[35.15,49.85,37.9,52.6]],['C',[40.65,55.4,40.7,60.2]],['L',[40.7,95.2]],['L',[49.2,95.2]],['L',[49.2,61.15]],['C',[49.25,55.6,47.6,51.35]],['C',[46,47.1,42.1,44.7]],['C',[38.2,42.3,31.4,42.25]],['C',[25.85,42.25,21.6,44.55]],['C',[17.35,46.9,14.6,51.7]],['L',[14.4,51.7]],['L',[14.4,43.5]],['L',[6.4,43.5]]];
            __motifs["o"] = [['M',[14.9,45.95]],['C',[9.35,49.5,6.5,55.6]],['C',[3.6,61.7,3.6,69.4]],['C',[3.6,77.05,6.5,83.15]],['C',[9.35,89.2,14.9,92.75]],['C',[20.5,96.3,28.7,96.4]],['C',[36.9,96.3,42.55,92.75]],['C',[48.1,89.2,50.95,83.15]],['C',[53.8,77.05,53.8,69.4]],['C',[53.8,61.7,50.95,55.6]],['C',[48.1,49.5,42.55,45.95]],['C',[36.9,42.35,28.7,42.25]],['C',[20.5,42.35,14.9,45.95]],['M',[28.7,49.8]],['C',[33.2,49.8,36.85,52.1]],['C',[40.5,54.35,42.65,58.75]],['C',[44.8,63.05,44.8,69.4]],['C',[44.8,75.65,42.65,80]],['C',[40.5,84.35,36.85,86.6]],['C',[33.2,88.9,28.7,88.9]],['C',[24.2,88.9,20.55,86.6]],['C',[16.95,84.35,14.8,80]],['C',[12.65,75.65,12.6,69.4]],['C',[12.65,63.05,14.8,58.75]],['C',[16.95,54.35,20.55,52.1]],['C',[24.2,49.8,28.7,49.8]]];
            __motifs["p"] = [['M',[6.7,43.5]],['L',[6.7,115]],['L',[15.2,115]],['L',[15.2,88.3]],['L',[15.4,88.3]],['C',[17.35,91.35,20.2,93.1]],['C',[23.1,94.9,26.25,95.7]],['L',[32.15,96.4]],['C',[40.05,96.3,45.25,92.65]],['C',[50.5,89.05,53.15,82.95]],['C',[55.7,76.9,55.7,69.5]],['C',[55.7,62.1,53.1,55.95]],['C',[50.45,49.8,45.15,46.1]],['C',[39.85,42.35,31.9,42.25]],['C',[26.45,42.25,22,44.2]],['C',[17.6,46.25,15.4,50.45]],['L',[15.2,50.45]],['L',[15.2,43.5]],['L',[6.7,43.5]],['M',[30.7,49.8]],['C',[36.2,49.9,39.75,52.55]],['C',[43.3,55.3,45,59.6]],['C',[46.75,63.95,46.75,68.9]],['C',[46.8,74.05,45.3,78.6]],['C',[43.8,83.1,40.4,85.95]],['C',[36.95,88.8,31.2,88.9]],['C',[25.4,88.85,21.8,86.05]],['C',[18.15,83.35,16.5,78.95]],['C',[14.85,74.5,14.9,69.25]],['C',[14.85,64.35,16.45,59.95]],['C',[18,55.5,21.55,52.65]],['C',[25,49.9,30.7,49.8]]];
            __motifs["q"] = [['M',[44.1,43.5]],['L',[44.1,50.4]],['L',[43.9,50.4]],['C',[41.95,47.35,39.05,45.6]],['C',[36.2,43.8,33.05,43]],['L',[27.2,42.25]],['C',[19.3,42.35,14.05,46.05]],['C',[8.85,49.65,6.2,55.75]],['C',[3.6,61.8,3.6,69.15]],['C',[3.6,76.6,6.25,82.75]],['C',[8.9,88.9,14.15,92.6]],['C',[19.45,96.3,27.4,96.4]],['C',[32.8,96.4,37.25,94.45]],['C',[41.7,92.45,43.9,88.2]],['L',[44.1,88.2]],['L',[44.1,115]],['L',[52.6,115]],['L',[52.6,43.5]],['L',[44.1,43.5]],['M',[37.5,52.6]],['C',[41.1,55.35,42.75,59.75]],['C',[44.45,64.2,44.4,69.4]],['C',[44.45,74.35,42.8,78.75]],['C',[41.25,83.2,37.75,86]],['C',[34.3,88.8,28.6,88.9]],['C',[23.1,88.8,19.6,86.1]],['C',[16,83.4,14.3,79.1]],['C',[12.6,74.75,12.6,69.8]],['C',[12.55,64.65,14,60.1]],['C',[15.55,55.6,18.9,52.7]],['C',[22.3,49.9,28.1,49.8]],['C',[33.95,49.85,37.5,52.6]]];
            __motifs["r"] = [['M',[6.1,43.5]],['L',[6.1,95.2]],['L',[14.6,95.2]],['L',[14.6,72.2]],['C',[14.5,62.25,18.8,56.75]],['C',[23.15,51.35,33.3,51.25]],['L',[33.3,42.25]],['C',[26.45,42.1,21.9,45.1]],['C',[17.35,48.15,14.3,54.35]],['L',[14.1,54.35]],['L',[14.1,43.5]],['L',[6.1,43.5]]];
            __motifs["s"] = [['M',[7.2,48.55]],['C',[4.3,51.8,4.2,56.95]],['C',[4.3,61.85,6.7,64.75]],['C',[9.15,67.6,13,69.15]],['C',[16.8,70.7,21.1,71.55]],['L',[29.25,73.45]],['C',[33.1,74.45,35.5,76.2]],['C',[37.9,77.95,38,81.2]],['C',[37.9,84.4,35.95,86.1]],['C',[33.95,87.8,31.1,88.35]],['L',[25.5,88.9]],['C',[21.95,88.95,18.85,88]],['C',[15.75,87.1,13.8,84.9]],['C',[11.8,82.7,11.6,78.9]],['L',[3.15,78.9]],['C',[3.45,85.3,6.45,89.15]],['C',[9.4,93,14.3,94.7]],['C',[19.15,96.4,25,96.4]],['C',[30.35,96.45,35.35,94.9]],['C',[40.4,93.4,43.6,89.8]],['C',[46.9,86.2,46.95,80.1]],['C',[46.9,75.2,44.5,72.3]],['C',[42.1,69.35,38.25,67.85]],['C',[34.4,66.3,30.1,65.4]],['L',[22.2,63.55]],['C',[18.35,62.65,15.8,61]],['C',[13.3,59.35,13.2,56.4]],['C',[13.25,53.8,14.9,52.4]],['C',[16.55,50.9,19.05,50.35]],['L',[24.15,49.8]],['C',[27.05,49.75,29.65,50.55]],['C',[32.3,51.4,34.05,53.3]],['C',[35.85,55.2,36.2,58.5]],['L',[44.7,58.5]],['C',[44.3,52.25,41.4,48.65]],['C',[38.55,45.15,33.9,43.7]],['C',[29.25,42.2,23.5,42.25]],['C',[18.9,42.25,14.5,43.8]],['C',[10.1,45.3,7.2,48.55]]];
            __motifs["t"] = [['M',[18.2,28]],['L',[9.7,28]],['L',[9.7,43.5]],['L',[0.95,43.5]],['L',[0.95,51]],['L',[9.7,51]],['L',[9.7,83.85]],['C',[9.7,88.6,10.95,91.05]],['C',[12.2,93.5,14.9,94.35]],['C',[17.65,95.25,22,95.2]],['L',[28.5,95.2]],['L',[28.5,87.7]],['L',[24.6,87.7]],['C',[20.75,87.8,19.45,86.85]],['C',[18.1,85.9,18.2,83.1]],['L',[18.2,51]],['L',[28.5,51]],['L',[28.5,43.5]],['L',[18.2,43.5]],['L',[18.2,28]]];
            __motifs["u"] = [['M',[40.7,43.5]],['L',[40.7,72.7]],['C',[40.7,77.4,39.05,81.05]],['C',[37.35,84.7,34,86.75]],['C',[30.55,88.85,25.4,88.9]],['C',[20.45,88.85,17.7,86.05]],['C',[14.95,83.3,14.9,78.5]],['L',[14.9,43.5]],['L',[6.4,43.5]],['L',[6.4,77.5]],['C',[6.35,83.1,8,87.35]],['C',[9.6,91.6,13.55,94]],['C',[17.45,96.35,24.2,96.4]],['C',[29.8,96.4,34.05,94.15]],['C',[38.3,91.8,41,87]],['L',[41.2,87]],['L',[41.2,95.2]],['L',[49.2,95.2]],['L',[49.2,43.5]],['L',[40.7,43.5]]];
            __motifs["v"] = [['M',[1.4,43.5]],['L',[20.6,95.2]],['L',[29.75,95.2]],['L',[48.65,43.5]],['L',[39.75,43.5]],['L',[25.65,86.6]],['L',[25.45,86.6]],['L',[10.95,43.5]],['L',[1.4,43.5]]];
            __motifs["w"] = [['M',[65.35,43.5]],['L',[53.7,85.8]],['L',[53.5,85.8]],['L',[42.7,43.5]],['L',[33.4,43.5]],['L',[23,85.8]],['L',[22.8,85.8]],['L',[11.1,43.5]],['L',[1.7,43.5]],['L',[18.3,95.2]],['L',[27.5,95.2]],['L',[37.9,54.1]],['L',[38.1,54.1]],['L',[48.6,95.2]],['L',[57.6,95.2]],['L',[74.1,43.5]],['L',[65.35,43.5]]];
            __motifs["x"] = [['M',[2.3,43.5]],['L',[20.3,68]],['L',[0.9,95.2]],['L',[11.2,95.2]],['L',[25.6,73.7]],['L',[40,95.2]],['L',[50.9,95.2]],['L',[30.85,67.2]],['L',[48.7,43.5]],['L',[38.5,43.5]],['L',[25.6,61.6]],['L',[13.2,43.5]],['L',[2.3,43.5]]];
            __motifs["y"] = [['M',[0.85,43.5]],['L',[21.35,94.9]],['L',[17.8,103.75]],['C',[16.65,106,15.05,107.2]],['C',[13.45,108.45,10.85,108.45]],['L',[8.3,108.05]],['L',[5.8,107.25]],['L',[5.8,115]],['L',[8.75,115.75]],['L',[11.7,115.95]],['C',[15.5,115.95,18.1,114.65]],['C',[20.75,113.25,22.8,110.2]],['C',[24.8,107.15,26.7,102.15]],['L',[49.2,43.5]],['L',[40.25,43.5]],['L',[25.75,85.85]],['L',[25.55,85.85]],['L',[10.45,43.5]],['L',[0.85,43.5]]];
            __motifs["z"] = [['M',[44.4,43.5]],['L',[4.2,43.5]],['L',[4.2,51]],['L',[33.4,51]],['L',[2.2,88.7]],['L',[2.2,95.2]],['L',[45.8,95.2]],['L',[45.8,87.7]],['L',[12.8,87.7]],['L',[44.4,49.3]],['L',[44.4,43.5]]];
        }

        static private function initializeMotifsNumbers():void {
            __motifs["0"] = [['M',[40.85,27.7]],['C',[36.1,24.4,27.85,24.3]],['C',[19.55,24.4,14.75,27.7]],['C',[9.95,31.1,7.65,36.45]],['C',[5.4,41.9,4.8,48.15]],['C',[4.15,54.45,4.2,60.45]],['C',[4.15,66.35,4.8,72.65]],['C',[5.4,78.9,7.65,84.25]],['C',[9.95,89.65,14.75,93]],['C',[19.55,96.3,27.85,96.4]],['C',[36.1,96.3,40.85,93]],['C',[45.65,89.65,47.95,84.25]],['C',[50.2,78.9,50.85,72.65]],['C',[51.45,66.35,51.4,60.45]],['C',[51.45,54.45,50.85,48.15]],['C',[50.2,41.9,47.95,36.45]],['C',[45.65,31.1,40.85,27.7]],['M',[36.25,34.8]],['C',[39.25,37.7,40.6,42.1]],['C',[41.9,46.55,42.2,51.45]],['L',[42.45,60.3]],['L',[42.2,69.25]],['C',[41.9,74.1,40.6,78.6]],['C',[39.25,83.05,36.25,85.9]],['C',[33.2,88.8,27.85,88.9]],['C',[22.4,88.8,19.4,85.9]],['C',[16.35,83.05,15.05,78.6]],['C',[13.7,74.1,13.45,69.25]],['C',[13.15,64.4,13.2,60.3]],['C',[13.15,56.3,13.45,51.45]],['C',[13.7,46.55,15.05,42.1]],['C',[16.35,37.7,19.4,34.8]],['C',[22.4,31.9,27.85,31.8]],['C',[33.2,31.9,36.25,34.8]]];
            __motifs["1"] = [['M',[27.1,44.35]],['L',[27.1,95.2]],['L',[35.6,95.2]],['L',[35.6,24.3]],['L',[29.1,24.3]],['C',[28.1,29.6,25.15,32.5]],['C',[22.15,35.4,17.85,36.5]],['C',[13.6,37.65,8.7,37.6]],['L',[8.7,44.35]],['L',[27.1,44.35]]];
            __motifs["2"] = [['M',[46.45,33.6]],['C',[43.5,29,38.5,26.65]],['C',[33.5,24.3,27.2,24.3]],['C',[19.7,24.35,14.45,27.6]],['C',[9.3,30.85,6.65,36.5]],['C',[4.05,42.1,4.4,49.4]],['L',[12.9,49.4]],['C',[12.75,45.05,14.1,41.05]],['C',[15.55,37.05,18.65,34.5]],['C',[21.8,31.9,26.7,31.8]],['C',[30.5,31.8,33.6,33.45]],['C',[36.7,35,38.55,37.9]],['C',[40.4,40.75,40.45,44.6]],['C',[40.45,49.45,38.45,52.9]],['C',[36.4,56.4,32.3,59.5]],['C',[28.3,62.6,22.3,66.2]],['C',[17.25,69.15,13,72.75]],['C',[8.75,76.25,5.95,81.6]],['C',[3.15,86.9,2.4,95.2]],['L',[48.75,95.2]],['L',[48.75,87.7]],['L',[12.3,87.7]],['C',[13.25,83.35,16.2,80.1]],['C',[19.25,76.95,23.5,74.3]],['C',[27.7,71.65,32.25,69]],['C',[36.7,66.3,40.6,63]],['C',[44.5,59.75,46.9,55.35]],['C',[49.3,50.9,49.4,44.7]],['C',[49.35,38.1,46.45,33.6]]];
            __motifs["3"] = [['M',[45.1,32.55]],['C',[42.35,28.35,37.45,26.3]],['C',[32.6,24.3,26.4,24.3]],['C',[19.3,24.35,14.5,27.25]],['C',[9.7,30.15,7.25,35.3]],['C',[4.75,40.4,4.5,47.2]],['L',[13,47.2]],['C',[13.05,43,14.45,39.55]],['C',[15.85,36.05,18.8,33.95]],['C',[21.8,31.85,26.4,31.8]],['C',[31.95,31.8,35.4,34.75]],['C',[38.9,37.65,39,43.2]],['C',[38.95,47.05,37.1,49.65]],['C',[35.25,52.25,32.25,53.55]],['C',[29.15,54.8,25.5,54.8]],['L',[23.7,54.8]],['L',[21.8,54.7]],['L',[21.8,61.9]],['L',[24.3,61.65]],['L',[26.9,61.6]],['C',[31.15,61.6,34.5,63.15]],['C',[37.95,64.7,39.95,67.7]],['C',[41.95,70.75,42,75.25]],['C',[41.95,79.55,39.85,82.6]],['C',[37.75,85.65,34.3,87.3]],['C',[30.8,88.9,26.55,88.9]],['C',[19.3,88.8,15.5,84.55]],['C',[11.7,80.3,11.45,73.35]],['L',[3,73.35]],['C',[2.9,80.65,5.75,85.8]],['C',[8.65,90.95,14,93.7]],['C',[19.35,96.35,26.55,96.4]],['C',[33.3,96.4,38.8,94]],['C',[44.35,91.55,47.6,86.7]],['C',[50.9,81.9,51,74.8]],['C',[51,68.35,47.8,63.75]],['C',[44.65,59.1,38.2,57.6]],['L',[38.2,57.4]],['C',[42.35,55.5,45.1,51.75]],['C',[47.9,48.05,48,43.3]],['C',[47.95,36.75,45.1,32.55]]];
            __motifs["4"] = [['M',[33.9,36.35]],['L',[33.9,71.1]],['L',[10.1,71.1]],['L',[33.7,36.35]],['L',[33.9,36.35]],['M',[33.9,95.2]],['L',[41.9,95.2]],['L',[41.9,78.6]],['L',[51.5,78.6]],['L',[51.5,71.1]],['L',[41.9,71.1]],['L',[41.9,24.3]],['L',[35.1,24.3]],['L',[2.8,70.4]],['L',[2.8,78.6]],['L',[33.9,78.6]],['L',[33.9,95.2]]];
            __motifs["5"] = [['M',[46.95,25.45]],['L',[12,25.45]],['L',[5.4,62.3]],['L',[12.7,62.7]],['C',[15.2,59.65,18.5,57.85]],['C',[21.85,56.05,25.95,56]],['C',[30.65,56.05,34.3,58.1]],['C',[37.85,60.15,39.85,63.75]],['C',[41.85,67.35,41.9,72.1]],['C',[41.85,77.75,39.8,81.5]],['C',[37.8,85.2,34.4,87.05]],['C',[31,88.9,26.9,88.9]],['C',[20.45,88.8,16.45,85.25]],['C',[12.45,81.65,12,76.1]],['L',[3.5,76.1]],['C',[3.75,82.5,6.8,87.05]],['C',[9.8,91.6,14.85,94]],['C',[19.85,96.35,26.1,96.4]],['C',[34.35,96.3,39.85,92.95]],['C',[45.35,89.6,48.1,84.25]],['C',[50.9,78.9,50.9,72.8]],['C',[50.8,64.7,47.75,59.25]],['C',[44.7,53.9,39.55,51.15]],['C',[34.4,48.45,28,48.45]],['C',[24.3,48.45,20.75,49.75]],['C',[17.25,50.95,14.8,53.6]],['L',[14.6,53.4]],['L',[18.4,33]],['L',[46.95,33]],['L',[46.95,25.45]]];
            __motifs["6"] = [['M',[49.9,42.4]],['C',[49.05,33.75,43.9,29.05]],['C',[38.7,24.35,29.95,24.3]],['C',[22.35,24.4,17.35,27.5]],['C',[12.25,30.65,9.3,36]],['C',[6.3,41.35,5.05,48.15]],['C',[3.75,54.9,3.8,62.3]],['C',[3.75,68,4.7,73.9]],['C',[5.55,79.85,8.15,84.95]],['C',[10.7,90,15.55,93.2]],['C',[20.4,96.3,28.2,96.4]],['C',[34.9,96.35,39.45,94.15]],['C',[44.05,91.95,46.8,88.35]],['C',[49.5,84.8,50.75,80.65]],['C',[51.9,76.5,51.9,72.6]],['C',[51.85,65.95,49.3,60.8]],['C',[46.75,55.6,41.9,52.6]],['C',[37.05,49.6,30.2,49.55]],['C',[24.4,49.55,19.95,51.75]],['C',[15.55,54,12.5,58.85]],['L',[12.3,58.7]],['C',[12.4,54.5,13.15,49.9]],['C',[13.8,45.25,15.65,41.15]],['C',[17.45,37.05,20.75,34.45]],['C',[24.1,31.9,29.55,31.8]],['C',[34.55,31.85,37.7,34.7]],['C',[40.75,37.55,41.4,42.4]],['L',[49.9,42.4]],['M',[36.6,59.25]],['C',[39.8,61.45,41.35,65.05]],['C',[42.9,68.75,42.9,73.2]],['C',[42.9,77.45,41.25,81]],['C',[39.6,84.55,36.45,86.7]],['C',[33.25,88.85,28.6,88.9]],['C',[23.95,88.85,20.65,86.75]],['C',[17.4,84.65,15.65,81.1]],['C',[13.9,77.5,13.9,73.1]],['C',[13.9,68.6,15.65,65]],['C',[17.3,61.35,20.6,59.2]],['C',[23.9,57.1,28.6,57.05]],['C',[33.45,57.1,36.6,59.25]]];
            __motifs["7"] = [['M',[50.95,25.45]],['L',[5.05,25.45]],['L',[5.05,33.5]],['L',[42.25,33.5]],['C',[34.7,41.45,28.7,51.15]],['C',[22.65,60.9,18.9,72.05]],['C',[15.1,83.15,14.2,95.2]],['L',[23.75,95.2]],['C',[24.2,86.8,26.5,78.05]],['C',[28.75,69.3,32.45,60.95]],['C',[36.15,52.6,40.8,45.4]],['C',[45.5,38.15,50.95,32.8]],['L',[50.95,25.45]]];
            __motifs["8"] = [['M',[46.65,33.75]],['C',[44.5,29.6,39.75,27]],['C',[35,24.4,27.3,24.3]],['C',[21.8,24.3,17.05,26.4]],['C',[12.35,28.5,9.45,32.5]],['C',[6.6,36.55,6.5,42.4]],['C',[6.55,47.3,9.25,51.25]],['C',[11.9,55.2,16.35,57.1]],['C',[10.45,59.2,7.25,63.85]],['C',[4.05,68.45,4,74.8]],['C',[4.05,82.05,7.25,86.85]],['C',[10.4,91.65,15.8,94.05]],['C',[21.25,96.4,28.15,96.4]],['C',[34.7,96.35,40.05,93.85]],['C',[45.3,91.3,48.45,86.5]],['C',[51.5,81.65,51.6,74.8]],['C',[51.6,68.15,48.5,63.65]],['C',[45.35,59.1,39,57.05]],['C',[43.4,55.05,46.05,51.1]],['C',[48.75,47.2,48.8,42.4]],['C',[48.85,37.85,46.65,33.75]],['M',[15.5,42.7]],['C',[15.55,39.15,17.2,36.7]],['C',[18.85,34.3,21.65,33.05]],['C',[24.45,31.8,27.9,31.8]],['C',[33.15,31.8,36.45,34.6]],['C',[39.7,37.4,39.8,42.7]],['C',[39.7,48.15,36.45,51.1]],['C',[33.2,54.05,28.1,54.1]],['C',[24.55,54.1,21.7,52.85]],['C',[18.85,51.65,17.2,49.1]],['C',[15.55,46.6,15.5,42.7]],['M',[28.05,61.6]],['C',[32.1,61.65,35.35,63.35]],['C',[38.65,65.1,40.65,68.2]],['C',[42.6,71.25,42.65,75.1]],['C',[42.55,81.15,38.55,84.95]],['C',[34.6,88.8,28.15,88.9]],['C',[21.4,88.85,17.25,85.25]],['C',[13.1,81.65,13,75.2]],['C',[13.05,71.1,15,68.05]],['C',[17,65,20.35,63.3]],['C',[23.8,61.6,28.05,61.6]]];
            __motifs["9"] = [['M',[13.75,40.4]],['C',[15.15,36.6,18.2,34.2]],['C',[21.3,31.85,26.25,31.8]],['C',[31.05,31.85,34.3,34.05]],['C',[37.55,36.25,39.2,39.95]],['C',[40.85,43.6,40.85,48.05]],['C',[40.85,52.3,39.1,55.8]],['C',[37.35,59.3,34.1,61.45]],['C',[30.85,63.55,26.4,63.6]],['C',[22.25,63.55,19.15,61.45]],['C',[15.95,59.35,14.2,56]],['C',[12.45,52.55,12.4,48.6]],['C',[12.35,44.15,13.75,40.4]],['M',[6.4,35.35]],['C',[3.45,40.5,3.4,47.4]],['C',[3.4,54.5,6,59.8]],['C',[8.6,65.1,13.55,68.1]],['C',[18.6,71.1,25.8,71.15]],['C',[31.05,71.1,35.4,68.5]],['C',[39.7,65.85,42.2,61.3]],['L',[42.4,61.5]],['C',[42.05,75.25,38.1,82.05]],['C',[34.2,88.9,26.4,88.9]],['C',[21.15,88.9,17.55,86.1]],['C',[13.95,83.35,13.4,78.1]],['L',[4.9,78.1]],['C',[5.45,84.2,8.3,88.25]],['C',[11.15,92.35,15.75,94.35]],['C',[20.4,96.4,26.35,96.4]],['C',[39.2,96.3,45.1,86.5]],['C',[51.05,76.7,51,58.2]],['C',[50.9,44.9,47.6,37.55]],['C',[44.35,30.1,38.85,27.15]],['C',[33.35,24.2,26.65,24.3]],['C',[19.8,24.35,14.55,27.25]],['C',[9.35,30.15,6.4,35.35]]];
        }

        static private function initializeMotifsPunctuation():void {
            __motifs[" "] = [];
            __motifs["!"] = [['M',[17.7,23.8]],['L',[8.2,23.8]],['L',[8.2,45.8]],['L',[10.7,76.9]],['L',[15.25,76.9]],['L',[17.7,45.8]],['L',[17.7,23.8]],['M',[7.4,95.2]],['L',[18.5,95.2]],['L',[18.5,84.1]],['L',[7.4,84.1]],['L',[7.4,95.2]]];
            __motifs["\""] = [['M',[10.5,23.8]],['L',[10.5,49.6]],['L',[17.3,49.6]],['L',[17.3,23.8]],['L',[10.5,23.8]]];
            __motifs["#"] = [['M',[46.2,25.5]],['L',[39.3,25.5]],['L',[36.45,46.05]],['L',[24,46.05]],['L',[26.9,25.5]],['L',[20,25.5]],['L',[17.1,46.05]],['L',[6,46.05]],['L',[6,52.8]],['L',[16.2,52.8]],['L',[14.1,67.8]],['L',[3.4,67.8]],['L',[3.4,74.6]],['L',[13.15,74.6]],['L',[10.2,95.2]],['L',[17.1,95.2]],['L',[20,74.6]],['L',[32.4,74.6]],['L',[29.5,95.2]],['L',[36.45,95.2]],['L',[39.3,74.6]],['L',[49.4,74.6]],['L',[49.4,67.8]],['L',[40.3,67.8]],['L',[42.4,52.8]],['L',[52.2,52.8]],['L',[52.2,46.05]],['L',[43.3,46.05]],['L',[46.2,25.5]],['M',[35.5,52.8]],['L',[33.4,67.8]],['L',[21,67.8]],['L',[23.1,52.8]],['L',[35.5,52.8]]];
            __motifs["$"] = [['M',[43.5,28.3]],['C',[38.65,23.25,30.6,22.2]],['L',[30.6,15.5]],['L',[25.1,15.5]],['L',[25.1,22.1]],['C',[19.3,22.5,14.65,25.2]],['C',[10.05,27.85,7.3,32.45]],['C',[4.65,37.05,4.6,43.1]],['C',[4.6,48.9,6.8,52.55]],['C',[9,56.25,13.55,58.5]],['C',[18.05,60.8,25.1,62.4]],['L',[25.1,88.9]],['C',[19,87.9,15.15,84]],['C',[11.35,80.1,11,73.4]],['L',[2.5,73.4]],['C',[3.4,83.8,9.3,89.85]],['C',[15.2,95.9,25.1,96.9]],['L',[25.1,105.1]],['L',[30.6,105.1]],['L',[30.6,96.9]],['C',[37,96.35,41.95,93.7]],['C',[46.85,91,49.65,86.35]],['C',[52.45,81.65,52.5,75.25]],['C',[52.45,70.6,50.75,67.25]],['C',[49,64,46.5,61.8]],['C',[43.9,59.6,41.25,58.35]],['C',[38.55,57.05,36.6,56.65]],['L',[30.6,55]],['L',[30.6,30.4]],['C',[35.1,31.25,38,34.15]],['C',[40.8,37.15,41.8,42.05]],['L',[50.3,42.05]],['C',[48.4,33.35,43.5,28.3]],['M',[13.55,42.2]],['C',[13.65,36.5,16.95,33.6]],['C',[20.15,30.6,25.1,30.1]],['L',[25.1,53.5]],['C',[21.75,52.55,19.15,51.25]],['C',[16.55,50,15.1,47.85]],['C',[13.55,45.75,13.55,42.2]],['M',[37.2,66.25]],['C',[40.1,67.65,41.8,70]],['C',[43.45,72.35,43.5,76.1]],['C',[43.4,82.5,39.9,85.5]],['C',[36.35,88.5,30.6,88.9]],['L',[30.6,63.8]],['C',[34.3,64.85,37.2,66.25]]];
            __motifs["%"] = [['M',[82.7,82.85]],['C',[82.1,86.2,80.2,88.5]],['C',[78.25,90.8,74.5,90.9]],['C',[70.8,90.8,69,88.45]],['C',[67.2,86.05,66.6,82.75]],['C',[66.05,79.45,66.1,76.4]],['C',[66.05,73.3,66.7,69.95]],['C',[67.4,66.6,69.25,64.25]],['C',[71.15,61.9,74.8,61.8]],['C',[78.5,61.9,80.3,64.25]],['C',[82.2,66.6,82.75,69.9]],['C',[83.35,73.25,83.3,76.3]],['C',[83.35,79.55,82.7,82.85]],['M',[84.45,59.05]],['C',[80.95,56.4,74.8,56.3]],['C',[68.7,56.4,65.15,59.15]],['C',[61.55,62,60.05,66.6]],['C',[58.55,71.2,58.6,76.6]],['C',[58.55,82.05,60.1,86.55]],['C',[61.65,91,65.25,93.7]],['C',[68.8,96.3,74.8,96.4]],['C',[80.55,96.3,84.15,93.5]],['C',[87.65,90.7,89.25,86.1]],['C',[90.8,81.6,90.8,76.3]],['C',[90.85,70.8,89.4,66.25]],['C',[88,61.75,84.45,59.05]],['M',[10.65,34.6]],['C',[9.15,39.2,9.2,44.6]],['C',[9.15,50.05,10.7,54.55]],['C',[12.25,58.95,15.8,61.65]],['C',[19.4,64.3,25.4,64.4]],['C',[31.15,64.3,34.7,61.45]],['C',[38.25,58.7,39.85,54.15]],['C',[41.4,49.6,41.4,44.25]],['C',[41.45,38.8,40,34.25]],['C',[38.55,29.75,35.05,27.1]],['C',[31.55,24.4,25.4,24.3]],['C',[19.3,24.4,15.7,27.2]],['C',[12.15,30,10.65,34.6]],['M',[17.3,37.95]],['C',[17.95,34.6,19.8,32.25]],['C',[21.75,29.9,25.4,29.8]],['C',[29.1,29.9,30.9,32.25]],['C',[32.75,34.6,33.35,37.9]],['C',[33.95,41.25,33.9,44.25]],['C',[33.95,47.5,33.3,50.8]],['C',[32.65,54.2,30.75,56.5]],['C',[28.85,58.75,25.1,58.85]],['C',[21.4,58.75,19.6,56.45]],['C',[17.75,54.05,17.2,50.7]],['C',[16.65,47.4,16.7,44.4]],['C',[16.65,41.3,17.3,37.95]],['M',[27.4,97.4]],['L',[81.1,23.05]],['L',[72.6,23.05]],['L',[18.8,97.4]],['L',[27.4,97.4]]];
            __motifs["&"] = [['M',[43,30.3]],['C',[40.6,27.1,36.65,25.45]],['C',[32.7,23.8,28.2,23.8]],['C',[23.05,23.85,19.45,25.9]],['C',[15.85,27.9,14,31.25]],['C',[12.1,34.55,12.1,38.5]],['C',[12.15,42.1,13.3,44.8]],['C',[14.4,47.55,16.15,50.05]],['L',[20,55.25]],['C',[15.4,57.65,11.6,60.55]],['C',[7.85,63.45,5.6,67.4]],['C',[3.35,71.35,3.3,76.9]],['C',[3.25,79.2,4.1,82.4]],['C',[4.95,85.65,7.25,88.85]],['C',[9.55,92.05,13.95,94.15]],['C',[18.4,96.3,25.6,96.4]],['C',[29.55,96.4,33.35,95.3]],['C',[37.15,94.15,40.4,91.95]],['C',[43.6,89.7,45.8,86.3]],['L',[53.4,95.2]],['L',[64.5,95.2]],['L',[50.6,79.1]],['L',[53.05,73.55]],['C',[53.95,71.2,54.5,68.4]],['C',[55.1,65.6,55.4,61.45]],['L',[47.3,61.45]],['C',[47.15,64.35,46.6,67.1]],['C',[46,69.95,45,72.6]],['L',[32.15,56.85]],['C',[35.6,54.9,38.65,52.25]],['C',[41.7,49.55,43.55,46.1]],['C',[45.45,42.65,45.5,38.4]],['C',[45.4,33.6,43,30.3]],['M',[24.9,32.15]],['C',[26.75,31.35,28.8,31.35]],['C',[32.65,31.45,34.8,33.6]],['C',[36.95,35.8,37,38.9]],['C',[36.95,41.95,35.45,44.2]],['C',[34,46.5,31.8,48.3]],['L',[27.5,51.3]],['L',[24.3,47.35]],['C',[22.75,45.3,21.7,43.2]],['C',[20.65,41.1,20.6,38.9]],['C',[20.65,36.3,21.85,34.65]],['C',[23.05,32.95,24.9,32.15]],['M',[18.5,64.65]],['C',[21.3,62.55,24.7,60.7]],['L',[41.1,80.4]],['C',[38.5,84.35,34.6,86.6]],['C',[30.8,88.85,25.95,88.9]],['C',[22.4,88.9,19.35,87.4]],['C',[16.2,85.85,14.3,83.15]],['C',[12.35,80.4,12.3,76.8]],['C',[12.35,72.6,14,69.65]],['C',[15.7,66.8,18.5,64.65]]];
            __motifs["'"] = [['M',[24.9,23.8]],['L',[24.9,49.6]],['L',[31.7,49.6]],['L',[31.7,23.8]],['L',[24.9,23.8]],['M',[10.9,23.8]],['L',[10.9,49.6]],['L',[17.7,49.6]],['L',[17.7,23.8]],['L',[10.9,23.8]]];
            __motifs["("] = [['M',[11.75,36.65]],['C',[8.3,44.3,6.5,52.35]],['C',[4.7,60.4,4.7,68.2]],['C',[4.8,81.25,8.95,92.55]],['C',[13.1,103.9,20.35,115]],['L',[26.85,115]],['C',[19.8,103.65,16.7,92.15]],['C',[13.6,80.75,13.65,68.2]],['C',[13.6,56.1,16.7,44.7]],['C',[19.8,33.35,26.85,22.1]],['L',[20.35,22.1]],['C',[15.3,28.95,11.75,36.65]]];
            __motifs[")"] = [['M',[5.5,22.1]],['L',[-1,22.1]],['C',[6.05,33.5,9.2,44.95]],['C',[12.25,56.4,12.2,68.95]],['C',[12.25,81.05,9.2,92.4]],['C',[6.05,103.8,-1,115]],['L',[5.5,115]],['C',[10.6,108.2,14.1,100.45]],['C',[17.6,92.8,19.4,84.8]],['C',[21.2,76.75,21.2,68.95]],['C',[21.1,55.9,16.95,44.55]],['C',[12.8,33.25,5.5,22.1]]];
            __motifs["*"] = [['M',[14.8,23.8]],['L',[14.8,35.1]],['L',[4.2,31.1]],['L',[2.4,35.9]],['L',[13,39.7]],['L',[6.5,48.8]],['L',[11,51.9]],['L',[17.5,42.3]],['L',[24.4,51.9]],['L',[28.5,48.8]],['L',[21.9,39.7]],['L',[32.8,35.9]],['L',[30.8,31.1]],['L',[20.1,35.1]],['L',[20.1,23.8]],['L',[14.8,23.8]]];
            __motifs["+"] = [['M',[26.6,44.6]],['L',[26.6,66.5]],['L',[4.85,66.5]],['L',[4.85,73.3]],['L',[26.6,73.3]],['L',[26.6,95.2]],['L',[33.4,95.2]],['L',[33.4,73.3]],['L',[55.2,73.3]],['L',[55.2,66.5]],['L',[33.4,66.5]],['L',[33.4,44.6]],['L',[26.6,44.6]]];
            __motifs[","] = [['M',[8.3,95.2]],['L',[14.2,95.2]],['C',[14.3,96.85,13.75,98.8]],['C',[13.25,100.75,11.95,102.45]],['C',[10.65,104.1,8.4,104.9]],['L',[8.4,109.9]],['C',[14.1,108.2,16.8,104.05]],['C',[19.45,99.9,19.4,94.15]],['L',[19.4,84.1]],['L',[8.3,84.1]],['L',[8.3,95.2]]];
            __motifs["-"] = [['M',[5,71.4]],['L',[33.9,71.4]],['L',[33.9,63.4]],['L',[5,63.4]],['L',[5,71.4]]];
            __motifs["."] = [['M',[8.3,95.2]],['L',[19.4,95.2]],['L',[19.4,84.1]],['L',[8.3,84.1]],['L',[8.3,95.2]]];
            __motifs["/"] = [['M',[27.8,22.1]],['L',[-1.8,96.9]],['L',[5.5,96.9]],['L',[35.1,22.1]],['L',[27.8,22.1]]];
            __motifs[":"] = [['M',[8.3,43.5]],['L',[8.3,54.6]],['L',[19.4,54.6]],['L',[19.4,43.5]],['L',[8.3,43.5]],['M',[8.3,95.2]],['L',[19.4,95.2]],['L',[19.4,84.1]],['L',[8.3,84.1]],['L',[8.3,95.2]]];
            __motifs[";"] = [['M',[8.3,43.5]],['L',[8.3,54.6]],['L',[19.4,54.6]],['L',[19.4,43.5]],['L',[8.3,43.5]],['M',[8.3,95.2]],['L',[14.2,95.2]],['C',[14.3,96.85,13.75,98.8]],['C',[13.25,100.75,11.95,102.45]],['C',[10.65,104.1,8.4,104.9]],['L',[8.4,109.9]],['C',[14.15,108.2,16.8,104.05]],['C',[19.5,99.9,19.4,94.15]],['L',[19.4,84.1]],['L',[8.3,84.1]],['L',[8.3,95.2]]];
            __motifs["<"] = [['M',[4.6,73.05]],['L',[55.35,96.05]],['L',[55.35,89.25]],['L',[12.9,69.9]],['L',[55.35,50.6]],['L',[55.35,43.85]],['L',[4.6,66.85]],['L',[4.6,73.05]]];
            __motifs["="] = [['M',[4.8,83.4]],['L',[55.2,83.4]],['L',[55.2,76.6]],['L',[4.8,76.6]],['L',[4.8,83.4]],['M',[4.8,63.2]],['L',[55.2,63.2]],['L',[55.2,56.45]],['L',[4.8,56.45]],['L',[4.8,63.2]]];
            __motifs[">"] = [['M',[4.6,96.05]],['L',[55.35,73.05]],['L',[55.35,66.85]],['L',[4.6,43.85]],['L',[4.6,50.6]],['L',[47.05,69.9]],['L',[4.6,89.25]],['L',[4.6,96.05]]];
            __motifs["?"] = [['M',[46.25,31.3]],['C',[43.55,26.85,38.8,24.5]],['C',[34.1,22.15,27.9,22.1]],['C',[20.85,22.15,15.8,25.3]],['C',[10.8,28.4,8.1,33.8]],['C',[5.45,39.2,5.5,46.15]],['L',[14,46.15]],['C',[13.95,41.5,15.5,37.75]],['C',[16.95,34,20.05,31.85]],['C',[23.2,29.65,27.95,29.6]],['C',[33.25,29.65,36.45,32.75]],['C',[39.6,35.8,40,41.3]],['C',[40.2,45,39.05,47.65]],['C',[37.95,50.35,36.1,52.45]],['L',[32.25,56.45]],['C',[30.15,58.4,28.1,60.7]],['C',[26.05,63,24.65,66.05]],['C',[23.25,69.05,23.2,73.15]],['L',[23.2,77.8]],['L',[31.7,77.8]],['L',[31.7,73.9]],['C',[31.75,70.55,33,67.95]],['C',[34.25,65.4,36.25,63.25]],['C',[38.2,61.1,40.4,59.1]],['L',[44.6,54.65]],['C',[46.55,52.3,47.7,49.25]],['C',[48.95,46.2,48.95,42.1]],['C',[48.95,35.75,46.25,31.3]],['M',[21.85,84.1]],['L',[21.85,95.2]],['L',[32.9,95.2]],['L',[32.9,84.1]],['L',[21.85,84.1]]];
            __motifs["@"] = [['M',[46,46.05]],['C',[47.8,47.35,48.95,49.45]],['C',[50.1,51.6,50.1,54.05]],['C',[50.1,57.15,48.95,60.85]],['C',[47.75,64.45,45.6,67.75]],['C',[43.5,71.05,40.7,73.15]],['C',[37.9,75.3,34.6,75.35]],['C',[30.8,75.25,28.4,72.6]],['C',[26.05,69.9,26.05,65.6]],['C',[26.05,62.3,27.2,58.7]],['C',[28.35,55.05,30.45,51.9]],['C',[32.6,48.7,35.55,46.75]],['C',[38.5,44.75,42,44.7]],['C',[44.15,44.75,46,46.05]],['M',[53.2,46.15]],['C',[51.4,41.7,48.5,39.8]],['C',[45.5,37.9,42,37.9]],['C',[36.7,37.95,32.35,40.4]],['C',[28.1,42.8,25,46.9]],['C',[21.9,51,20.2,56.05]],['C',[18.55,61.05,18.5,66.35]],['C',[18.55,70.8,20.3,74.35]],['C',[22.1,77.85,25.35,79.95]],['C',[28.5,82.05,32.8,82.1]],['C',[36.5,82,39.75,80.05]],['C',[42.9,78.15,45.2,75.4]],['L',[45.5,75.4]],['C',[45.7,78.7,47.5,80.3]],['C',[49.25,81.9,51.9,81.9]],['C',[55.5,81.85,59.5,79.8]],['C',[63.55,77.75,67.15,73.95]],['C',[70.7,70.1,72.95,64.8]],['C',[75.2,59.45,75.3,52.9]],['C',[75.2,43.85,70.6,36.95]],['C',[66,30,58.35,26.1]],['C',[50.7,22.2,41.3,22.1]],['C',[33.65,22.15,26.95,25.05]],['C',[20.2,27.85,15.15,32.95]],['C',[10,38,7.15,44.7]],['C',[4.25,51.45,4.2,59.2]],['C',[4.3,69.85,9.25,78.35]],['C',[14.15,86.85,22.6,91.85]],['C',[31.05,96.8,41.7,96.9]],['C',[48.15,96.85,54.1,94.75]],['C',[60,92.65,64.9,88.75]],['C',[69.8,84.85,73,79.35]],['L',[66.7,79.35]],['C',[63.85,83,59.9,85.7]],['C',[55.9,88.4,51.3,89.9]],['C',[46.7,91.4,41.9,91.4]],['C',[33.4,91.3,26.4,87.15]],['C',[19.45,83,15.3,75.8]],['C',[11.1,68.7,11,59.7]],['C',[11.1,50.85,15.1,43.6]],['C',[19.05,36.35,25.95,32.05]],['C',[32.75,27.7,41.4,27.6]],['C',[48.55,27.65,54.65,30.8]],['C',[60.8,33.9,64.6,39.7]],['C',[68.4,45.5,68.5,53.4]],['C',[68.45,57.45,67.2,61.5]],['C',[65.95,65.55,63.9,68.95]],['C',[61.85,72.3,59.4,74.3]],['C',[57.05,76.35,54.7,76.4]],['C',[53.4,76.4,52.9,75.5]],['C',[52.3,74.7,52.3,73.35]],['C',[52.35,72.15,52.7,70.85]],['L',[53.4,68.2]],['L',[61.8,39.85]],['L',[55.5,39.85]],['L',[53.2,46.15]]];
            __motifs["["] = [['M',[25.9,22.1]],['L',[7.2,22.1]],['L',[7.2,115]],['L',[25.9,115]],['L',[25.9,108.25]],['L',[15.2,108.25]],['L',[15.2,28.9]],['L',[25.9,28.9]],['L',[25.9,22.1]]];
            __motifs["\\"] = [['M',[35.1,96.9]],['L',[5.5,22.1]],['L',[-1.8,22.1]],['L',[27.8,96.9]],['L',[35.1,96.9]]];
            __motifs["]"] = [['M',[10.7,28.9]],['L',[10.7,108.25]],['L',[0,108.25]],['L',[0,115]],['L',[18.7,115]],['L',[18.7,22.1]],['L',[0,22.1]],['L',[0,28.9]],['L',[10.7,28.9]]];
            __motifs["^"] = [['M',[26.75,25.45]],['L',[5,68.8]],['L',[12.05,68.8]],['L',[29.9,32.8]],['L',[48,68.8]],['L',[55,68.8]],['L',[33.2,25.45]],['L',[26.75,25.45]]];
            __motifs["_"] = [['M',[50,102.7]],['L',[0,102.7]],['L',[0,107.7]],['L',[50,107.7]],['L',[50,102.7]]];
            __motifs["`"] = [['M',[8.6,22.1]],['L',[-2.3,22.1]],['L',[10.8,36.4]],['L',[17.2,36.4]],['L',[8.6,22.1]]];
        }

        static private function initializeWidthsUppercase():void {
            __widths["A"] = 65;
            __widths["B"] = 69;
            __widths["C"] = 72;
            __widths["D"] = 70;
            __widths["E"] = 61;
            __widths["F"] = 57;
            __widths["G"] = 76;
            __widths["H"] = 72;
            __widths["I"] = 26;
            __widths["J"] = 52;
            __widths["K"] = 67;
            __widths["L"] = 56;
            __widths["M"] = 87;
            __widths["N"] = 72;
            __widths["O"] = 76;
            __widths["P"] = 65;
            __widths["Q"] = 76;
            __widths["R"] = 69;
            __widths["S"] = 65;
            __widths["T"] = 57;
            __widths["U"] = 72;
            __widths["V"] = 61;
            __widths["W"] = 93;
            __widths["X"] = 61;
            __widths["Y"] = 65;
            __widths["Z"] = 61;
        }

        static private function initializeWidthsLowercase():void {
            __widths["a"] = 54;
            __widths["b"] = 59;
            __widths["c"] = 54;
            __widths["d"] = 59;
            __widths["e"] = 54;
            __widths["f"] = 30;
            __widths["g"] = 57;
            __widths["h"] = 56;
            __widths["i"] = 22;
            __widths["j"] = 22;
            __widths["k"] = 52;
            __widths["l"] = 22;
            __widths["m"] = 85;
            __widths["n"] = 56;
            __widths["o"] = 57;
            __widths["p"] = 59;
            __widths["q"] = 59;
            __widths["r"] = 33;
            __widths["s"] = 50;
            __widths["t"] = 32;
            __widths["u"] = 56;
            __widths["v"] = 50;
            __widths["w"] = 76;
            __widths["x"] = 52;
            __widths["y"] = 50;
            __widths["z"] = 48;
        }

        static private function initializeWidthsNumbers():void {
            __widths["0"] = 56;
            __widths["1"] = 56;
            __widths["2"] = 56;
            __widths["3"] = 56;
            __widths["4"] = 56;
            __widths["5"] = 56;
            __widths["6"] = 56;
            __widths["7"] = 56;
            __widths["8"] = 56;
            __widths["9"] = 56;
        }

        static private function initializeWidthsPunctuation():void {
            __widths[" "] = 28;
            __widths["!"] = 26;
            __widths["\""] = 43;
            __widths["#"] = 56;
            __widths["$"] = 56;
            __widths["%"] = 100;
            __widths["&"] = 63;
            __widths["'"] = 28;
            __widths["("] = 26;
            __widths[")"] = 26;
            __widths["*"] = 35;
            __widths["+"] = 60;
            __widths[","] = 28;
            __widths["-"] = 39;
            __widths["."] = 28;
            __widths["/"] = 33;
            __widths[":"] = 28;
            __widths[";"] = 28;
            __widths["<"] = 60;
            __widths["="] = 60;
            __widths[">"] = 60;
            __widths["?"] = 56;
            __widths["@"] = 80;
            __widths["["] = 26;
            __widths["\\"] = 33;
            __widths["]"] = 26;
            __widths["^"] = 60;
            __widths["_"] = 50;
            __widths["`"] = 22;
        }

    }

//}
