/**
 * Copyright otherone ( http://wonderfl.net/user/otherone )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wc2S
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.display.Bitmap;
    import flash.display.BitmapData;

    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.system.LoaderContext;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import com.bit101.components.PushButton;
    
    
    [SWF(backgroundColor="0x000000", frameRate="30")]
    /**
     * ...
     * @author moriya
     */
    public class _BitmapCheck extends Sprite
    {
        private const cpart:int = 4;//横刻み
        private const rpart:int = 4;//縦刻み
            
        private const FADE:ColorTransform = new ColorTransform(1,1,1,1,0,0,0,-0x10);
        private var brkNum:Number=0.08

        private var btmdList:Array = [];
        private var btmpList:Array = [];

        private var btmpList2:Array = [];

        private var cntrBMD:BitmapData
        private var sp:Sprite = new Sprite();

        private var cMax:Number;
        private var rMax:Number;
        private var c:int;//行
        private var r:int;//列

        private var tf:TextField;
        private var isSwitch:Boolean = false;
        private var mtx:Matrix;

        private var a_num:Number = 1;
        private var b_num:Number = 0;
        private var c_num:Number = 0;
        private var d_num:Number = 1;
        private var tx_num:Number = 0;
        private var ty_num:Number = 0;

        private var context:LoaderContext;

        private var _imgLoaderB:Loader;


        private const STW:uint = stage.stageWidth, STH:uint = stage.stageHeight;
        private var bmp_obj:Bitmap;
        private var bmp_data:BitmapData;
        private var _imgLoader:Loader;
        private var _imgLoaderInfo:LoaderInfo;
        private var xlist:Array=[];
        private var ylist:Array = [];


        private var clickField:Sprite;
        private var input:TextField;
        private var _textBmd:BitmapData;
        private var _textBmp:Bitmap;
        
        private var offsetX:Number=0;//写真表示時の0座標値
        private var offsetY:Number = 0;//写真表示時の0座標値
        private var offsetX2:Number;//文字表示時の0座標値
        private var offsetY2:Number;//文字表示時の0座標値

        public function _BitmapCheck()
        {
            var url:String = "http://works.mztm.jp/moriya/test/nozokineko2_s.jpg";
            var urlReq:URLRequest = new URLRequest(url);
            var context:LoaderContext = new LoaderContext();
            context.checkPolicyFile = true;
            _imgLoader = new Loader();
            _imgLoaderInfo = _imgLoader.contentLoaderInfo;
            _imgLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onImageloaded);
            _imgLoader.load(urlReq,context);
            //btnClick()
        }
        private function onImageloaded(e:Event):void
        {
            input = new TextField();
            input.width = 200;
            input.height = 20;
            var inputTF:TextFormat = new TextFormat();
            inputTF.size = 14;
            input.border = true;                // 境界線があるか？
            input.borderColor =0x666666;    
            input.defaultTextFormat = inputTF;
            input.textColor = 0x999999;
            //input.autoSize = TextFieldAutoSize.LEFT;
            input.type = TextFieldType.INPUT;
            input.maxChars = 8;
            input.text = '猫が覗くよ';
            input.x = 100;
            input.y = 10;
            
                        
            tf = new TextField();
            tf.width = 500;
            var tfmt:TextFormat = new TextFormat();
            tfmt.size = 80;
            tf.defaultTextFormat = tfmt;
            tf.textColor = 0xffffff;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.textColor = 0x000000;
            
            tf.text = input.text;
            offsetX2 = STW * 0.5 - tf.width * 0.5;
            offsetY2 = STH * 0.5 - tf.height * 0.5;
            
            _textBmd = new BitmapData(tf.width, tf.height);
            _textBmp = new Bitmap(_textBmd)
           
            clickField = new Sprite();
            clickField.graphics.beginFill(0xFFFFFF, 0);
            clickField.graphics.drawRect(0, 0, STW, STH);
            clickField.graphics.endFill();
            clickField.buttonMode = true;
            
            addChild(clickField);
            addChild(input)
            
            btnClick()
            
            var bmd:BitmapData = new BitmapData(_imgLoader.width,_imgLoader.height);
            bmd.draw(_imgLoader);
            var bmp:Bitmap = new Bitmap(bmd);
            fn_setting(bmd);
            
            var pushButton:PushButton = new PushButton(this, 0, 0, "押す", function ():void { btnClick(); } );
            pushButton.x = 304;
            pushButton.y = 10;
            
            clickField.addEventListener(MouseEvent.CLICK, fn_click)
            
            graphics.beginFill(0x000000, 1);
            graphics.drawRect(0, 0, STW, STH);
            graphics.endFill();
        }
        
        private function btnClick():void
        {
            tf.text = input.text;
            offsetX2 = STW * 0.5 - tf.width * 0.5;
            offsetY2 = STH * 0.5 - tf.height * 0.5;
            _textBmd = new BitmapData(tf.width, tf.height);
            _textBmp = new Bitmap(_textBmd)
            _textBmd.draw( tf );
            textSetting(_textBmd, _textBmp);
            
            //座標再設定
            btmpList2=[];
            cMax = _imgLoader.width / cpart;
            rMax = _imgLoader.height/rpart;
            cMax=(_imgLoader.width % cpart == 0)?(cMax):(cMax+1);
            rMax = (_imgLoader.height % rpart == 0)?(rMax):(rMax + 1);

            var _cnt:int = 0;
            for (var i:int=0; i < rMax; i++ )
            {
                r = rpart * i;
                for (var j:int=0; j < cMax; j++ )
                {
                    c = cpart * j;
                    if (xlist.length-1 > _cnt)
                    {
                        _cnt++;
                    }else
                    {
                        _cnt = 0;
                    }
                    var _obj2:Object = new Object();
                    _obj2.x = xlist[_cnt];
                    _obj2.y = ylist[_cnt];
                    btmpList2.push(_obj2);
                }
            }
            
            
            
        }
        
        

        private function textSetting(bmp_data:BitmapData,bmp_obj:Bitmap):void
        {
            xlist = [];
            ylist = [];
            var cmax:int = bmp_data.width;
            var rmax:int = bmp_data.height;
            var cnum:int = 0;
            var cnt:int = 0;
            var _color:uint = 0;

            var _a:uint = 0;
            var _r:uint = 0;
            var _g:uint = 0;
            var _b:uint = 0;

            

            for (var r:int=0; r<rmax; r += 4)
            {
                for (var c:int=0; c< cmax; c += 4)
                {
                    _color = bmp_data.getPixel32(c,r);
                    _a= (_color >> 24) & 0xFF;
                    _r = (_color >> 16) & 0xFF;
                    _g=(_color >>  8) & 0xFF;
                    _b=(_color >>  0) & 0xFF
                    if(_a==255&&_r==0&&_b==0&&_b==0 )
                    {
                        xlist[cnt]=c+2 +offsetX2
                        ylist[cnt]=r+2 +offsetY2
                        cnt++;
                    }

                }
            }
            
            trace(cmax,rmax)
            //trace(xlist.length, ylist.length)
            //trace(xlist)
            //trace('\n');
            //trace(ylist)
        }
        
        private function fn_setting(_bmd:BitmapData):void
        {

            var img:Object = _imgLoader;
            var bmd:BitmapData = _bmd

            offsetX = STW * 0.5 - img.width * 0.5;
            offsetY = STH * 0.5 - img.height * 0.5;

            cntrBMD = new BitmapData(STW, STH, true, 0xFFFFFFFF);
            var cntr:Bitmap = new Bitmap(cntrBMD);
            var cnt:int = 0;

            addChild(cntr);
            //cntr.x = STW *0.5;
            //cntr.y = STH * 0.5;

            c = 0;//行
            r = 0;//列
            cMax = img.width / cpart;
            rMax = img.height/rpart;
            cMax=(img.width % cpart == 0)?(cMax):(cMax+1);
            rMax = (img.height % rpart == 0)?(rMax):(rMax + 1);

            var _cnt:int = 0;
            for (var i:int=0; i < rMax; i++ )
            {
                r = rpart * i;
                for (var j:int=0; j < cMax; j++ )
                {
                    var _obj:Object = new Object();

                    c = cpart * j;
                    var _cbmd:BitmapData = new BitmapData(cpart, rpart, true, 0xFFFFFFFF);
                    _cbmd.copyPixels(bmd, new Rectangle(c, r, cpart, rpart), new Point(0, 0), null, null, false);

                    var _cbm:Bitmap = new Bitmap(_cbmd);
                    sp.addChild(_cbm);
                    _obj.bmp = _cbm
                    _obj.x = c+offsetX;
                    _obj.y = r+offsetY;
                    btmpList.push(_obj);

                    _cbm.x = xlist[_cnt]//Math.random() * STW;//c + j;
                    _cbm.y = ylist[_cnt]//Math.random() * STH//r + i;

                    if (xlist.length-1 > _cnt)
                    {
                        _cnt++;
                    }else
                    {
                        _cnt = 0;
                    }
                }
            }
            
            addEventListener(Event.ENTER_FRAME, fn_update);
        }

        private function fn_click(e:MouseEvent):void
        {
            if (isSwitch)
            {
                isSwitch = false

            }else
            {
                isSwitch = true;
            }
        }

        private function fn_update(e:Event):void
        {
            var _bmpList:Array = [];
            var _cnt:int = 0;
            for (var i:int=0; i < rMax; i++ )
            {
                r = rpart * i;
                for (var j:int=0; j < cMax; j++ )
                {
                    //値 += (目標値 - 現在の値) * 減速値*
                    var _oldX:Number = btmpList[_cnt].oldX;
                    var _oldY:Number = btmpList[_cnt].oldY;
                    var _bmp:Bitmap = btmpList[_cnt].bmp
                    var _x:Number = _bmp.x;
                    var _y:Number = _bmp.y;
                    var _trgtX:Number = 0;
                    var _trgtY:Number = 0;

                    if (isSwitch)
                    {
                        _trgtX = btmpList[_cnt].x;
                        _trgtY = btmpList[_cnt].y;
                    }else
                    {
                        _trgtX = btmpList2[_cnt].x;
                        _trgtY = btmpList2[_cnt].y;
                    }

                    _x += (_trgtX - _x) * brkNum;
                    if (Math.floor(_oldX*10) == Math.floor(_x*10))
                    {
                        _bmp.x = _trgtX;
                    }else
                    {
                        _bmp.x = _x;
                    }

                    _y += (_trgtY - _y) * brkNum;
                    if (Math.floor(_oldY*10) == Math.floor(_y*10))
                    {
                        _bmp.y = _trgtY;
                    }else
                    {
                        _bmp.y = _y;
                    }

                    btmpList[_cnt].oldX = _bmp.x
                    btmpList[_cnt].oldY=_bmp.y

                    _cnt++
                }
            }
            
            mtx = new Matrix(a_num,b_num,c_num,d_num,tx_num,ty_num);
            cntrBMD.colorTransform(cntrBMD.rect, FADE);
            cntrBMD.draw(sp, mtx, null);
        }
    }

}

