/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wbvj
 */

// forked from s8t1h12akj's forked from: SoundVisualizer
// forked from okoi's SoundVisualizer
//
//    SoundVisualizer
//
//    音はTsabeat より拝借
//    http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
//
//
package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.system.Security;
    
    import frocessing.color.ColorHSV;
    
    [SWF(width = "465", height = "465")]

    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        private static const WIDTH:int = 465;
        private static const HEIGHT:int = 465;
        
        private static var policyPath:String = "http://kuetu.sakura.ne.jp/crossdomain.xml";
        private var _path:String = "http://kouetu.skura.ne.jp/MP3_Mujic3/zigeunerweisen.mp3";
        
        private var _soundloader:SoundLoader;
        private var _view:Shape;
        
        private var _canvas:BitmapData;
        
        private var _particle:/*Particle*/Array;
        private var _step:int;
        
        private var _color:ColorHSV;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            //Security.allowDomain("*");
            Security.loadPolicyFile("http://kouetu.sakura.ne.jp/crossdomain.xml");

            graphics.beginFill(0);
            graphics.drawRect(0, 0, WIDTH, HEIGHT);
            graphics.endFill();
            
            _canvas = new BitmapData(WIDTH, HEIGHT, true, 0);
            addChild( new Bitmap(_canvas) );
            
            _view = new Shape();
            addChild( _view );
            
            
            _soundloader = new SoundLoader();
            _soundloader.Load( _path );
                    
            InitParticle();
            _step = 0;
            
            _color = new ColorHSV();
            
            addEventListener( Event.ENTER_FRAME, Update );
        }
        
        private function InitParticle() : void
        {
            _particle = new Array();
            for ( var i:int = 0; i < 512; i++ )
            {
                var p:Particle = new Particle((i*137.5)%360);
                p.x = WIDTH / 2;
                p.y = HEIGHT / 2;
                _particle[_particle.length] = p;
            }
        }
        
        private function Update(e:Event):void
        {
            var array:Array = _soundloader.GetSpectrumData(true);

            var i:int = 0;
            var arraytotal:Number = 0;
            
            for ( i = 0; i < array.length; i++ )
            {
                arraytotal += array[i];
            }
            
            
            for ( i = 0; i < _particle.length; i++ )
            {
                _particle[i].Update( WIDTH / 2, HEIGHT / 2, array[i], i / _particle.length, arraytotal / 512 );
            }
            
            
            _view.graphics.clear();
            for ( i = 0; i < _particle.length; i++ )
            {
                _view.graphics.beginFill(0xFFFFFF, Math.min(_particle[i].alpha, 1) );
                _view.graphics.drawCircle(_particle[i].x, _particle[i].y, 2 + 8*array[i]);
                _view.graphics.endFill();
            }
            
            
            var trans:ColorTransform = new ColorTransform();
            trans.color = _color.value;
            _canvas.draw( _view, null, trans );
            _canvas.applyFilter( _canvas, _canvas.rect, new Point(), new BlurFilter(8,8,3) );
            
            
            _color.h = (_color.h + (arraytotal/512*100)*0.1) % 360;
            
            
            _step++;
        }
        
    }    
}

    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;    
    import flash.media.SoundChannel;    
    import flash.net.URLRequest;
    import flash.utils.ByteArray;


    class SoundLoader
    {
        private  var _started:Boolean;
        private var sound:Sound;
        private var soundChannel:SoundChannel;
        private var bytes:ByteArray;

        
        public function SoundLoader() 
        {
            _started = false;
        }
        
        public function Load(path:String):void
        {
            sound = new Sound();
            sound.addEventListener( Event.COMPLETE, LoadComplete );
            sound.load( new URLRequest(path), new SoundLoaderContext( 10, true ) );
            
            bytes = new ByteArray();
            _started = false;
        }
        
        private function LoadComplete(e:Event):void
        {
            e.target.removeEventListener( Event.COMPLETE, LoadComplete );
            Start();
        }
        
        private function Start():void
        {
            soundChannel = sound.play( 0, 1000 );
            _started = true;
        }
        
        public    function GetSpectrumData(FFTMode:Boolean = false) : Array
        {
            var i:int;
            var buf:Array = new Array(512);
            if ( !_started )
            {
                for ( i = 0; i < 512; i++ )    buf[i] = 0;
                return    buf;
            }
            
            SoundMixer.computeSpectrum( bytes, FFTMode, 0 );
            bytes.position = 0;
            for ( i = 0; i < 512; i++ )    buf[i] = bytes.readFloat();
            
            return    buf;
        }
        
    }
    
    class Particle
    {        
        private var _x:Number;
        private var _y:Number;
        public    function get x():Number { return    _x;    }
        public    function set x(val:Number) : void { _x = val;    }
        public    function get y():Number { return    _y;    }
        public    function set y(val:Number) : void { _y = val;    }
                
        private var _angle:Number;
        private var _rotPower:Number;
        public function get rotPower():Number { return    _rotPower;    }
        
        private var _alpha:Number;
        public function get alpha():Number { return    _alpha;    }
        
        public function Particle(angle:Number) 
        {            
            _angle = angle;
            _rotPower = 0;
            _alpha = 0;
        }
        
        public function Update(tx:Number, ty:Number, val:Number, angleRate:Number, tempRate:Number ) : void
        {    
            _alpha += val;
            _alpha *= 0.7;
            _rotPower += val + (tempRate * 3);
            _rotPower *= 0.7;
            
            _angle += _rotPower;
            _angle %= 360;
            var rad:Number = _angle * Math.PI / 180;
            _x = tx + Math.cos( rad ) * (angleRate * 200 + 20);
            _y = ty + Math.sin( rad ) * (angleRate * 200 + 20);
        }
        
    }
    