/**
 * Copyright ericyang ( http://wonderfl.net/user/ericyang )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wb4a
 */

// forked from ericyang's class ItemNode
package {
	import flash.display.Sprite;
	import flash.text.TextField;
	import gs.TweenLite;
	import gs.easing.Elastic;
	
	public class Main extends Sprite
	{
		function Main()
		{
			
			//This is all the initialization you need in your main class
            inittrace(stage);
			
			var text:TextField = new TextField();
			text.appendText("123");
			addChild(text);
			var node:ItemNode = new ItemNode();
			addChild(node);
			TweenLite.to(node, 2, {x:75, y:294, ease:Elastic.easeOut});
			text.text = node.label;
			
			var view:ToolsBarView = new ToolsBarView(null);
			addChild(view);
			view.Drawmenu();
			view.x = stage.stageWidth/2;
			view.y = stage.stageHeight/2;
		}	
	}

}

import flash.display.Sprite;
class ItemNode extends Sprite 
{
    		private var _parent:*;
    		private var _child:*;
    		private var _iconURL:String;
    		private var _label:String;
        public function ItemNode()
        {
            // write as3 code here..
            this.graphics.beginFill(0x20F5E7, 0.8);
            this.graphics.drawEllipse(0,0,50,50);
            this.graphics.endFill();
        }
        
         //
        	//// getter & setter of child
        	//
        public function get child():*
        {
        		return this._child==null ? null : this._child;
        	}
        	public function set child(c:*):void
        	{
        		if(c!=null)
        			this._child = c;
        	}
        	//
        	////
        	//
        	
        	
        	//
        	//// getter & setter of _parent
        	//
        public function get rgParent():*
        {
        		return this._parent==null ? null : this._parent;
        	}
        	public function set rgParent(p:*):void
        	{
        		if(p!=null)
        			this._parent = p;
        	}
        	//
        	////
        	//
        	
        	//
        	//// getter & setter of _icon
        	//
        public function get sIconURL():*
        {
        		return this._iconURL!=null ? this._iconURL : "1.swf";
        	}
        	public function set sIconURL(s:*):void
        	{
        		if(s!=null)
        			this._iconURL = s;
        	}
        	//
        	////
        	//
      
        	//// getter & setter of _label
        	//
        public function get label():String
        {
        		return this._label!=null ? this._label: "1.swf";
        	}
        	public function set label(s:*):void
        	{
        		if(s!=null)
        			this._label = s;
        	}
        	//
        	////
        	//      
        	
        	//
        	//// set bgColor
        	//
        	public function set bgColor(color:uint):void
        	{
        		this.graphics.beginFill(color, 0.8);
            this.graphics.drawEllipse(0,0,50,50);
            this.graphics.endFill();
        	}
        	//
        	////
        	//  	
}

//
//// Stack
//
class Stack
{
	private var _data:Array;
	function Stack()
	{
		_data  = new Array();
	}
	public function pop():*
	{
		return _data.pop();
	}
	public function push(d:*):void
	{
		if(d!=null)
			_data.push(d);
	}
	public function isEmpty():Boolean
	{
		return this._data[0]==null;
	}
	public function top():*
	{
		if(!isEmpty())
			return _data[_data.length-1];
		else 
			return null;
	}
}

//
//// ToolsBarModel
//
import flash.events.EventDispatcher;
class ToolsBarModel extends EventDispatcher
{
		private var _background:Sprite;
		private var _nodes:Array;
		private var _menuStack:Stack;
		
		function ToolsBarModel()
		{
			this._background = new Sprite();
			this._nodes = new Array();
			//this._node = new ItemNode();
			for(var i:int = 0; i<10; i++)
			{
				this._nodes.push(new ItemNode());
			}
			
			this._menuStack = new Stack();
			
			var rgArr:Array = new Array();
			
			for(i= 0; i<5; i++)
			{
				var n:ItemNode = new ItemNode();
				
				
				n.child = CreateChild(n);
				
				
				rgArr.push(n);
			}
			this._menuStack.push(rgArr);
		}
		//
		//// create child;
		//
		private function CreateChild(p:ItemNode):Array
		{
			if(p != null)
			{
					
					var a:Array = new Array()
					for(var j:int = 0; j<6; j++)
					{
						var n2:ItemNode = new ItemNode();
							
							n2.rgParent = p;
							a.push(n2);
					}
					return a;
			}
			return null;
		}
		
		
		//
		//// getter & setter of _background;
		//
		public function get bg():Sprite
		{
			return this._background;
		}
		public function set bg(sp:Sprite):void
		{
			if(sp!=null)
				this._background = sp;
		}
		//
		////
		//
		
		//
		//// getter & setter of _nodes:Array;
		//
		public function get rgNode():Array		
		{
			return this._nodes;
		}
		public function set rgNode(a:Array):void
		{
			if(a!=null)
				this._nodes = a;
		}
		//
		////
		//
		
		//
		//// getter & setter of _nodes:Array;
		//
		public function get menuStack():Stack		
		{
			return (this._menuStack==null ? new Stack : this._menuStack);
		}
		public function set menuStack(a:Stack):void
		{
			if(a!=null)
				this._menuStack = a;
		}
		//
		////
		//
}

//
//// ToolsBarModel
//
import gs.TweenLite;
import gs.easing.Elastic;
import flash.display.Sprite;
import flash.events.MouseEvent;
class ToolsBarView extends Sprite
{
	private var _model:ToolsBarModel = new ToolsBarModel();
	private const itemsPerPage:uint = 6;
	
	function ToolsBarView(
							m:ToolsBarModel
						)
	{
		if(m!=null)
			this._model = m;
	}
	
	public function Drawmenu():void
	{	
		var angel:Number = 360/_model.menuStack.top().length
		for(var i:int = 0 ; i< _model.menuStack.top().length; i++)
		{
			addChild(_model.menuStack.top()[i]);
			
			//var ia:Number = _model.menuStack.top()[i].rotation;
			_model.menuStack.top()[i].rotation = 0;			
			TweenLite.to(_model.menuStack.top()[i], 2, {rotation: -i*angel, ease:Elastic.easeOut});
			
			_model.menuStack.top()[i].addEventListener("click", clickHandler);
		}	
	}
	private function clickHandler(e:MouseEvent):void
	{
		//trace("child: " + e.currentTarget.child);
		trace("Click: " + e.currentTarget.label);
		if(e.currentTarget.child != null)
		{	
			//Clear Current Menu
			CleanItems();
		
			//Add Top button
			var n:ItemNode = new ItemNode();
			n.label = "Top";
			n.bgColor = 0xD9EB38;		
			e.currentTarget.child.splice(0, 0, n);
			
			
			//Add Next Button
			if(e.currentTarget.child.length > itemsPerPage)
			{
				n = new ItemNode();
				n.label = "Next";
				n.bgColor = 0x59F793;		
				e.currentTarget.child.push(n);
			}
			// some error in CleanItems();
			
			/*
			if(e.currentTarget.child.length >= (itemsPerPage-1))
			{
				//var n:ItemNode = new ItemNode();
				n.label = "Next";
				
				var tempArr:Array = new Array();
						
				tempArr = e.currentTarget.child.splice(0, itemsPerPage-1);
				
				n.child = e.currentTarget.child;
				
				tempArr.push(n);
				
				_model.menuStack.push(tempArr);
			}	
			else*/
				 _model.menuStack.push(e.currentTarget.child);

				 			
			Drawmenu();
		}
		else if(e.currentTarget.label == "Top")
		{
			trace("Click Pop");
			//Clear Current Menu
			
			//_model.menuStack.top().splice(0, 1);
			CleanItems();
			_model.menuStack.pop();
			
			//
			Drawmenu();
		}
	}
	private function CleanItems():void
	{
		if(_model.menuStack.top() != null)
		{
			for(var i:int = 0 ; i< _model.menuStack.top().length; i++)
			{
				_model.menuStack.top()[i].addEventListener("click", clickHandler);
				removeChild(_model.menuStack.top()[i]);			
				if(_model.menuStack.top()[i].label == "Top" || _model.menuStack.top()[i].label == "Next")
				{
					_model.menuStack.top().splice(i, 1);
				}
			}
		}
	}
	
}


/////  WONDERFL TRACE /////

import flash.display.Sprite;
import flash.display.Stage;
import flash.text.TextField;
import flash.text.TextFormat;

function inittrace(s:Stage):void
{
    WTrace.initTrace(s);
}

//global trace function
var trace:Function;

//wtreace class
class WTrace
{
        private static var FONT:String = "Fixedsys";
        private static var SIZE:Number = 12;
        private static var TextFields:Array = [];
        private static var trace_stage:Stage;
        
        public static function initTrace(stg:Stage):void
        {
            trace_stage = stg;
            trace = wtrace;
        }
        
        private static function scrollup():void
        {
            // maximum number of lines: 100
            if (TextFields.length > 100) 
            {
                var removeme:TextField = TextFields.shift();
                trace_stage.removeChild(removeme);
                removeme = null;
            }
            for(var x:Number=0;x<TextFields.length;x++)
            {
                (TextFields[x] as TextField).y -= SIZE*1.2;
            }
        }
    
        public static function wtrace(... args):void
        {
        
            var s:String="";
            var tracefield:TextField;
            
            for (var i:int;i < args.length;i++)
            {
                // imitating flash:
                // putting a space between the parameters
                if (i != 0) s+=" ";
                s+=args[i].toString();
            }
            

            tracefield= new TextField();
            tracefield.autoSize = "left";
            tracefield.text = s;
            tracefield.y = trace_stage.stageHeight - 20;

            var tf:TextFormat = new TextFormat(FONT, SIZE);
            tracefield.setTextFormat(tf);
            trace_stage.addChild(tracefield);
            scrollup();                      
            TextFields.push(tracefield);
            
        }
}



