/**
 * Copyright freddy ( http://wonderfl.net/user/freddy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/waIn
 */

package {
    import flash.events.Event;
    import flash.display.Shape;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            // write as3 code here..
            
            var sqrt3:Number = Math.sqrt(3);
            var th0:Number = Math.PI / 8;
            var r:Number = 50;
            var x:Number = r / (Math.cos(th0) + sqrt3 * Math.sin(th0));
            var z:Number = r - x;
            var R:Number = 2 * x * Math.cos(th0) / sqrt3;            
            var Rz:Number = R + z;
            var th:Number;
            var rr:Number;
            var xx:Number;
            var yy:Number;
            
            function create(inDot:Boolean, outDot:Boolean, rot:Number = 5):Sprite {
                var sp:Sprite = new Sprite();
                for (var j:int = 0; j < 3; j++) {
                    var sh:Shape = new Shape();
                    sh.graphics.lineStyle(10);
                    for (var i:int = 0; i <= 40; i++) {
                        th = i / 30 * Math.PI + th0;
                        rr = th < Math.PI - th0 ? r : z;
                        xx = th < Math.PI - th0 ? 0 : -sqrt3 / 2 * R;
                        yy = th < Math.PI - th0 ? -sqrt3 / 3 * r : -1/2 * R;
                        if (i == 0) {
                            sh.graphics.moveTo(Math.cos(th) * rr + xx, Math.sin(th) * rr + yy);
                        }
                        sh.graphics.lineTo(Math.cos(th) * rr + xx, Math.sin(th) * rr + yy);
                    }

                    sh.rotation = 120 * j;
                    sp.addChild(sh);
                }
                if (inDot) {
                    sh.graphics.lineStyle(0);
                    sh.graphics.beginFill(0xFFFFFF);
                    sh.graphics.drawCircle(0, -sqrt3 / 3 * r, 3);
                    sh.graphics.drawCircle(-1/2 * r, sqrt3 / 6 * r, 3);
                    sh.graphics.drawCircle(1/2 * r, sqrt3 / 6 * r, 3);
                    sh.graphics.endFill();
                }
                if (outDot) {
                    sh.graphics.lineStyle(0);
                    sh.graphics.beginFill(0xFFFFFF);
                    sh.graphics.drawCircle(sqrt3/2 * Rz, -1 / 2 * Rz, 3);
                    sh.graphics.drawCircle(-sqrt3/2 * Rz, -1 / 2 * Rz, 3);
                    sh.graphics.drawCircle(0, Rz, 3);
                    sh.graphics.endFill();
                }
                sp.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
                    sp.rotation += rot;
                });
                return sp;
            }
            
            var sp:Sprite;

            sp = create(true, false);
            sp.x = 120;
            sp.y = 120;
            addChild(sp);

            sp = create(false, false);
            sp.x = 240;
            sp.y = 240;
            addChild(sp);

            sp = create(false, false, 10);
            sp.x = 360;
            sp.y = 120;
            addChild(sp);

            sp = create(false, true);
            sp.x = 360;
            sp.y = 360;
            addChild(sp);

            sp = create(false, false, 20);
            sp.x = 120;
            sp.y = 360;
            addChild(sp);
        }
    }
}
