/**
 * Copyright qq49121294 ( http://wonderfl.net/user/qq49121294 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/waEp
 */

// forked from Faust7011's editor
package {
    import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        
        public var feuille:WorkSheet = new WorkSheet( 600, 600 );
        public var writer:PWriter = new PWriter();
        public var stock:FontLoader = new FontLoader();
        public var oneTime:Boolean = true;
        
        public function FlashTest() {
            
            feuille.addVector("Bonjour", 20, 20);
            
            addChild( stock.tracer2);
            addChild( stock.tracer1);
            
            stock.loadFont("DFMaruGothic-SB");
            
            addEventListener( Event.ENTER_FRAME, go );
            
        }
        
        public function go(e:Event):void {
            
            if (  oneTime ) {
                stock.tracer2.text = "エルフのベース |精靈基地描述ブレイ勇士パット水手マシュ小屋桃木簡易藁普通茅草海族民居1ピン中型ガラ高級敷キカ家タツムリハウナモオ瓦ドゴ鴕鳥船ア黄金ク帆ユニコ白馬隊ワェ号ォダテジャグ鉱物採取場石礦珊瑚集天裝飾花壇道橋魂灯台霊池展望デヤ槍塔太監視投サミ聖火礁墓旗群像１守りポチボ竹おヒ希貝祈かざぐるま古琴畑椅子箱街燈風賊ズ神多葉樹樽千年ザ柵左右誇２３外種漂流ビ４魔法陣メ５自然温泉幸せ象徴不死森ゲ緑福洗礼滝貴秘なセ噴堡藏兵洞プ酒ョS剤ネを回復でき様々所らGET可能。購入もML砂時計間早めことが生産、製造効果個/短縮休戦符優れ使用後決った部攻撃身分敵勲章にギ宝開け銀一定確率や色バロAPケ図破片０枚ど力％U炎放射鋭角連続反凶暴傷害半減強鉄防御避危機倍理へ移行弾驚異点弓重阻話衣碧玉ヘ遺跡見つ装備頭全体値ィ騎兜者氷獄武器訓練ァソペ銅ホ足獣靴嗜血軍團擊提升作3合狂閃衝方直接成損失進，滾焰有幾（0%）燒到己5陷阱會先禱每給加滿為止試錯誤発事上磨錬百質実剛健,獅奮迅王当意即妙勝利立断党略気軒昂術商才捲土来占領さ陽満創痍屍累髪指相壊滅殺覇鬼君征服東奔西走功揚大快人心運否賦刀光剣影暖乃仲救出誠等量斉仁義誓山盟期会貧困脱離達画賛得面堆積頂湯城日月歩格致新徳世界嶺６拓無我夢闊空晩九鼎呂南鵬翼８蟷螂斧十疾勁七転八起志操堅固雨過晴二三揃え専美四応内双践躬鼓堂宇壮願就念想至";
                if (!stock.getL()) {
                    addChild( writer.write( stock, feuille) );
                    stock.tracer2.text = "Done";
                    oneTime = false;
                }
            }
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.geom.Matrix;

class PWriter {
    public function write ( stock:FontLoader, doc:WorkSheet ):Bitmap {
        
        var phrase:LVector = doc.texts[0];
        
        var availWidth:Number = doc.widthFrom( phrase.x );
        var availHeight:Number = doc.heightFrom( phrase.y );
        
        var maxWidth:Number = 50;
        var maxHeight:Number = 50;
        
        var spacing:Number = 5;
        
        var chars:Array = new Array();
        var progressImage:BitmapData = new BitmapData(availWidth, availHeight, true, 0x88FFFFF0);
        
        var lineW:Number = 0;
        var translation:Matrix = new Matrix();
        
        
        for ( var i:int = 0; i < phrase.text.length; i++ ) {
            
            var currentChar:String = phrase.text.charAt(i);
            var currentImage:Bitmap = stock.getChar( phrase.text.charAt(i), phrase.fontFamily );
            progressImage.draw( currentImage, translation );
            translation.translate( currentImage.width+10, 0 );
            
        }
        
        return new Bitmap( progressImage );
        
    }
}


// |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
// || Class WorkSheet. Defines a sheet with multiples LVector ||
// |||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

class WorkSheet {
    
    private var normal:Boolean = true; // Mode normal ou paysage
    
    public var width:Number; // L x H ...
    public var height:Number;
    
    private var defaultFontFamily:String = "Gothique";
    private var defaultFontSize:int = 12;
    private var defaultFontColor:Number = 0x000000;
    
    // Marges sur les bords : Haut, bas, gauche, droite
    private var pageBorder:Array = new Array (4, 3, 3, 3);
    
    // LVector, Borders, Adds
    public var texts:Array = new Array();
    public var borders:Array = new Array();
    public var adds:Array = new Array();
    
    public function WorkSheet (
    newWidth:Number = 21, 
    newHeight:Number = 29.7
    ) {
        width = newWidth;
        height = newHeight;
    }
    
    public function widthFrom( x:Number ):Number {
        return ( width - x - pageBorder[3] );
    }
    
    public function heightFrom( y:Number ):Number {
        return ( height - y - pageBorder[1] );
    }
    
    public function setPageBorder ( args:* ):void {
        if ( args.length == 4 )
            pageBorder = args;
        else if ( args.length == 1 )
            pageBorder = new Array( args, args, args, args );
    }
    
    // Sens params AS : ( text, x, y [, font, color, size ] )
    public function addVector (
    text:String, 
    x:Number,
    y:Number,
    ...args
    ):void {
        if ( text != "" ) {
            
            var font:String = defaultFontFamily;
            var color:Number = defaultFontColor;
            var size:int = defaultFontSize;
            
            if ( args.length > 0 )
                font = args[0];
            if ( args.length > 1 )
                color = args[1];
            if ( args.length > 2 )
                size = args[2];
            
            // text, ArrayXY, font, color, size
            texts[texts.length] 
            = new LVector( text, new Array(x, y), font, color, size );
        }
    }
    
    
}

// ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
// |||||||| Class FontLoader. Loads and creates fonts |||||||||
// ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

import flash.text.*;

class FontLoader {
    
    private var loader:Loader = new Loader();

    private var imageIndex:Number = 0;
    private var fontIndex:Number = 0;

    private var address:String = "a;an;b;bn;c;cn;d;dn;e;en;"
        + "f;fn;g;gn;h;hn;i;in;j;in;k;kn;"
    + "l;ln;m;mn;n;nn;o;on;p;pn;q;qn;r;rn;"
        + "s;sn;t;tn;u;un;v;vn;x;xn;y;yn;z;zn;"
    + "A;aj;B;bj;C;cj;D;dj;E;ej;F;fj;G;gj;"
    + "H;hj;I;ij;J;ij;K;kj;L;lj;M;mj;N;nj;O;oj;"
    + "P;pj;Q;qj;R;rj;S;sj;T;tj;U;uj;V;vj;X;xj;Y;yj;Z;zj";
    

        //private var ext:String = ".jpg";
        private var ext:String = ".png?";
    private var fonts:Array = new Array();
    private static var isLoading:Boolean = false;

        public var tracer1:TextField = new TextField();
        public var tracer2:TextField = new TextField();
        private var defaultTextFormat:TextFormat = new TextFormat();
    
    
        public function FontLoader () {
                    tracer1.x = 0;
                    tracer1.y = 20;
                    tracer1.width = 400;
                    tracer1.border = true;
                    tracer1.autoSize = TextFieldAutoSize.LEFT;
                    tracer1.wordWrap = true;
                    defaultTextFormat.size = 15;
                    tracer1.defaultTextFormat = defaultTextFormat;
                    
                    tracer2.x = 0;
                    tracer2.y = 75;
                    tracer2.width = 400;
                    tracer2.border = true;
                    tracer2.autoSize = TextFieldAutoSize.LEFT;
                    tracer2.wordWrap = true;
                    tracer2.defaultTextFormat = defaultTextFormat;
                    
        }
        
        public function getL():Boolean {
            return isLoading;
        }
        
    public function getFonts ():Array {
        return fonts[0];
    }
    
    public function getChar ( 
        char:String, 
        fontName:String ) :Bitmap {
        
        var tempIndex:Number = fonts[0].indexOf( fontName );
        if ( tempIndex == -1 ) 
            return new Bitmap();
        for ( var i:Number = 0; 
                i < fonts[1][tempIndex].length; 
                i++ ) {
            if ( fonts[1][tempIndex][i][0] == char ) {
                return fonts[1][tempIndex][i][2];
            }
        }
        
        return new Bitmap();
    }
    
    public function loadFont( fontName:String ):void {
                    if ( fonts.length == 0)
                        createFont(fontName);
                    
                    if (fonts[0].length == 0){
                        createFont(fontName);
                    }
                    
                    fontIndex = fonts[0].indexOf(fontName);
                    imageIndex = 0;
                    loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
                    isLoading = true;
                    loadArray();
    }
                     
    private function loadArray():void {
        if ( fontIndex < fonts[1].length ) {
             if ( imageIndex < fonts[1][fontIndex].length ) {
    
                  var url:String = fonts[0][fontIndex] + "/"+ 
                                  fonts[1][fontIndex][imageIndex][1];
                                  

                  loader.load( new URLRequest( url ) );
                                  tracer2.text = url ;
             }
             else {
                  loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onComplete);
                  isLoading = false;
             }
        }
    }    
                 

    private function onComplete(event:Event):void {
    
                        tracer1.appendText(fonts[1][fontIndex][imageIndex][0]);
        
                        var loaderInfo:LoaderInfo = event.currentTarget as LoaderInfo;
            var _loader:Loader = loaderInfo.loader; 
            var bmp:BitmapData = new BitmapData(_loader.width, _loader.height, true, 0x00000000);
                        bmp.draw(_loader);
                        
            fonts[1][fontIndex][imageIndex][2] = new Bitmap(bmp);
                        
                        imageIndex++;
                        loadArray();
    }
    
    
                 
    public function createFont(fontFamily:String):void {
    
        if ( fonts[0] == undefined )
            fonts[0] = new Array();
        if ( fonts[1] == undefined )
            fonts[1] = new Array();
             
        var newIndex:Number = fonts[1].length;
        
        fonts[0][ fonts[0].length ] = fontFamily;
        fonts[1][ newIndex ] = new Array();
        
        var temp:Array = address.split(";");
        
        for ( var i:Number = 0; i < temp.length; i+=2 ) {
            var ct:Number = i / 2;
            fonts[1][ newIndex ][ ct ] = new Array()
            fonts[1][ newIndex ][ ct ][0] = temp[i];
            fonts[1][ newIndex ][ ct ][1] = temp[i + 1] + ext;
            fonts[1][ newIndex ][ ct ][2] = new Bitmap();
        }
    }
}

// ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
// |||||||| Class LVector. Defines letters' vectors |||||||||||
// ||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||

class LVector {
    
    public var x:Number = 0;
    public var y:Number = 0;
    
    public var fontFamily:String;
    public var fontColor:Number;
    public var fontSize:Number;
    
    public var text:String;
    
    public function LVector (...args) {
        if (args.length == 1) {
            text = args[0];
            x = 0; y = 0; 
            fontFamily = "Gothique"; 
            fontColor = 0x000000;
            fontSize = 15;
        } 
        if (args.length == 2 ) {
            text = args[0];
            x = args[1][0];
            y = args[1][1];
            fontFamily = "Gothique"; 
            fontColor = 0x000000;
            fontSize = 15;
        }
        if (args.length == 5 ) {
            text = args[0];
            x = args[1][0];
            y = args[1][1];
            fontFamily = args[2];
            fontColor = args[3];
            fontSize = args[4];
        }
    }
    public function setFont ( newFont:String ):void {
        fontFamily = newFont;
    }
    public function setColor ( newColor:Number ):void {
        fontColor = newColor;
    }
    public function setSize ( newSize:Number ):void {
        fontSize = newSize;
    }
    public function setText ( newText:String ):void {
        text = newText
    }
    
    public function removeCharAt ( charPos:Number ):void {
        var tLen:Number = text.length;
        if ( charPos < tLen && charPos >= 0 ) {
            text = text.substring( 0, charPos ) + text.substring( charPos+1, tLen );
        }
    }
    
    public function addTextAt ( charPos:Number, char:String ):void {
        var tLen:Number = text.length;
        if ( charPos < tLen && charPos >= 0 ) {
            text = text.substring( 0, charPos ) + char + text.substring( charPos+1, tLen );
        }
    }
}