/**
 * Copyright ntaka206 ( http://wonderfl.net/user/ntaka206 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wa7V
 */

// forked from miyaoka's Melting
package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	import flash.net.*;
	import flash.system.LoaderContext;
	import caurina.transitions.Tweener;
	import flash.utils.Timer;
	
	[SWF(width = "465", height = "465", backgroundColor = 0xFFFFFF, frameRate = "60")]
	
	public class Melt
	extends Sprite
	{
		private var bmd:BitmapData;
		private var pipesURL:String = "http://pipes.yahooapis.com/pipes/pipe.run?_id=Tkmh9Xn63RGd9RQo37Vd_w&_render=rss&num=30&q=kamikouchi";
		private var urls:Array = [];


		private var index:int = 0;

		public function Melt() 
		{
			//bg
			graphics.beginFill(0x0);
			graphics.drawRect(0, 0, SW, SH);

Wonderfl.capture_delay( 9 );
			
			//bmd
			bmd = new BitmapData(SW, SH, true, 0);
			addChild(new Bitmap(bmd));

			//rss
			var loader:URLLoader = new URLLoader();
			loader.dataFormat = URLLoaderDataFormat.TEXT;
			loader.addEventListener(Event.COMPLETE, loadListCompleteHandler);
			loader.load(new URLRequest(pipesURL));
		}
		private function loadListCompleteHandler(e:Event):void 
		{
			var loader:URLLoader = e.target as URLLoader;
			loader.removeEventListener(Event.COMPLETE, loadListCompleteHandler);
			var list:XML = new XML(loader.data);
			default xml namespace = media;
			for each(var element:Object in list..item)
			{
				urls.push(String(element.media::group.media::content.@url).replace("http://", "http://farm" + element.media::group.@farm + ".").replace("_m", ""));
			}
			loadNext();
			var timer:Timer = new Timer(4000);
			timer.addEventListener(TimerEvent.TIMER, function ():void 
			{
				loadNext();
			});
			timer.start();
		}
		private function loadNext():void 
		{
			var loader:Loader = new Loader();
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadCompleteHandler);  
			index = (index + 1 + (urls.length - 1) * Math.random()) % urls.length;
			loader.load(new URLRequest(urls[index]), new LoaderContext(true));
		}
		private function loadCompleteHandler(e:Event):void 
		{
			e.target.removeEventListener(Event.COMPLETE, loadCompleteHandler);
			var bmp:Bitmap = e.target.loader.content as Bitmap;
			addChild(bmp);
//			bmp.scaleX = bmp.scaleY = 1.8;
			bmp.x = (SW - bmp.width ) * Math.random();
			
			//height*2 bmd
			var bmd2:BitmapData = new BitmapData(bmp.bitmapData.width, bmp.bitmapData.height * 2, true, 0);
			bmd2.draw(bmp.bitmapData);
			bmp.bitmapData = bmd2;
			
			//perlin
			var noise:BitmapData = new BitmapData(bmp.width, bmp.height, true, 0);
			noise.perlinNoise(noise.width* (Math.random()*0.1+0.1), noise.height* (Math.random()*0.5 +0.5) , 1, Math.random()*int.MAX_VALUE, false, false);
			
			bmp.y = -height;
			bmp.alpha = 0.8;
			Tweener.addTween(bmp, {
				y: 0,
				time: 2.0,
				onComplete: function ():void 
				{
					Tweener.addTween(bmp, {
						y: SH * (0.5 + Math.random() * 0.3),
						time: Math.random() * 0.0 + 5.0,
						alpha:1.0,
						transition: "easeInOutCubic",
						onUpdate: function ():void 
						{
							bmp.filters = [
								new DisplacementMapFilter(noise, null, 1, 1, 0, bmp.y*2, DisplacementMapFilterMode.COLOR)
							]					
						},
						onComplete: function ():void 
						{
							var mtx:Matrix = new Matrix();
							mtx.translate(bmp.x/bmp.scaleX, bmp.y/bmp.scaleY);
							mtx.scale(bmp.scaleX, bmp.scaleY);
							bmd.draw(bmp, mtx, null);
							removeChild(bmp);
							bmp = null;
						}
					});
				}
			});
		}
	}	
}
var SW:Number = 465;
var SH:Number = 465;
var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");

