/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wZgh
 */

package
{
	import flash.display.Scene;
	import flash.events.Event;
	
	import org.papervision3d.materials.BitmapFileMaterial;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	
	[SWF(backgroundColor="0x000000")]
	public class PlatesRotated extends BasicView
	{
		private var wrap:DisplayObject3D;
		
		public function PlatesRotated() 
		{
			var fileArray :Array = [
				// ダミーの画像url。これが無いとwonderfl上ではイメージが何故か表示されない。
				"http://1assets.wonderfl.net/images/related_images/6/64/6474/64740d580bd0cb78a13d0d2e0ffc1fdbefcf5851",
				"http://assets.wonderfl.net/images/related_images/6/64/6474/64740d580bd0cb78a13d0d2e0ffc1fdbefcf5851",
				"http://assets.wonderfl.net/images/related_images/3/35/35b3/35b33283e0fd38fe3dbfa3785984d80b0f8fb27b",
				"http://assets.wonderfl.net/images/related_images/4/4e/4efe/4efe7a54be952cd5ed9b47a5e1d2bf5a42f922ec",
				"http://assets.wonderfl.net/images/related_images/1/1f/1f44/1f448bcdd41fb3b4367eb5c58c4fd911ca34137a",
				"http://assets.wonderfl.net/images/related_images/a/a9/a94a/a94ae401cbb1edb37df1135d1c149a7214a81a9f",
				"http://assets.wonderfl.net/images/related_images/6/60/608b/608be8901a07a1285bf2275bea764914e1ac9157",
				"http://assets.wonderfl.net/images/related_images/d/d6/d6f4/d6f42ba245422e56312b24cf13ebb6c0661377d8",
				"http://assets.wonderfl.net/images/related_images/4/42/4224/42240f07b166ba8e230cedda17fb446a0d0cf1a8",
				"http://assets.wonderfl.net/images/related_images/6/62/6229/62293a35b6033e0b2316286dfd8390187c6856af",
			];
			
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			
			var materialArray:Array = [];
			var bfm:BitmapFileMaterial;
			for (var j:int = 0; j < fileArray.length; j++) {
				bfm = new BitmapFileMaterial(fileArray[j], true);
				bfm.checkPolicyFile = true;
				materialArray.push(bfm);
			}
			// ダミーで読み込んだ画像を削除
			materialArray.shift();
			
			var len:int = materialArray.length;
			for (var i:int = 0; i < len; i++) {
				
				materialArray[i].doubleSided = true;
				
				var obj:Plane;
				// 最後の2枚は縦長
				if (i == len - 1 || i == len - 2) {
					obj = new Plane(materialArray[i], 332/2, 500/2);
				}
				else {
					obj = new Plane(materialArray[i], 500/2, 332/2);	
				}
				
				var rot:Number = 360 * (i / len -1 );
				
				obj.x = 600 * Math.sin(rot * Math.PI / 180);
				obj.z = 600 * Math.cos(rot * Math.PI / 180);
				obj.lookAt(DisplayObject3D.ZERO);
				
				wrap.addChild(obj);
			}
			
			startRendering();
			addEventListener(Event.ENTER_FRAME, loop);
		}
		
		private function loop(e:Event):void {
			wrap.rotationY += 1.1;
		}
	}
}