/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wZAP
 */

// forked from o8que's ミニチャット 素材
package {
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import net.wonderfl.utils.WonderflAPI;
    import flash.net.*;
    import flash.media.*;
    
    [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "0xFFFFFF")]
    // swfのURL "http://swf.wonderfl.net/swf/usercode/3/33/33b6/33b67f478ec4b4a6dc963e096c32535e4f1786ad.swf"
    public class Main extends Sprite {
        
        public function Main() {
            if (stage) { demo(); }
        } 
        
        /**
         * ミニチャットウインドウを作成します。表示リストに追加されているかどうかで、自動的に接続・切断を行います。
         * @param    roomID チャットルームのIDです。他と被らないような名前を設定して下さい。
         * @param    args   任意で指定する引数です。         
         *      "logSize"            表示するメッセージの数を指定します。初期値は5です。指定数に応じて、ウインドウの高さが調整されます。
         *      "title"              上部ステータスバーの文字を指定します。初期値は"現在の閲覧者数"です。
         *      "textColor"          上部ステータスバーの文字の色を指定します。
         *      "backgroundColor"    上部ステータスバーの背景の色を指定します。
         *      "defaultUserName"    デフォルトの参加者の名前を指定します。指定しない場合、"名無し"または前回参加時の名前になります。
         *      "initiallyMinimized" 最初に最小化された状態にするかどうかを指定します。初期値はfalseです。
         *      "draggable"          ドラッグ可能にするかどうかを指定します。初期値はtrueです。
         *      "minimizable"        最小化可能にするかどうかを指定します。初期値はtrueです。falseの場合、最小化ボタンは表示されません。
         *      "renamable"          名前変更可能にするかどうかを指定します。初期値はtrueです。falseの場合、名前入力欄は表示されません。
         *      "reactor"            メッセージ通信に、指定したReactorを使用するようにします。指定した場合、自動的な接続・切断は無効になります。
         * @return    作成されたミニチャットウインドウを返します。
         */
        public function createMiniChat(roomID:String, args:Object = null):DisplayObject {
            return new MiniChat(roomID, args);
        }
        
        private function demo():void {
            //var roomID:String = "wonderfl.net." + String(new WonderflAPI(root.loaderInfo.parameters).appID) + ".chatroom";
            var roomID:String = "test";
            var minichat:MiniChat = new MiniChat(roomID);
            minichat.x = (465 - minichat.width) / 2;
            minichat.y = (465 - minichat.height) / 2;
            addChild(minichat);
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0,0,400,400);
            graphics.endFill();
        
        }
        
    }
}
/* ------------------------------------------------------------------------------------------------
 * MiniChat
 * ------------------------------------------------------------------------------------------------
 */
//package {
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.net.*;
    import flash.media.*;
    import flash.text.*;
    import flash.ui.Keyboard;
    import net.user1.logger.Logger;
    import net.user1.reactor.IClient;
    import net.user1.reactor.Reactor;
    import net.user1.reactor.ReactorEvent;
    import net.user1.reactor.Room;
    import net.user1.reactor.RoomEvent;
    import net.user1.reactor.UpdateLevels;
    
    //public 
    class MiniChat extends Sprite {
        private var _so:SharedObject;
        private var _isReactorShared:Boolean;
        private var _reactor:Reactor;
        private var _roomID:String;
        private var _room:Room;
        private var _messageLogSize:int;
        private var _messages:Vector.<String>;
        // ステータスバー
        private var _title:String;
        private var _statusBar:TextField;
        private var _minimizeButton:PushButton;
        // ウインドウ
        private var _window:Sprite;
        private var _messageDisplay:TextField;
        private var _nameInput:TextField;
        private var _messageInput:TextField;
        
        private var color1:uint = 0x00aaff;
        
        public function MiniChat(roomID:String, args:Object = null) {
            var now:Date = new Date();
            updateTime = now.getTime();
            
            _so = SharedObject.getLocal("MiniChat");
            if (!_so.data.name) { _so.data.name = "名無し"; }
            
            if (!args) { args = { }; }
            var logSize:int = ("logSize" in args) ? args["logSize"] : 10;
            var textColor:uint = ("textColor" in args) ? args["textColor"] : 0xFFFFFF;
            var backgroundColor:uint = ("backgroundColor" in args) ? args["backgroundColor"] : 0x404040;
            var defaultUserName:String = ("defaultUserName" in args) ? args["defaultUserName"] : _so.data.name;
            var initiallyMinimized:Boolean = ("initiallyMinimized" in args) ? args["initiallyMinimized"] : false;
            var draggable:Boolean = ("draggable" in args) ? args["draggable"] : true;
            var minimizable:Boolean = ("minimizable" in args) ? args["minimizable"] : true;
            var renamable:Boolean = ("renamable" in args) ? args["renamable"] : true;
            
            _isReactorShared = ("reactor" in args) ? true : false;
            _reactor = (_isReactorShared) ? args["reactor"] : new Reactor();
            _roomID = roomID;
            _messageLogSize = Math.max(1, logSize);
            _messages = new Vector.<String>();
            _title = ("title" in args) ? args["title"] : "現在の閲覧者数";
            //_title = _roomID;
            // MinimalcompsのStyleを一時保存してから変更する
            var tempEmbedFonts:Boolean = Style.embedFonts;
            var tempFontName:String = Style.fontName;
            var tempFontSize:Number = Style.fontSize;
            Style.embedFonts = false;
            Style.fontName = "_sans";
            Style.fontSize = 12;
            
            // UIの作成
            addChild(_statusBar = createStatusBar(draggable, textColor, backgroundColor));
            
            _messageDisplay = createMessageDisplay(logSize);
            _window = createWindow(_messageDisplay.height);
            addChild(_window);
            _window.addChild(_messageDisplay);
            _nameInput = createInputText(0, _window.height - 40, 60, 8, defaultUserName);
            if (renamable) {
                _window.addChild(_nameInput);
                _window.addChild(_messageInput = createInputText(60, _nameInput.y, 170, 50, ""));
            }else {
                _window.addChild(createSayLabel(_window.height - 19));
                _window.addChild(_messageInput = createInputText(31, _window.height - 19, 200, 50, ""));
            }
            _messageInput.addEventListener(KeyboardEvent.KEY_DOWN, sendMessage);
            // MinimalcompsのStyleを元に戻す
            Style.embedFonts = tempEmbedFonts;
            Style.fontName = tempFontName;
            Style.fontSize = tempFontSize;
            if (minimizable) { addChild(_minimizeButton = createMinimizeButton()); }
            if (initiallyMinimized) { minimize(); }
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            addEventListener(Event.REMOVED_FROM_STAGE, removedFromStageHandler);
        }
        
        //ステータスバー
        private function createStatusBar(draggable:Boolean, textColor:uint, backgroundColor:uint):TextField {
            var result:TextField = new TextField();
            result.width = 232; result.height = 20;
            var format:TextFormat = new TextFormat("_sans", 10, color1);
            format.align = TextFormatAlign.CENTER;
            result.defaultTextFormat = format;
            //result.background = true; result.backgroundColor = backgroundColor;
            result.filters = [new BevelFilter(1, 45, 0xFFFFFF, 0.8, 0x000000, 0.8, 1, 1)];
            result.mouseEnabled = result.selectable = false;
            if (draggable) {
                result.mouseEnabled = true;
                result.addEventListener(MouseEvent.MOUSE_DOWN, startDragHandler);
                result.addEventListener(MouseEvent.MOUSE_UP, stopDragHandler);
            }
            return result;
        }
        private function startDragHandler(event:MouseEvent):void { startDrag(); }
        private function stopDragHandler(event:MouseEvent):void { stopDrag(); }
        
        //最小化ボタン
        private function createMinimizeButton():PushButton {
            var result:PushButton = new PushButton(null, 215, 3, "-", minimize);
            result.width = result.height = 14; result.draw();
            return result;
        }
        
        //ウィンドウ
        private function createWindow(messageDisplayHeight:int):Sprite {
            var result:Sprite = new Sprite();
            result.y = 20;
            result.graphics.beginFill(0x000080, 0.1);
            result.graphics.drawRect(0, 0, 232, messageDisplayHeight + 20);
            result.graphics.endFill();
            var glow:Shape = new Shape();
            glow.graphics.beginFill(0x0);
            glow.graphics.drawRect(0,-20,232,messageDisplayHeight + 40);
            glow.graphics.endFill();
            glow.filters = [new GlowFilter(color1, 0.5, 2, 1, 5, 8, false, true)];
            result.addChild(glow);
            
            result.mouseEnabled = true;
            result.addEventListener(MouseEvent.MOUSE_DOWN, startDragHandler);
            result.addEventListener(MouseEvent.MOUSE_UP, stopDragHandler);

            return result;
        }
        
        //メッセージ欄
        private function createMessageDisplay(logSize:int):TextField {
            var result:TextField = new TextField();
            result.width = 232;
            result.defaultTextFormat = new TextFormat("_sans", 12, color1);
            result.filters = [new DropShadowFilter(0, 0, 0x000055, 3,3,2,2)];
            result.mouseEnabled = result.selectable = false;
            result.wordWrap = true;
            for (var i:int = 0; i < logSize; i++) { result.appendText(i + "\n"); }
            result.height = result.textHeight + 4; result.text = "";
            return result;
        }
        //入力ボックス
        private function createInputText(x:int, y:int, width:int, maxChars:int, text:String):TextField {
            var result:TextField = new TextField();
            result.x = x; result.y = y;
            result.width = width; result.height = 18;
            result.defaultTextFormat = new TextFormat("_sans", 10, 0x00aaff);
            //result.background = true; result.backgroundColor = 0x0033aa;
            result.border = true;result.borderColor=0x00aaff;
            result.filters = [new BevelFilter(1, 225, 0xC0C0C0, 1, 0x404040, 1, 1, 1)];
            result.maxChars = maxChars;
            result.selectable = true;
            result.type = TextFieldType.INPUT;
            result.text = text;
            return result;
        }
        
        private function createSayLabel(y:int):TextField {
            var result:TextField = new TextField();
            result.x = 1; result.y = y;
            result.width = 30; result.height = 18;
            result.defaultTextFormat = new TextFormat("_sans", 10, 0xFFFFFF, null, null, null, null, null, TextFormatAlign.CENTER);
            result.filters = [new GlowFilter(0x000000, 1, 2, 2)];
            result.mouseEnabled = result.selectable = false;
            result.text = "発言:";
            return result;
        }
        
        private function addedToStageHandler(event:Event):void {
            _reactor.addEventListener(ReactorEvent.READY, joinRoom);
            _reactor.addEventListener(ReactorEvent.CLOSE, leaveRoom);
            leaveRoom();
            
            if (_isReactorShared) {
                if (_reactor.isReady()) { joinRoom(); }
            } else {
                _reactor.getConnectionMonitor().setAutoReconnectFrequency(5000);
                _reactor.getLog().setLevel(Logger.FATAL);
                _reactor.connect("ozworks.dip.jp", 9100);
            }
        }
        
        private function removedFromStageHandler(event:Event):void {
            _reactor.removeEventListener(ReactorEvent.READY, joinRoom);
            _reactor.removeEventListener(ReactorEvent.CLOSE, leaveRoom);
            leaveRoom();
            
            if (!_isReactorShared) { _reactor.disconnect(); }
        }
        
        private function joinRoom(event:ReactorEvent = null):void {
            var updateLevels:UpdateLevels = new UpdateLevels();
            updateLevels.clearAll();
            updateLevels.occupantCount = updateLevels.roomMessages = true;
            
            _room = _reactor.getRoomManager().createRoom(_roomID);
            roomOccupantCountHandler();
            _room.addEventListener(RoomEvent.OCCUPANT_COUNT, roomOccupantCountHandler);
            _room.addMessageListener("CHAT_MESSAGE", receiveMessage);
            _room.join(null, updateLevels);
            
        }
        
        private function roomOccupantCountHandler(event:RoomEvent = null):void {
            _statusBar.text = _title + " " + _room.getNumOccupants() + "人";
            alart1();
        }
        
        private function leaveRoom(event:ReactorEvent = null):void {
            if (_room) {
                _room.removeEventListener(RoomEvent.OCCUPANT_COUNT, roomOccupantCountHandler);
                _room.removeMessageListener("CHAT_MESSAGE", receiveMessage);
                _room.leave();
            }
            
            _statusBar.text = "サーバーに接続中...";
        }
        
        //メッセージ送信
        private function sendMessage(event:KeyboardEvent):void {
            
            var now:Date = new Date();
            updateTime = now.getTime();
            
            if (!_reactor.isReady() || event.keyCode != Keyboard.ENTER || _messageInput.text == "") { return; }
            _room.sendMessage("CHAT_MESSAGE", true, null, _nameInput.text, _messageInput.text);
            _so.data.name = _nameInput.text;
            _messageInput.text = "";
        }
        
        //メッセージ受信
        private function receiveMessage(from:IClient, senderName:String, messageText:String):void {
            _messages.push(senderName + ": " + messageText);
            if (_messages.length > _messageLogSize) { _messages.shift(); }
            
            _messageDisplay.text = "";
            var messagesLength:int = _messages.length;
            for (var i:int = 0; i < messagesLength; i++) {
                _messageDisplay.appendText(_messages[i] + "\n");
            }
            
            alart1();
        }
        
        private function minimize(event:MouseEvent = null):void {
            _window.visible = !_window.visible;
            if (_minimizeButton) { _minimizeButton.label = (_window.visible) ? "-" : "+"; }
        }
        
        
        private function alart1():void{
            var now:Date = new Date();
            if(updateTime+1000*120 < now.getTime()){
                playSnd("http://ozworks.dip.jp/sound/l.mp3");
                updateTime = now.getTime();
            }
        }

        private var updateTime:Number;
        private var sndList:Array = new Array();
        private function playSnd(url:String):void{
            if(sndList[url]==null){
                var req:URLRequest = new URLRequest(url)
                var sound:Sound = new Sound(req);
                sndList[url]=sound;
            }
            sndList[url].play();
        }
    }
//}