/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wXo0
 */

// forked from clockmaker's [Performance Test] trace vs LocalConnection
// forked from uwi's uint vs int
// muta244のツールキットを借り
package {

import flash.display.*;
import flash.geom.*;
import flash.events.*;
import flash.text.*;
import flash.utils.*;
import flash.net.*;
import flash.system.*;
import jp.progression.commands.*;
import jp.progression.commands.lists.*;
import org.libspark.thread.Thread;
import org.libspark.thread.EnterFrameThreadExecutor;
import org.libspark.thread.utils.*;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.tweens.ITween;

public class Main extends Sprite
{
    static private const _NUM_TIMES:uint = 100;
    
    private function _init():void
    {
        _debug(
            "各テスト " + _NUM_TIMES + " 回処理させた計算結果 [単位 ： ミリ秒]\n" +
            "(誤差は多少生じます)\n\n" +
            "Player Version : " + Capabilities.version + "\n" + 
            "Debug Player : " + Capabilities.isDebugger + "\n"
        );
        
        
        _debug("結果については言及しませんので, 各自ご判断ください.\n\n");
        
        //var func:Function = trace;
        var func:Function = function(num:int):void{};
        
        // Progression
        var pTime:Number = getTimer();
        var serialList:SerialList = new SerialList();
        for (var i:int = _NUM_TIMES - 1; i >= 0; i--) {
            serialList.addCommand(new Func(func, [i]));
        }
        serialList.addCommand(function():void{
            _debug("[Progression Command] " + (getTimer() - pTime) + "ms");
        });
        serialList.execute();
        
        // Thread
        if (!Thread.isReady) {
            Thread.initialize(new EnterFrameThreadExecutor());
        }
        
        var tTime:Number = getTimer();
        var serialTread:SerialExecutor = new SerialExecutor();
        for (i = _NUM_TIMES - 1; i >= 0; i--) {
            serialTread.addThread(new FuncThread(func, [i]));
        }
        serialTread.addThread(new FuncThread(function():void{
            _debug("[Thread Library] " + (getTimer() - tTime) + "ms");
        }));
        serialTread.start();
        
        // BetweenAS3
        var bTime:Number = getTimer();
        var bArr:Array = [];
        for (i = _NUM_TIMES - 1; i >= 0; i--) {
            bArr[i] = BetweenAS3.func(func, [i]);
        }
        bArr.push(BetweenAS3.func(function():void{
            _debug("[BetweenAS3] " + (getTimer() - bTime) + "ms");
        }
        ));
        var tw:ITween = BetweenAS3.serialTweens(bArr);
        tw.play();
        
        // Native
        var nTime:Number = getTimer();
        for (i = _NUM_TIMES - 1; i >= 0; i--) {
            func(i);
        }
        _debug("[None] " + (getTimer() - nTime) + "ms");
    }
    
    private var _field:TextField;
    private var _time:uint;
    
    public function Main():void
    {
        _setup();
        _init();
    }
    
    private function _measure(title:String, func:Function, ...params):void
    {
        _time = getTimer();
        func.apply(null, params);
        _time = getTimer() - _time;
        
        _debug("[ " + title + " ] --> " + _time + " ms");
    }
    
    private function _debug(log:String):void
    {
        _field.appendText(log + "\n");
    }
    
    private function _setup():void
    {
        _field = new TextField();
        _field.width = stage.stageWidth - 40;
        _field.height = stage.stageHeight - 60;
        _field.x = 20;
        _field.y = 60;
        _field.multiline = true;
        _field.wordWrap = true;
        
        var format:TextFormat = _field.defaultTextFormat;
        format.font = "_sans";
        _field.defaultTextFormat = format;
        
        addChild(_field);
        
        var button:Sprite = new Sprite();
        button.graphics.lineStyle(1, 0xBBBBBB);
        button.graphics.beginFill(0xEEEEEE);
        button.graphics.drawRoundRect(0, 0, 100, 20, 5, 5);
        button.graphics.endFill();
        
        addChild(button);
        
        button.x = 20;
        button.y = 20;
        button.mouseChildren = false;
        button.buttonMode = true;
        
        var field:TextField = new TextField();
        field.width = 100;
        field.height = 20;
        field.htmlText = "<p align='center'><font face='_sans'>再計算</span></p>";
        
        button.addChild(field);
        
        button.addEventListener(MouseEvent.CLICK, function ():void
        {
            _field.text = "";
            _init();
        });
    }
}

}

import org.libspark.thread.Thread;

internal class FuncThread extends Thread{
    private var _func:Function;
    private var _args:Array;
    public function FuncThread(func:Function, args:Array = null){
        _func = func;
        _args = args;
    }
    override protected function run():void {
        _func.apply( this, _args );
    }
}
