/**
 * Copyright jakman4242 ( http://wonderfl.net/user/jakman4242 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wXXz
 */

// forked from Arkatufus's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: flash on
// forked from scarybug's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: flash on 2009-12-3
// http://forums.tigsource.com/index.php?topic=9549.0
// TIGSource collaborative game expriment #1

package {
	import flash.display.*;
	import flash.events.KeyboardEvent;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.geom.Point;
	import flash.text.TextField;
       
	[SWF(width=465, height=465, frameRate=60)]
	public class CollabGame extends Sprite {

		public var player:Player;

		public var enemies:Array;
		public var flaggedEnemies:Array;
		public var freedomPool:Array;

		private var inputArray:Array;
		public var drawing_area:Bitmap;
		private var trail_image:Shape;
		private var updateList:Array;

		private var scoreLabel:TextField;

		public var score:int=0;
		public var multiplier:int=1;

		public function CollabGame():void {
			initInput();
			initGame();
		}

		private function initInput():void {

			this.inputArray = new Array();
			for (var i:uint =0; i < 256; i++) {
				inputArray.push(false);
			}

			stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
			this.addEventListener(Event.ENTER_FRAME, updateGame);
		}

		public function onKeyDown(e:KeyboardEvent):void {
			inputArray[e.keyCode]=true;
		}

		public function onKeyUp(e:KeyboardEvent):void {
			inputArray[e.keyCode]=false;
		}

		public function collision():void {
			var i:int;
			var enemy:Enemy;

			for (i=enemies.length; i--; ) {
				enemy=enemies[i];
				if (enemy.hitTestPoint(player.x,player.y)) {
					enemy.flag();
				}
			}

		}

		public function updateGame(e:Event):void {

			scoreLabel.text="LEVEL: "+multiplier+" | SCORE: "+score;
			scoreLabel.autoSize="left";

			updateGameEntities();
			updateEnemies();
			collision();

			if (inputArray[37]) {
				player.rotation-=4;
			}

			if (inputArray[39]) {
				player.rotation+=4;
			}

			if (inputArray[38]) {
				player.move();
				player.speed=Math.abs(player.speed);
			}

			if (inputArray[40]) {
				player.move();
				player.speed=-1*Math.abs(player.speed);
			}

			if (inputArray[38]||inputArray[40]) {
				trail_image.x=player.x;
				trail_image.y=player.y;
				if ((inputArray[32] || inputArray[90]) &&player.ropeCount>0) {
					drawing_area.bitmapData.draw(trail_image, trail_image.transform.matrix);
					if (player.ropeCount>0) {
						player.ropeCount--;
					}
				}

			}
		}

		private function updateGameEntities():void {
			for (var i:uint=0; i < updateList .length; i++) {
				updateList[i].update();
			}
		}

		private function updateEnemies():void {
			if(flaggedEnemies.length == enemies.length){
				player.ropeCount=Player.defaultRopeCount;
				multiplier++;
				unflagAll();
			}
		}

		private function unflagAll():void {
			drawing_area.bitmapData.fillRect(new Rectangle(0, 0, 465, 465), 0xFFFFFF);
			for (var i:uint=0; i < enemies.length; i++) {
				enemies[i].unflag();
			}
			flaggedEnemies.length = 0;
			
			for (i=0; i<freedomPool.length; i++) {
				var freedom:Freedom=freedomPool[i];
				enemies.push(freedom);
				freedom.spawn();
				addGameEntity(freedom);
			}
			freedomPool.length=0;
		}

		private function addGameEntity(entity:GameEntity):void {
			updateList.push(entity);
			addChild(entity);
		}

		public function removeGameEntity(entity:GameEntity):void {
			updateList.splice(updateList.indexOf(entity), 1);
			removeChild(entity);
		}

		private function initGame():void {

			updateList = new Array();

			player = new Player();
			player.speed=3;
			drawing_area=new Bitmap(new BitmapData(465,465,false));
			addChild(drawing_area);
			addGameEntity(player);

			trail_image = new Shape();
			trail_image.graphics.beginFill(0x00FF00);
			trail_image.graphics.drawCircle(0, 0, 2);
			trail_image.graphics.endFill();

			player.x=465/2;
			player.y=465/2;
			player.rotation=180;
			player.ropeCount=Player.defaultRopeCount;
			
			flaggedEnemies = new Array();
			enemies = new Array();
			for (var i:uint=0; i < 15; i++) {
				var newEnemy:Enemy=new Enemy(this);
				enemies.push(newEnemy);
				newEnemy.x=Math.random()*465;
				newEnemy.y=Math.random()*465;
				newEnemy.rotation=Math.random()*360;
				addGameEntity(newEnemy);
			}

			freedomPool = new Array();
			var newFreedom:Freedom=new Freedom(this);
			enemies.push(newFreedom);
			addGameEntity(newFreedom);
			newFreedom.spawn();

			scoreLabel = new TextField();
			scoreLabel.text="SCORE: 0";
			addChild(scoreLabel);

		}

	}
}

import flash.display.Sprite;
internal class GameEntity extends Sprite {
	//x and y velocities
	public var vx:Number=0;
	public var vy:Number=0;
	public var speed:Number = 1;        
  
	public function GameEntity (){}
	public function update() : void {}

	public function updateVelocities():void{
		vx = speed*Math.sin(Math.PI -this.rotation*0.0174532925);
		vy = speed*Math.cos(Math.PI -this.rotation*0.0174532925);
	}

	public function move():void{
		updateVelocities();
		x -= vx;
		y -= vy;
		if(y > 470) y = -10; 
		if(y < -10) y = 470;
		if(x > 470) x = -10;
		if(x < -10) x = 470;
	}
}

internal class Player extends GameEntity {
	public var ropeCount:int=0;
	public static var defaultRopeCount:int=500;
	public function Player() {
		graphics.beginFill(0x00ff00);
		graphics.drawCircle(0,0,10);
		graphics.endFill();

		graphics.beginFill(0x0000ff);
		graphics.drawRect(-1,0,2,10);
		graphics.endFill();
	}
}

internal class Enemy extends GameEntity {
	public var is_flagged:Boolean = false;
	public var turnDeviation:Number = 0;
	protected var game:CollabGame;

	public function Enemy (cg:CollabGame){
		super();
		game = cg;
		speed =  1; 
		graphics.beginFill(0xff0000);
		graphics.drawCircle(0,0,15);           
		graphics.endFill();    
		
		graphics.beginFill(0x0000ff);
		graphics.drawRect(-1,0,2,10);           
		graphics.endFill();                 

	}

	public override function update() : void {
		turnDeviation += Math.random() * 2 - 1;
		if(turnDeviation > 4) turnDeviation = 4;
		if(turnDeviation < -4) turnDeviation = -4;
		rotation += turnDeviation;
		move();  
		
		if(!is_flagged && game.drawing_area.bitmapData.getPixel(x,y)==0x00FF00){
			rotation+=180;
			move();   //move again to free yourself if you're caught!
		}

	}


	public function flag() : void {
		if(!is_flagged){
			game.score += game.multiplier;
			is_flagged = true;
			game.flaggedEnemies.push(this);
			
			graphics.clear();
			graphics.beginFill(0x0000ff);
			graphics.drawCircle(0,0,15);           
			graphics.endFill();    
			this.scaleX -=0.1;
			this.scaleY -=0.1;
			graphics.beginFill(0x00ff00);
			graphics.drawRect(-1,0,2,10);           
			graphics.endFill();           
		}  
	}

	public function unflag() : void {
		if(is_flagged){
			speed +=  1; 
			is_flagged = false;
			
			graphics.clear();
			graphics.beginFill(0xff0000);
			graphics.drawCircle(0,0,15);           
			graphics.endFill();    
			
			graphics.beginFill(0x0000ff);
			graphics.drawRect(-1,0,2,10);           
			graphics.endFill();           
		}  
	}

	public function resurrect():void{
		if(is_flagged){
			game.score -= game.multiplier;
			is_flagged = false
			this.scaleX +=0.1;
			this.scaleY +=0.1;
			game.flaggedEnemies.splice(game.flaggedEnemies.indexOf(this), 1);
			
			graphics.clear();
			graphics.beginFill(0xff0000);
			graphics.drawCircle(0,0,15);           
			graphics.endFill();    
			
			graphics.beginFill(0x0000ff);
			graphics.drawRect(-1,0,2,10);           
			graphics.endFill();           
		}  
	}
}

internal class Freedom extends Enemy{
	private var life:int;
	private var strategy:Strategy;
	private var invincible:int;

	public function Freedom(cg:CollabGame) {
		super(cg);
		speed=0.1;
		graphics.beginFill(0xff00ff);
		graphics.drawCircle(0,0,15);
		graphics.endFill();

		graphics.beginFill(0x00ff00);
		graphics.drawRect(0,-1,10,2);
		graphics.endFill();
	}

	public function spawn():void {
		life = 3;
		speed += 1;
		strategy=new RunAway(this,game.player);
	}

	override public function flag():void {
		if (invincible>0) {
			return;
		}
		invincible=240;
		life--;
		if (life==0) {
			game.enemies.splice(game.enemies.indexOf(this), 1);
			game.freedomPool.push(this);
			game.removeGameEntity(this);
			return;
		}
		strategy=new RunAway(this,game.player);
	}

	override public function update():void {
		if (strategy is WanderAround&&game.flaggedEnemies.length > 0) {
			strategy=new SeekBlue(this, game.flaggedEnemies);
		}
		if (strategy.update()) {
			strategy=new WanderAround(this);
			strategy.update();
		}
		move();
		invincible--;
	}

	override public function move():void {
		strategy.move();
	}
}

internal class SeekBlue implements Strategy{
	private var owner:GameEntity;
	private var target:Enemy;
	private var targets:Array;

	private var dx:Number;
	private var dy:Number;
	private var _distance:Number;

	public function SeekBlue(o:GameEntity, t:Array):void {
		owner=o;
		targets=t;
		target=targets[0];
		trace("SeekBlue");
	}

	public function update():Boolean {
		if (_distance<2) {
			target.resurrect();
		}
		if (targets.length==0) {
			return true;
		}

		target=targets[0];

		dx=target.x-owner.x;
		dy=target.y-owner.y;
		var rot:Number=Math.atan2(dy,dx)*57.2957795131;
		owner.rotation=rot;
		return false;
	}

	public function move():void {
		_distance=Math.sqrt(dx*dx+dy*dy);
		var factor:Number=1/_distance*owner.speed;
		owner.x+=dx*factor;
		owner.y+=dy*factor;
	}
}

internal class RunAway implements Strategy{
	private var owner:GameEntity;
	private var target:Player;

	private var dx:Number;
	private var dy:Number;
	private var _distance:Number;

	public function RunAway(o:GameEntity, t:Player):void {
		owner=o;
		target=t;
		trace("RunAway");
	}

	public function update():Boolean {
		if (_distance>200) {
			return true;
		}
		dx=owner.x-target.x;
		dy=owner.y-target.y;
		var rot:Number=Math.atan2(dy,dx)*57.2957795131;
		owner.rotation=rot;
		return false;
	}

	public function move():void {
		_distance=Math.sqrt(dx*dx+dy*dy);
		var factor:Number=1/_distance*owner.speed;
		owner.x+=dx*factor;
		owner.y+=dy*factor;
	}
}

internal class WanderAround implements Strategy{
	private var owner:GameEntity;
	public var turnDeviation:Number = 0;
	public var vx:Number=0;
	public var vy:Number=0;

	public function WanderAround(o:GameEntity):void{
		owner = o;
		trace("WanderAround");
	}

	public function update():Boolean{
		turnDeviation += (-1 + (Math.random() * 2));
		if(turnDeviation > 4) turnDeviation = 4;
		if(turnDeviation < -4) turnDeviation = -4;
		owner.rotation += turnDeviation;
		return false;
	}

	public function move():void{
		vx = owner.speed*Math.sin(Math.PI - owner.rotation*0.0174532925);
		vy = owner.speed*Math.cos(Math.PI - owner.rotation*0.0174532925);
		var x:Number = owner.x;
		var y:Number = owner.y;
		
		x -= (vx);
		y -= (vy);
		if(y > 470) y = -10; 
		if(y < -10) y = 470;
		if(x > 470) x = -10;
		if(x < -10) x = 470;
		owner.x = x;
		owner.y = y;
	}		
}

internal interface Strategy{
	function update():Boolean;
	function move():void;
}