/**
 * Copyright nbernaz ( http://wonderfl.net/user/nbernaz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wXCr
 */

// forked from daniwell's Text To Speech(Google API) - Change Speed
/**
 * Text To Speech(Google API) - Change Speed
 * 
 * Modified version = talks french, spanish, gernam and english.
// N Bernaz - June 2011
 */
package  
{
    import com.bit101.components.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.events.SampleDataEvent;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import flash.utils.ByteArray;
    import flash.text.TextField;
     
     
// New imports go below
    

    
// New imports go above


    [SWF(backgroundColor = "0xC6F7B0", frameRate = "30", width = "465", height = "465")]
    public class TextToSpeechTest extends Sprite
    {
        private const BUFFER_LENGTH :Number = 2048;
        private var _inputTx  :InputText;
        private var _apiSound :Sound;
        private var _sound    :Sound = new Sound();
        private var _samples  :ByteArray = new ByteArray();
        private var _channel  :SoundChannel = new SoundChannel();
        private var _pan      :Number;    
        private var _speed    :Number;    
        private var _position :Number;    
        private var _total    :Number;
    
//  New vars go below
   
  
  
  
  
      
 // New vars go above   
   
      
        
        public function TextToSpeechTest() 
        {
            _initView();
            stage.addEventListener(MouseEvent.MOUSE_MOVE, _mouseMoveHandler);
        }
        /* View */
        private function _initView():void
        {
            _inputTx = new InputText(this, 10, 250, "Type your text here");
            _inputTx.width = 400;

         
                new PushButton(this, 200, 272, "French", _changeToFrench);
                new PushButton(this, 200, 298, "Spanish", _changeToSpanish);
                new PushButton(this, 310, 272, "German", _changeToGerman);
                 new PushButton(this, 310, 298, "English", _changeToEnglish);
        
            // lines
            graphics.lineStyle(0, 0xaaaaaa);
            graphics.moveTo(465/2,   30); 
            graphics.lineTo(465/2, 465/2);               
            graphics.moveTo(465/2-4, 30);
            graphics.lineTo(465/2+4, 30); 
            graphics.moveTo(465/2-4, 465/4);
            graphics.lineTo(465/2+4, 465/4);
            graphics.moveTo(10, 465/2);
            graphics.lineTo(455, 465/2);
             graphics.moveTo(10, 465/2+5);
            graphics.lineTo(455, 465/2+5);
          
    graphics.moveTo(10, 385);
            graphics.lineTo(455, 385);
          
            
            // labels
            new Label(this, 465/2-72, 20, "Speak faster");
              new Label(this, 465/2-72, 465/2.2, "Speak slower");
                new Label(this, 465/2-72, 465/4.4, "Normal speech");
            new Label(this, 465/2+4, 20, "2");
            new Label(this, 465/2+4, 465/4.4, "1");
            new Label(this, 465/2+4, 465/2.2, "0");
            new Label(this, 10, 330, "Type your text in the box, and select the language you want.");
            new Label(this, 10, 345, "Then move the mouse towards the [1] on the axis and the speaking will start.");
            new Label(this, 10, 360, "If the mouse goes below the double line which says [0], speaking will stop.");
           new Label(this, 10, 390, "(C) N Bernaz 2011 - Based on Daniwell's Text To Speech(Google API)");
new Label(this, 10, 400, "Released under the MIT Licence & Wonderfl.net T&C");


        }
         
          private function _changeToFrench (evt :Event) :void
        {
          _channel.stop();
            _sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, _sampleDataHandler);
            
            var path :String = "http://translate.google.com/translate_tts?tl=fr&q=" + encodeURI(_inputTx.text);
            
            _apiSound = new Sound();
            _apiSound.addEventListener(Event.COMPLETE, _completeHandler);
            _apiSound.load(new URLRequest(path));
        }

          private function _changeToSpanish (evt :Event) :void
        {
            _channel.stop();
            _sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, _sampleDataHandler);
            
            var path :String = "http://translate.google.com/translate_tts?tl=es&q=" + encodeURI(_inputTx.text);
            
            _apiSound = new Sound();
            _apiSound.addEventListener(Event.COMPLETE, _completeHandler);
            _apiSound.load(new URLRequest(path));
        }
         
          private function _changeToGerman(evt :Event) :void
        {
            _channel.stop();
            _sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, _sampleDataHandler);
            
            var path :String = "http://translate.google.com/translate_tts?tl=de&q=" + encodeURI(_inputTx.text);
            
            _apiSound = new Sound();
            _apiSound.addEventListener(Event.COMPLETE, _completeHandler);
            _apiSound.load(new URLRequest(path));
        }
        

          private function _changeToEnglish(evt :Event) :void
        {
            _channel.stop();
            _sound.removeEventListener(SampleDataEvent.SAMPLE_DATA, _sampleDataHandler);
            
            var path :String = "http://translate.google.com/translate_tts?tl=en&q=" + encodeURI(_inputTx.text);
            
            _apiSound = new Sound();
            _apiSound.addEventListener(Event.COMPLETE, _completeHandler);
            _apiSound.load(new URLRequest(path));
        }
         
         
         
         

        
        /* SOUND LOAD COMPLETE */
        private function _completeHandler (evt :Event) :void 
        {
            _apiSound.removeEventListener(Event.COMPLETE, _completeHandler);
            _position = 0;
            
            _samples = new ByteArray();
            _apiSound.extract(_samples, 1000000);
            _total = _samples.length / 8;
            
            _sound.addEventListener(SampleDataEvent.SAMPLE_DATA, _sampleDataHandler);
            _channel = _sound.play();
        }
        
        /* MOUSE MOVE */
        private function _mouseMoveHandler (evt :MouseEvent) :void 
        {
         
         // pan is ignored to get best possible sound in stereo
           _pan   = - 1;
        
         // speed is not allowed to get in the negative at it serves no purpose at this stage
   
           if      ((1 - mouseY * 2 / 465) * 2 < 0)            _speed = 0;
                else if  ((1 - mouseY * 2 / 465) * 2 > 0)      _speed =   (1 - mouseY * 2 / 465) * 2;
         
        }
        
        /* SAMPLE DATA */
        private function _sampleDataHandler (evt :SampleDataEvent) :void 
        {
            var left :Number, right :Number;
            
            for (var c :int = 0; c < BUFFER_LENGTH; c ++)
            {
                _position += _speed;
                if      (_position < 0)            _position = _total-1;
                else if (_total-1 < _position)    _position = 0;
                
                _samples.position = int(_position) * 8;
                
              left  = (_pan < 0) ? _samples.readFloat():_samples.readFloat() * (1 - _pan);
              right = (0 < _pan) ? _samples.readFloat():_samples.readFloat() * (1 + _pan);
              
             
                
                evt.data.writeFloat(left);
                evt.data.writeFloat(right);
            }
        }
    }
}




















