/**
 * Copyright mio_____ ( http://wonderfl.net/user/mio_____ )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wX3y
 */

// forked from mex_takagi's forked from: 【AS100本ノック】4回目：オータム（秋）

package 
{
    import flash.display.Sprite;
    import flash.display.GradientType;
    import flash.display.SpreadMethod;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.utils.Timer;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.events.TweenEvent;
    /**
     * @author Mao Takagi
     * editted by mio 2011.01
     */
    [SWF(backgroundColor="#FFFFFF", frameRate="30", width="465", height="465")]
    public class Main extends Sprite
    {
        private var _gradient:Sprite;
        private var _bgColor:Sprite;
        private var _tree:Tree;
        private var _snowTimer:Timer;
        private var _snowField:Sprite;
        private var _blur:BlurFilter;
        /**
         * constructor
         */
        public function Main()
        {
            Wonderfl.capture_delay(5);
            _gradient = new Sprite();
            _bgColor = createGradient();
            _gradient.addChild(_bgColor);
            
            _snowTimer = new Timer(1000);
            _snowField = new Sprite();
            _blur = new BlurFilter();
            _snowField.filters = [_blur];
            
            _tree = new Tree();
            _tree.x = 465 / 2;
            _tree.y = 465;
            _gradient.mask = _tree;
            addChild(_gradient);
            addChild(_tree);
            addChild(_snowField);
    
            // 木を作り終えたら        
            //_tree.addEventListener(Event.COMPLETE, generateTreeComplete);
        }
        
        /**
         * グラデーション作成
         * @return Sprite
         */
         
        private function createGradient():Sprite
        {
            var sprite:Sprite = new Sprite();
            /*
            //↓ カラフルな木にする場合
            var colors:Array = [0x794E46, 0x05FA05, 0xECEC13, 0xF80E0E];
            var alphas:Array = [1, 1, 1, 1];
            var ratios:Array = [30, 60, 110, 225];
            */
            var colors:Array = [0x221100, 0x000000];
            var alphas:Array = [1, 1];
            var ratios:Array = [30, 60];
            var matrix:Matrix = new Matrix();
            matrix.createGradientBox(465, 465, -Math.PI / 2);
            sprite.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix);
            sprite.graphics.drawRect(0, 0, 465, 465);
            sprite.graphics.endFill();
            return sprite;
        }
        
    }
}
/**
 * 木クラス
 */
import flash.display.Sprite;
import flash.events.Event;
class Tree extends Sprite 
{
    private var _lastGeneration:uint;
    private var _nowGeneration:uint;
    private var _rotArray:Array;
    private var _branchArray:Array;
    private var _judge:uint;
    /**
     * constructor
     */
    public function Tree():void
    {
        rotation = 180;
        
        _lastGeneration = 6;// ループ回数 ： 7 以上は危険です。
        
        _nowGeneration = 0;
        _judge = 0;
        _rotArray = [ -40, 40, 0];//3本生えてくる枝の、決め打ちの角度
        _branchArray = new Array();
        var mainBranch:Branch = new Branch(160);
        createBranch(mainBranch, mainBranch.height);
        addChild(mainBranch);
    }
    /**
     * 枝を_generationMaxの世代まで再帰的に作成。
     * @param p 親の枝
     * @param baseLen 親の枝の長さ
     */
    private function createBranch(p:*, baseLen:Number):void
    {
        _judge = Math.pow(3, _nowGeneration + 1);
        
        
        for (var i:uint = 0; i < 3;　i++ )
        {
            var branch:Branch = new Branch();
            //var perLen:Number = baseLen / 3;//mio memo ここで分岐点を定義？
            var perLen:Number = baseLen / 3;
            
            //var perLen:Number = p.height / 3;
            
            _branchArray.push(branch);
            
            if( i!=2){
                //　途中の枝の位置を、ある程度ランダムにする。
                branch.y =  perLen * i + perLen/2 + Math.random() * perLen;
            }else{
                // 最後の枝（枝の先端に継ぎ足される部分）
                branch.y =  perLen * i + perLen;
            }

                        
            branch.addEventListener(Event.COMPLETE, function():void
            {
                branch.removeEventListener(Event.COMPLETE, arguments.callee);
                _judge--;
                if (_judge == 0)
                {
                    _nowGeneration++;
                    if (_nowGeneration != _lastGeneration)
                    {
                        var j:uint = 0;
                        var nextLen:uint = _branchArray.length;
                        var nextArray:Array = new Array();
                        
                        for (j = 0; j < nextLen; j++ )
                        {
                            nextArray.push(_branchArray[j]);
                        }
                        
                        _branchArray = [];
                        
                        for (j = 0; j < nextLen;j++ )
                        {
                            // ここで、再帰処理
                            createBranch(nextArray[j], perLen * 2);
                        }
                    }
                    else if (_nowGeneration == _lastGeneration)
                    {
                        //ここで終了
                        dispatchEvent(new Event(Event.COMPLETE));
                    }
                }
            } );
            
            p.addChild(branch);
            
            // 枝の回転角度をランダムに
            var rot:Number = Math.random()* 20 - 10 + _rotArray[i];
            
            branch.Start(perLen * 2, rot);
        }
    }
}
/**
 * 枝クラス
 */
import flash.display.Sprite;
import flash.events.Event;
import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.events.TweenEvent;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.easing.*;
import caurina.transitions.Tweener;

class Branch extends Sprite
{
    private var _graphic:Sprite;
    /**
     * constructor
     * @param len 長さの初期値
     */
    public function Branch(len:Number = 1):void
    {
        _graphic = new Sprite();
        /*
        _graphic.graphics.lineStyle(1, 0x000000, 1, false, 'none');
        _graphic.graphics.lineTo(0, len);
        */
        _graphic.graphics.beginFill(0x000000);
        _graphic.graphics.drawRect(0, 0, 1, len + Math.random());
        _graphic.graphics.endFill();
        addChild(_graphic);
    }
    /**
     * にょきにょき
     * @param len 目標の長さ
     * @param rot 角度
     */
    public function Start(len:Number, rot:Number):void 
    {
        //trace(len);
        //rotation = 0;
        //rotation = rot;
        
        var delayTime:Number = Math.random() * 0.5;
        Tweener.addTween(_graphic, { delay:delayTime, time:0.3, height:len, onComplete:onComplete } );
        
        Tweener.addTween(this, {delay:delayTime, time:1.4, rotation:rot});
    }
    /**
     * 
     * @param 
     */
    private function onComplete():void 
    {
        dispatchEvent(new Event(Event.COMPLETE));
    }
}