/**
 * Copyright moyashi ( http://wonderfl.net/user/moyashi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wW1c
 */

/*
Union Platformのテスト

試験用サーバーとして提供されている"tryunion.com"にて

Messageを送信してから、実行されるまでのタイムラグ図ってみた



Roomに入室後、画面クリックでMessageを送信

RoomがMessageを受け取るとランダムに円を描きます
*/

package {
    import flash.ui.Mouse;
    import flash.display.*
    import flash.events.*
    import flash.text.*
    
    import net.user1.reactor.*
    
    public class FlashTest extends Sprite {
        
        public var reactor:Reactor
        public var poot:int=80
        public var url:String="tryunion.com"
        
        private var _room:Room
        
        private var txt:TextField
        
        private var dd:Date
        private var old_time:Number
        private var now_time:Number
        
        public function FlashTest() {
            reactor=new Reactor()
            
            reactor.addEventListener(ReactorEvent.READY,onREADY)
            reactor.addEventListener(ReactorEvent.CLOSE,onCLOSE)
            
            reactor.connect(url,poot)
            
            
            txt=new TextField()
            txt.autoSize=TextFieldAutoSize.LEFT
            txt.text="接続確認中..."
            txt.x=20
            txt.y=20
            addChild(txt)
        }
        
        private function onREADY(e:ReactorEvent):void{
            txt.text="接続成功"
            
            _room=reactor.getRoomManager().createRoom("Test_Room")
            
            _room.addEventListener(RoomEvent.JOIN,onJOIN)
            _room.addMessageListener("create",onCreate)
            
            _room.join()
        }
        
        private function onCLOSE(e:ReactorEvent):void{
            txt.text="接続失敗"
        }
        
        private function onJOIN(e:RoomEvent):void{
            txt.text=e.target.toString()+" に入室しました"
            
            stage.addEventListener(MouseEvent.CLICK,onCLICK)
        }
        
        private function onCLICK(e:MouseEvent):void{
            _room.sendMessage("create",true,null,e.stageX,e.stageY)
            
            dd=new Date()
            old_time=dd.getTime()
        }
        
        private function onCreate(fromClient:IClient,xx:Number,yy:Number):void{
            graphics.beginFill(0x888888-0x777777*Math.random())
            graphics.drawCircle(xx,yy,20*Math.random())
            
            dd=new Date()
            now_time=dd.getTime()
            
            txt.text="Messageを送信してから実行までの時間 : "+(now_time-old_time).toString()
        }
    }
}