/**
 * Copyright JorgeBraccini ( http://wonderfl.net/user/JorgeBraccini )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wVhf
 */

package {
    
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.events.TimerEvent;
    import flash.filters.BlurFilter;
    import flash.geom.Vector3D;
    import flash.utils.Timer;
    
    import net.badimon.five3D.display.Scene3D;
    import net.badimon.five3D.display.Sprite3D;
    
    [SWF(backgroundColor="#FFFFFF", width="800", height="600")]
    public class Five3DA extends Sprite {
        
        private var _scene:Scene3D;
        private var _sprite_a:Sprite3D;
        private var _sprite_b:Sprite3D;
        private var _container:Sprite3D;
        
        private var _timer :Timer;
        
        private var _ang:Number = 0;
        private var _radius:Number = 200;
        
        public function Five3DA(){
            init();
        }
        
        private function init():void {
            
            var w:Number = 150;
            var h:Number = 150;
            
            _scene = new Scene3D();
            _scene.x = stage.stageWidth / 2;
            _scene.y = stage.stageHeight /2;
            
            _container = new Sprite3D();
            _container.childrenSorted = true;
            
            _scene.ambientLightVector = new Vector3D();
            
            
            _sprite_a = new Sprite3D();
            _sprite_a.graphics3D.beginFill(0xFF0000);
            _sprite_a.graphics3D.drawRect(-(w/2), -(h/2), w, h);
            _sprite_a.graphics3D.endFill();
            
            _sprite_b = new Sprite3D();
            _sprite_b.graphics3D.beginFill(0x0000FF);
            _sprite_b.graphics3D.drawRect(-(w/2), -(h/2), w, h);
            _sprite_b.graphics3D.endFill();
            
            _sprite_a.buttonMode = true;
            _sprite_b.buttonMode = true;
            
            _sprite_a.addEventListener(MouseEvent.ROLL_OVER,handleRollOver);
            _sprite_a.addEventListener(MouseEvent.ROLL_OUT, handleRollOut);
            
            _sprite_b.addEventListener(MouseEvent.ROLL_OVER,handleRollOver);
            _sprite_b.addEventListener(MouseEvent.ROLL_OUT, handleRollOut);
            
            _container.addChild(_sprite_a);
            _container.addChild(_sprite_b);
            _scene.addChild(_container);
            addChild(_scene);
            
            _timer = new Timer(33);
            _timer.addEventListener(TimerEvent.TIMER, handleTick);
            _timer.start();
            
        }
        
        private function handleTick(e:TimerEvent):void {
            
            _sprite_a.x = Math.sin(_ang) * _radius;
            _sprite_a.z = Math.cos(_ang) * _radius;
            
            _sprite_b.x = Math.sin(_ang + Math.PI) * _radius;
            _sprite_b.z = Math.cos(_ang + Math.PI) * _radius;
            
            
            _ang+=Math.PI/100;
            
            _container.rotationZ+=.3;
            
        }
        
        private function handleRollOver(e:MouseEvent):void {
            e.target.alpha = .5;
        }
        
        private function handleRollOut(e:MouseEvent):void {
            e.target.alpha = 1;
        }
        
        
        
    }

}
