/**
 * Copyright fantasista ( http://wonderfl.net/user/fantasista )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wVSg
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    //import flash.text.TextField;
    //import flash.text.TextFieldAutoSize;
    //import flash.utils.ByteArray;
    import com.flashdynamix.utils.SWFProfiler;
    
    [SWF (backgroundColor = "0x0", frameRate = "30", width = "465", height = "465")]
    
    public class BlurLine extends Sprite {
        
        public function BlurLine() {
            
            SWFProfiler.init(this);
            
            if (stage) {
                init(); 
            }else {
                addEventListener(Event.ADDED_TO_STAGE, init);
            }
        }
        
        private var _bmd:BitmapData;
        private var _canvas:Bitmap;
        private var _dispf:DisplacementMapFilter;
        private var _point:Point;
        private var _colorTf:ColorTransform;
        private var _blur:BlurFilter;
        private var _x:Number;
        private var _y:Number;
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            _canvas = new Bitmap(_bmd);
            addChild(_canvas);
            
           // _dispf = new DisplacementMapFilter(noise, basePoint, BitmapDataChannel.RED, BitmapDataChannel.GREEN, 500, 500, DisplacementMapFilterMode.WRAP);
           // _bmd.filters = [dispf];
           // colorTf = new ColorTransform(1, 1, 1, 1, - 4, - 1, - 1);
           _point = new Point();
            _blur = new BlurFilter();     
            
            _x = stage.stageWidth/2;
            _y = stage.stageHeight/2;
            addEventListener(Event.ENTER_FRAME, upDate);
        }
        
        private function upDate(e:Event):void {
            _bmd.lock();
            
            var line:Shape = new Shape();
            line.graphics.beginFill(0xFFFFFF);
            line.graphics.lineStyle(10, 0xFFFFFF);
            line.graphics.moveTo(_x, _y);
            line.graphics.lineTo(mouseX, mouseY);
            line.graphics.endFill();
            
            _bmd.draw(line);
            _bmd.applyFilter(_bmd, _bmd.rect, _point, _blur);
            _bmd.unlock();
            
            line = null;
            _x = mouseX;
            _y = mouseY;
            
        }
    }
}