/**
 * Copyright fakestar0826 ( http://wonderfl.net/user/fakestar0826 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/wVIh
 */

// forked from fakestar0826's flash on 2011-1-30
package {
    import flash.text.TextField;
    import flash.display.Shape;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    
    [SWF(backgroundColor="0x000000")]
    public class FlashTest extends MovieClip
    {
        private var whiteBall:Sprite;
        private var balls:Array;
        private var canvas3D:Sprite;
        
        public function FlashTest() {
            // write as3 code here..
            balls = new Array();
            canvas3D = new Sprite();
            canvas3D.graphics.beginFill(0);
            canvas3D.graphics.drawRect(-stage.stageWidth / 2, -stage.stageHeight / 2, stage.stageWidth, stage.stageHeight);
            canvas3D.graphics.endFill();
            canvas3D.x = stage.stageWidth / 2;
            canvas3D.y = stage.stageHeight / 2;
            addChild(canvas3D);
            
            var colorfulBall:Sprite;
            for(var i:int = 0;i < 12;i++)
            {
                colorfulBall = makeBall(-200, 300 * Math.cos((30 * i) * (Math.PI / 180)), 20, Math.random() * 0xFFFFFF);
                colorfulBall.z = 500 + 500 * Math.sin((30 * i) * Math.PI / 180);
                balls.push(colorfulBall);
            }
            
            
            for(i = 0;i < 12;i++)
            {
                colorfulBall = makeBall(0, 300 * Math.cos((30 * i) * (Math.PI / 180)), 20, Math.random() * 0xFFFFFF);
                colorfulBall.z = 500 + 500 * Math.sin((30 * i) * Math.PI / 180);
                balls.push(colorfulBall);
            }
            
            for(i = 0;i < 12;i++)
            {
                colorfulBall = makeBall(200, 300 * Math.cos((30 * i) * (Math.PI / 180)), 20, Math.random() * 0xFFFFFF);
                colorfulBall.z = 500 + 500 * Math.sin((30 * i) * Math.PI / 180);
                balls.push(colorfulBall);
            }
            
            balls.sortOn("z", Array.NUMERIC | Array.DESCENDING);
            for(i = 0;i < 36;i++)
            {
                canvas3D.addChild(balls[i]);
            }
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
        
        private function onEnterFrame(e:Event):void
        {
            canvas3D.x = mouseX;
        }

        private function makeBall(x:int, y:int, r:int, c:uint):Sprite
        {
            var b:Sprite = new Sprite();
            b.graphics.beginFill(c);
            b.graphics.drawCircle(0, 0, r);
            b.graphics.endFill();
            b.x = x;
            b.y = y;
            
            return b;
            
        }
        

    }
}